<?php
require_once __DIR__ . '/../../app/config/config.php';

// Check authentication dan role
Session::checkAuth();
Session::checkRole(['siswa']);

$userData = Session::getUserData();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Siswa - Sistem Penilaian</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-info">
        <div class="container">
            <a class="navbar-brand" href="#">Sistem Penilaian - Siswa</a>
            <div class="navbar-nav ms-auto">
                <span class="navbar-text me-3">
                    Halo, <?= $userData['nama'] ?> (Siswa)
                </span>
                <a class="nav-link text-white" href="../logout.php">Logout</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="alert alert-info">
            <h4>Dashboard Siswa 🎉</h4>
            <p>Login berhasil sebagai <strong>Siswa</strong></p>
            <hr>
            <p><strong>User Data:</strong></p>
            <pre><?php print_r($userData); ?></pre>
        </div>
        
        <div class="mt-4">
            <h5>Quick Actions:</h5>
            <div class="d-grid gap-2 d-md-flex">
                <a href="nilai.php" class="btn btn-info">Lihat Nilai</a>
                <a href="profil.php" class="btn btn-secondary">Profil Saya</a>
            </div>
        </div>
    </div>
</body>
</html>