<?php
require_once __DIR__ . '/../../app/config/config.php';
Session::checkAuth();
Session::checkRole(['guru']);

// Enable error reporting untuk debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

$guruModel = new GuruModel();
$userData = Session::getUserData();
$guruId = $userData['guru_id'];

// ==================== DEBUG START ====================
echo "<!-- ========== DEBUG INFORMATION ========== -->\n";
echo "<!-- Guru ID: " . $guruId . " -->\n";
echo "<!-- Guru Name: " . $userData['nama'] . " -->\n";

// Get tahun ajaran aktif
$tahunAktif = $guruModel->getActiveTahunAjaran();
echo "<!-- Tahun Ajaran Aktif: " . ($tahunAktif ? $tahunAktif['tahun_ajaran'] : 'Tidak ditemukan') . " -->\n";

// Get mapel_id and kelas_id from URL
if (isset($_GET['mapel_kelas'])) {
    $mapelKelas = explode('_', $_GET['mapel_kelas']);
    $mapelId = intval($mapelKelas[0]);
    $kelasId = intval($mapelKelas[1]);
} else {
    $mapelId = isset($_GET['mapel_id']) ? intval($_GET['mapel_id']) : 0;
    $kelasId = 0;
}

echo "<!-- Mapel ID from URL: " . $mapelId . " -->\n";
echo "<!-- Kelas ID from URL: " . $kelasId . " -->\n";

// Get guru's mapel list
$guruMapel = $guruModel->getGuruMapel($guruId);
echo "<!-- Total Guru Mapel: " . count($guruMapel) . " -->\n";

// Debug guru mapel details
foreach ($guruMapel as $index => $mapel) {
    echo "<!-- Mapel " . ($index + 1) . ": ID=" . $mapel['mapel_id'] . ", " . $mapel['nama_mapel'] . " - " . $mapel['nama_kelas'] . " (Kelas ID: " . $mapel['kelas_id'] . ") -->\n";
}

if (empty($guruMapel)) {
    die("<!-- ERROR: Tidak ada penugasan mengajar untuk guru ini. -->");
}

// If no mapel_id specified, use first one and redirect
if ($mapelId === 0 && !empty($guruMapel)) {
    $firstMapel = $guruMapel[0];
    $mapelId = $firstMapel['mapel_id'];
    $kelasId = $firstMapel['kelas_id'];
    echo "<!-- Redirecting to first mapel: " . $mapelId . " and kelas: " . $kelasId . " -->\n";
    header("Location: tp.php?mapel_kelas=" . $mapelId . "_" . $kelasId);
    exit();
}

// Validate access and get selected mapel
$hasAccess = false;
$selectedMapel = null;
foreach ($guruMapel as $mapel) {
    if ($mapel['mapel_id'] == $mapelId && $mapel['kelas_id'] == $kelasId) {
        $hasAccess = true;
        $selectedMapel = $mapel;
        break;
    }
}

echo "<!-- Access Validation: " . ($hasAccess ? 'GRANTED' : 'DENIED') . " -->\n";
echo "<!-- Selected Mapel: " . ($selectedMapel ? $selectedMapel['nama_mapel'] . ' - ' . $selectedMapel['nama_kelas'] : 'NULL') . " -->\n";
echo "<!-- Selected Kelas ID: " . ($selectedMapel ? $selectedMapel['kelas_id'] : 'NULL') . " -->\n";

if (!$hasAccess) {
    die("<!-- ERROR: Akses ditolak untuk mapel ini. -->");
}

// Handle form actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    echo "<!-- POST Request Detected -->\n";
    echo "<!-- POST Data: " . print_r($_POST, true) . " -->\n";
    
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'create_tp':
                echo "<!-- Action: CREATE TP -->\n";
                $data = [
                    'mapel_id' => $mapelId,
                    'kelas_id' => $kelasId,
                    'kode_tp' => $_POST['kode_tp'],
                    'deskripsi' => $_POST['deskripsi']
                ];
                
                echo "<!-- TP Data to Create: " . print_r($data, true) . " -->\n";
                
                if ($guruModel->createTP($data)) {
                    $_SESSION['flash_success'] = 'Tujuan Pembelajaran berhasil ditambahkan.';
                    echo "<!-- TP Creation: SUCCESS -->\n";
                } else {
                    $_SESSION['flash_error'] = 'Gagal menambahkan Tujuan Pembelajaran.';
                    echo "<!-- TP Creation: FAILED -->\n";
                }
                break;
                
            case 'update_tp':
                echo "<!-- Action: UPDATE TP -->\n";
                $tpId = intval($_POST['tp_id']);
                $data = [
                    'kode_tp' => $_POST['kode_tp'],
                    'deskripsi' => $_POST['deskripsi'],
                    'status' => $_POST['status'],
                    'kelas_id' => $kelasId
                ];
                
                echo "<!-- TP Data to Update: " . print_r($data, true) . " -->\n";
                echo "<!-- TP ID to Update: " . $tpId . " -->\n";
                
                if ($guruModel->updateTP($tpId, $data)) {
                    $_SESSION['flash_success'] = 'Tujuan Pembelajaran berhasil diperbarui.';
                    echo "<!-- TP Update: SUCCESS -->\n";
                } else {
                    $_SESSION['flash_error'] = 'Gagal memperbarui Tujuan Pembelajaran.';
                    echo "<!-- TP Update: FAILED -->\n";
                }
                break;
                
            case 'delete_tp':
                echo "<!-- Action: DELETE TP -->\n";
                $tpId = intval($_POST['tp_id']);
                echo "<!-- TP ID to Delete: " . $tpId . " -->\n";
                
                // Validasi akses sebelum hapus
                if ($guruModel->validateGuruTPAccess($guruId, $tpId)) {
                    if ($guruModel->deleteTP($tpId)) {
                        $_SESSION['flash_success'] = 'Tujuan Pembelajaran berhasil dihapus.';
                        echo "<!-- TP Delete: SUCCESS -->\n";
                    } else {
                        $_SESSION['flash_error'] = 'Gagal menghapus Tujuan Pembelajaran. Mungkin ada data terkait.';
                        echo "<!-- TP Delete: FAILED (mungkin ada data terkait) -->\n";
                    }
                } else {
                    $_SESSION['flash_error'] = 'Akses ditolak untuk menghapus TP ini.';
                    echo "<!-- TP Delete: ACCESS DENIED -->\n";
                }
                break;
                
            // TAMBAHKAN CASE BARU UNTUK FITUR IMPORT/EXPORT/DUPLIKASI
            case 'duplicate_tp':
                echo "<!-- Action: DUPLICATE TP -->\n";
                $sourceTpId = intval($_POST['tp_id']);
                $targetKelasId = intval($_POST['target_kelas_id']);
                $newKodeTP = $_POST['new_kode_tp'] ?? null;
                
                echo "<!-- Source TP ID: " . $sourceTpId . " -->\n";
                echo "<!-- Target Kelas ID: " . $targetKelasId . " -->\n";
                echo "<!-- New Kode TP: " . $newKodeTP . " -->\n";
                
                // Validasi akses
                if ($guruModel->validateGuruTPAccess($guruId, $sourceTpId)) {
                    if ($guruModel->duplicateTP($sourceTpId, $targetKelasId, $newKodeTP)) {
                        $_SESSION['flash_success'] = 'TP berhasil diduplikasi ke kelas tujuan.';
                        echo "<!-- TP Duplication: SUCCESS -->\n";
                    } else {
                        $_SESSION['flash_error'] = 'Gagal menduplikasi TP.';
                        echo "<!-- TP Duplication: FAILED -->\n";
                    }
                } else {
                    $_SESSION['flash_error'] = 'Akses ditolak untuk menduplikasi TP ini.';
                    echo "<!-- TP Duplication: ACCESS DENIED -->\n";
                }
                break;
                
            case 'import_tp':
                echo "<!-- Action: IMPORT TP -->\n";
                
                if (isset($_FILES['import_file']) && $_FILES['import_file']['error'] === UPLOAD_ERR_OK) {
                    $fileContent = file_get_contents($_FILES['import_file']['tmp_name']);
                    $importData = json_decode($fileContent, true);
                    
                    if ($importData && isset($importData['data']) && is_array($importData['data'])) {
                        $importResult = $guruModel->importTPData($mapelId, $kelasId, $importData['data']);
                        
                        if ($importResult !== false) {
                            $_SESSION['flash_success'] = 'Berhasil mengimport ' . $importResult . ' TP.';
                            echo "<!-- TP Import: SUCCESS, Count: " . $importResult . " -->\n";
                        } else {
                            $_SESSION['flash_error'] = 'Gagal mengimport data TP.';
                            echo "<!-- TP Import: FAILED -->\n";
                        }
                    } else {
                        $_SESSION['flash_error'] = 'Format file import tidak valid.';
                        echo "<!-- TP Import: INVALID FORMAT -->\n";
                    }
                } else {
                    $_SESSION['flash_error'] = 'File import tidak ditemukan atau error.';
                    echo "<!-- TP Import: FILE ERROR -->\n";
                }
                break;
        }
        echo "<!-- Redirecting to: tp.php?mapel_kelas=" . $mapelId . "_" . $kelasId . " -->\n";
        header("Location: tp.php?mapel_kelas=" . $mapelId . "_" . $kelasId);
        exit();
    }
}

// Get TP list for selected mapel DAN kelas
echo "<!-- Getting TP for Mapel ID: " . $mapelId . ", Kelas ID: " . $kelasId . " -->\n";
$tpList = $guruModel->getTPByMapel($mapelId, $kelasId);
echo "<!-- TP List Count: " . count($tpList) . " -->\n";

// Debug TP list details
foreach ($tpList as $index => $tp) {
    echo "<!-- TP " . ($index + 1) . ": ID=" . $tp['id'] . ", " . $tp['kode_tp'] . " - " . substr($tp['deskripsi'], 0, 50) . "... -->\n";
}

// Get available kelas for duplication
$availableKelas = $guruModel->getAvailableKelasForDuplication($guruId, $mapelId, $kelasId);
echo "<!-- Available Kelas for Duplication: " . count($availableKelas) . " -->\n";
foreach ($availableKelas as $index => $kelas) {
    echo "<!-- Kelas " . ($index + 1) . ": ID=" . $kelas['id'] . ", " . $kelas['nama_kelas'] . " (" . $kelas['tingkat'] . ") -->\n";
}

echo "<!-- ========== END DEBUG INFORMATION ========== -->\n";
// ==================== DEBUG END ====================
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tujuan Pembelajaran - Sistem Penilaian</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .navbar-brand {
            font-weight: 600;
        }
        
        .card {
            border-radius: 12px;
            border: none;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        }
        
        .card-header {
            border-radius: 12px 12px 0 0 !important;
            border-bottom: 1px solid rgba(0,0,0,0.05);
            font-weight: 600;
        }
        
        .btn {
            border-radius: 8px;
            font-weight: 500;
        }
        
        .mapel-selector {
            background: white;
            border-radius: 10px;
            padding: 1rem;
            margin-bottom: 1.5rem;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }
        
        .tp-item {
            border-left: 4px solid #007bff;
            background: white;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            transition: all 0.3s ease;
        }
        
        .tp-item:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        
        .empty-state {
            text-align: center;
            padding: 3rem 1rem;
            color: #6c757d;
        }
        
        .empty-state i {
            font-size: 4rem;
            margin-bottom: 1rem;
            opacity: 0.5;
        }
        
        .debug-panel {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
            font-family: 'Courier New', monospace;
            font-size: 0.875rem;
        }
        
        .debug-toggle {
            cursor: pointer;
            user-select: none;
        }
        
        .debug-content {
            display: none;
            margin-top: 1rem;
            background: white;
            padding: 1rem;
            border-radius: 4px;
            border: 1px solid #dee2e6;
        }

        .toast-container {
            z-index: 9999;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <!-- Debug Panel -->
        <div class="debug-panel">
            <div class="debug-toggle" onclick="toggleDebug()">
                <i class="bi bi-bug"></i> <strong>Debug Information</strong> 
                <small class="text-muted">(Click to expand)</small>
            </div>
            <div class="debug-content" id="debugContent">
                <div class="row">
                    <div class="col-md-6">
                        <strong>User Info:</strong><br>
                        Guru ID: <?= $guruId ?><br>
                        Nama: <?= htmlspecialchars($userData['nama']) ?><br>
                        Tahun Ajaran: <?= $tahunAktif ? $tahunAktif['tahun_ajaran'] : 'Tidak ditemukan' ?>
                    </div>
                    <div class="col-md-6">
                        <strong>Current Selection:</strong><br>
                        Mapel ID: <?= $mapelId ?><br>
                        Kelas ID: <?= $kelasId ?><br>
                        Mapel: <?= $selectedMapel ? htmlspecialchars($selectedMapel['nama_mapel']) : 'NULL' ?><br>
                        Kelas: <?= $selectedMapel ? htmlspecialchars($selectedMapel['nama_kelas']) : 'NULL' ?><br>
                    </div>
                </div>
                <div class="row mt-2">
                    <div class="col-12">
                        <strong>TP Statistics:</strong><br>
                        Total TP: <?= count($tpList) ?><br>
                        Available Mapel+Kelas: <?= count($guruMapel) ?><br>
                        Available Kelas for Duplication: <?= count($availableKelas) ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Header -->
        <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
            <div class="container">
                <a class="navbar-brand" href="dashboard.php">
                    <i class="bi bi-arrow-left"></i> Tujuan Pembelajaran
                </a>
                <div class="navbar-nav ms-auto">
                    <span class="navbar-text me-3">
                        <i class="bi bi-person-circle"></i> <?= htmlspecialchars($userData['nama']) ?>
                    </span>
                    <a href="dashboard.php" class="btn btn-outline-light btn-sm">
                        <i class="bi bi-house"></i> Dashboard
                    </a>
                </div>
            </div>
        </nav>

        <div class="container mt-4">
            <!-- Mapel Selector -->
            <div class="mapel-selector">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <h5 class="mb-0">
                            <i class="bi bi-journal-text text-primary"></i>
                            Mata Pelajaran: 
                            <span class="text-primary"><?= htmlspecialchars($selectedMapel['nama_mapel']) ?></span>
                        </h5>
                        <small class="text-muted">
                            Kelas: <?= htmlspecialchars($selectedMapel['nama_kelas']) ?> 
                            - Tingkat: <?= htmlspecialchars($selectedMapel['tingkat']) ?>
                            - Kode: <?= htmlspecialchars($selectedMapel['kode_mapel']) ?>
                        </small>
                    </div>
                    <div class="col-md-6">
                        <form method="get" class="d-flex">
                            <select name="mapel_kelas" class="form-select" onchange="this.form.submit()">
                                <?php foreach ($guruMapel as $mapel): ?>
                                    <?php 
                                    $value = $mapel['mapel_id'] . '_' . $mapel['kelas_id'];
                                    $selected = ($mapel['mapel_id'] == $mapelId && $mapel['kelas_id'] == $kelasId) ? 'selected' : '';
                                    ?>
                                    <option value="<?= $value ?>" <?= $selected ?>>
                                        <?= htmlspecialchars($mapel['nama_mapel']) ?> - <?= htmlspecialchars($mapel['nama_kelas']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Flash Messages -->
            <?php if (isset($_SESSION['flash_success'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle-fill"></i> <?= $_SESSION['flash_success'] ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                <?php unset($_SESSION['flash_success']); ?>
            <?php endif; ?>
            
            <?php if (isset($_SESSION['flash_error'])): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="bi bi-exclamation-triangle-fill"></i> <?= $_SESSION['flash_error'] ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                <?php unset($_SESSION['flash_error']); ?>
            <?php endif; ?>

            <div class="row">
                <div class="col-lg-4">
                    <!-- Add TP Form -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-white py-3">
                            <h6 class="m-0 font-weight-bold text-primary">
                                <i class="bi bi-plus-circle"></i> Tambah Tujuan Pembelajaran
                            </h6>
                        </div>
                        <div class="card-body">
                            <form method="POST">
                                <input type="hidden" name="action" value="create_tp">
                                
                                <div class="mb-3">
                                    <label for="kode_tp" class="form-label">Kode TP</label>
                                    <input type="text" class="form-control" id="kode_tp" name="kode_tp" 
                                           placeholder="Contoh: INF7-TP1" required>
                                    <div class="form-text">Format: KodeMapel-Kelas-TPUrutan</div>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="deskripsi" class="form-label">Deskripsi TP</label>
                                    <textarea class="form-control" id="deskripsi" name="deskripsi" 
                                              rows="4" placeholder="Deskripsi tujuan pembelajaran..." required></textarea>
                                </div>
                                
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="bi bi-save"></i> Simpan TP
                                </button>
                            </form>
                        </div>
                    </div>
                    
                    <!-- Quick Stats -->
                    <div class="card shadow">
                        <div class="card-header bg-white py-3">
                            <h6 class="m-0 font-weight-bold text-primary">
                                <i class="bi bi-graph-up"></i> Statistik
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row text-center">
                                <div class="col-6">
                                    <div class="h4 text-primary"><?= count($tpList) ?></div>
                                    <small class="text-muted">Total TP</small>
                                </div>
                                <div class="col-6">
                                    <?php
                                    $activeTP = array_filter($tpList, function($tp) {
                                        return $tp['status'] === 'aktif';
                                    });
                                    ?>
                                    <div class="h4 text-success"><?= count($activeTP) ?></div>
                                    <small class="text-muted">TP Aktif</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Import/Export Tools -->
                    <div class="card shadow mt-4">
                        <div class="card-header bg-white py-3">
                            <h6 class="m-0 font-weight-bold text-primary">
                                <i class="bi bi-arrow-left-right"></i> Tools
                            </h6>
                        </div>
                        <div class="card-body">
                            <!-- Export Button -->
                            <div class="d-grid gap-2">
                                <button type="button" class="btn btn-outline-success btn-sm" 
                                        onclick="exportTP()" <?= empty($tpList) ? 'disabled' : '' ?>>
                                    <i class="bi bi-download"></i> Export TP
                                </button>
                                
                                <!-- Import Button -->
                                <button type="button" class="btn btn-outline-primary btn-sm" 
                                        data-bs-toggle="modal" data-bs-target="#importTPModal">
                                    <i class="bi bi-upload"></i> Import TP
                                </button>
                            </div>
                            
                            <?php if (empty($tpList)): ?>
                                <div class="alert alert-info mt-2 mb-0 py-2">
                                    <small><i class="bi bi-info-circle"></i> Export tersedia ketika sudah ada TP</small>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="col-lg-8">
                    <!-- TP List -->
                    <div class="card shadow">
                        <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                            <h6 class="m-0 font-weight-bold text-primary">
                                <i class="bi bi-list-ul"></i> Daftar Tujuan Pembelajaran
                            </h6>
                            <span class="badge bg-primary"><?= count($tpList) ?> TP</span>
                        </div>
                        <div class="card-body">
                            <?php if (!empty($tpList)): ?>
                                <?php foreach ($tpList as $tp): ?>
                                    <div class="tp-item">
                                        <div class="d-flex justify-content-between align-items-start mb-2">
                                            <div>
                                                <h6 class="mb-1 text-primary"><?= htmlspecialchars($tp['kode_tp']) ?></h6>
                                                <p class="mb-2"><?= htmlspecialchars($tp['deskripsi']) ?></p>
                                                <small class="text-muted">
                                                    TP ID: <?= $tp['id'] ?> | 
                                                    Total Kegiatan: <?= $tp['total_kegiatan'] ?? 0 ?> |
                                                    Total Nilai Formatif: <?= $tp['total_nilai_formatif'] ?? 0 ?>
                                                </small>
                                            </div>
                                            <div class="dropdown">
                                                <button class="btn btn-sm btn-outline-secondary dropdown-toggle" 
                                                        type="button" data-bs-toggle="dropdown">
                                                    <i class="bi bi-gear"></i>
                                                </button>
                                                <ul class="dropdown-menu">
                                                    <li>
                                                        <a class="dropdown-item" href="#" 
                                                           data-bs-toggle="modal" data-bs-target="#editTPModal<?= $tp['id'] ?>">
                                                            <i class="bi bi-pencil"></i> Edit
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="kegiatan_formatif.php?tp_id=<?= $tp['id'] ?>">
                                                            <i class="bi bi-calendar-event"></i> Kelola Kegiatan
                                                        </a>
                                                    </li>
                                                    <!-- TAMBAHKAN OPSI DUPLIKASI -->
                                                    <li>
                                                        <a class="dropdown-item" href="#" 
                                                           data-bs-toggle="modal" data-bs-target="#duplicateTPModal<?= $tp['id'] ?>">
                                                            <i class="bi bi-copy"></i> Duplikasi ke Kelas Lain
                                                        </a>
                                                    </li>
                                                    <li><hr class="dropdown-divider"></li>
                                                    <li>
                                                        <form method="POST" class="d-inline">
                                                            <input type="hidden" name="action" value="delete_tp">
                                                            <input type="hidden" name="tp_id" value="<?= $tp['id'] ?>">
                                                            <button type="submit" class="dropdown-item text-danger" 
                                                                    onclick="return confirm('Hapus TP ini? Tindakan ini tidak dapat dibatalkan.')">
                                                                <i class="bi bi-trash"></i> Hapus
                                                            </button>
                                                        </form>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="d-flex justify-content-between align-items-center">
                                            <small class="text-muted">
                                                Dibuat: <?= date('d M Y', strtotime($tp['created_at'])) ?>
                                                <?php if ($tp['nama_kelas']): ?>
                                                    | Kelas: <?= htmlspecialchars($tp['nama_kelas']) ?>
                                                <?php endif; ?>
                                            </small>
                                            <span class="badge badge-status 
                                                <?= $tp['status'] === 'aktif' ? 'bg-success' : 'bg-secondary' ?>">
                                                <?= ucfirst($tp['status']) ?>
                                            </span>
                                        </div>
                                    </div>

                                    <!-- Edit TP Modal -->
                                    <div class="modal fade" id="editTPModal<?= $tp['id'] ?>" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Edit Tujuan Pembelajaran</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                </div>
                                                <form method="POST">
                                                    <input type="hidden" name="action" value="update_tp">
                                                    <input type="hidden" name="tp_id" value="<?= $tp['id'] ?>">
                                                    
                                                    <div class="modal-body">
                                                        <div class="mb-3">
                                                            <label for="kode_tp_edit<?= $tp['id'] ?>" class="form-label">Kode TP</label>
                                                            <input type="text" class="form-control" 
                                                                   id="kode_tp_edit<?= $tp['id'] ?>" 
                                                                   name="kode_tp" value="<?= htmlspecialchars($tp['kode_tp']) ?>" required>
                                                        </div>
                                                        
                                                        <div class="mb-3">
                                                            <label for="deskripsi_edit<?= $tp['id'] ?>" class="form-label">Deskripsi TP</label>
                                                            <textarea class="form-control" 
                                                                      id="deskripsi_edit<?= $tp['id'] ?>" 
                                                                      name="deskripsi" rows="4" required><?= htmlspecialchars($tp['deskripsi']) ?></textarea>
                                                        </div>
                                                        
                                                        <div class="mb-3">
                                                            <label for="status_edit<?= $tp['id'] ?>" class="form-label">Status</label>
                                                            <select class="form-select" id="status_edit<?= $tp['id'] ?>" name="status">
                                                                <option value="draft" <?= $tp['status'] === 'draft' ? 'selected' : '' ?>>Draft</option>
                                                                <option value="aktif" <?= $tp['status'] === 'aktif' ? 'selected' : '' ?>>Aktif</option>
                                                                <option value="nonaktif" <?= $tp['status'] === 'nonaktif' ? 'selected' : '' ?>>Nonaktif</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                        <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Duplicate TP Modal -->
                                    <div class="modal fade" id="duplicateTPModal<?= $tp['id'] ?>" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Duplikasi TP ke Kelas Lain</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                </div>
                                                <form method="POST">
                                                    <input type="hidden" name="action" value="duplicate_tp">
                                                    <input type="hidden" name="tp_id" value="<?= $tp['id'] ?>">
                                                    
                                                    <div class="modal-body">
                                                        <div class="alert alert-warning">
                                                            <small>
                                                                <i class="bi bi-info-circle"></i> 
                                                                TP "<strong><?= htmlspecialchars($tp['kode_tp']) ?></strong>" akan diduplikasi ke kelas tujuan.
                                                            </small>
                                                        </div>
                                                        
                                                        <div class="mb-3">
                                                            <label for="target_kelas_id<?= $tp['id'] ?>" class="form-label">Kelas Tujuan</label>
                                                            <select class="form-select" id="target_kelas_id<?= $tp['id'] ?>" name="target_kelas_id" required>
                                                                <option value="">-- Pilih Kelas --</option>
                                                                <?php if (empty($availableKelas)): ?>
                                                                    <option value="" disabled>Tidak ada kelas lain yang tersedia</option>
                                                                <?php else: ?>
                                                                    <?php foreach ($availableKelas as $kelas): ?>
                                                                        <option value="<?= $kelas['id'] ?>">
                                                                            <?= htmlspecialchars($kelas['nama_kelas']) ?> (<?= htmlspecialchars($kelas['tingkat']) ?>)
                                                                        </option>
                                                                    <?php endforeach; ?>
                                                                <?php endif; ?>
                                                            </select>
                                                            <?php if (empty($availableKelas)): ?>
                                                                <div class="form-text text-warning">
                                                                    Anda tidak mengajar kelas lain untuk mapel ini
                                                                </div>
                                                            <?php endif; ?>
                                                        </div>
                                                        
                                                        <div class="mb-3">
                                                            <label for="new_kode_tp<?= $tp['id'] ?>" class="form-label">Kode TP Baru (Opsional)</label>
                                                            <input type="text" class="form-control" 
                                                                   id="new_kode_tp<?= $tp['id'] ?>" 
                                                                   name="new_kode_tp" 
                                                                   placeholder="Kosongkan untuk menggunakan kode yang sama">
                                                            <div class="form-text">Sesuaikan kode TP dengan kelas tujuan</div>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                        <button type="submit" class="btn btn-primary" <?= empty($availableKelas) ? 'disabled' : '' ?>>Duplikasi TP</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <div class="empty-state">
                                    <i class="bi bi-bullseye"></i>
                                    <h5>Belum ada Tujuan Pembelajaran</h5>
                                    <p class="text-muted">Mulai dengan menambahkan TP pertama Anda.</p>
                                    <div class="alert alert-info mt-3">
                                        <small>
                                            <strong>Debug Info:</strong><br>
                                            Mapel ID: <?= $mapelId ?><br>
                                            Kelas ID: <?= $kelasId ?><br>
                                            Query: SELECT tp.* FROM tujuan_pembelajaran tp WHERE tp.mapel_id = <?= $mapelId ?> AND tp.kelas_id = <?= $kelasId ?>
                                        </small>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
					<!-- Tambahkan di tp.php setelah TP list -->
					<?php if (!empty($tpList)): ?>
					<div class="card mt-4">
						<div class="card-header bg-info text-white">
							<h6 class="mb-0"><i class="bi bi-graph-up"></i> Kelola Nilai Sumatif</h6>
						</div>
						<div class="card-body">
							<div class="row">
								<?php foreach ($tpList as $tp): ?>
								<div class="col-md-6 mb-3">
									<div class="d-flex justify-content-between align-items-center p-3 border rounded">
										<div>
											<strong><?= htmlspecialchars($tp['kode_tp']) ?></strong>
											<br>
											<small class="text-muted"><?= substr(htmlspecialchars($tp['deskripsi']), 0, 50) ?>...</small>
										</div>
										<a href="nilai_sumatif.php?tp_id=<?= $tp['id'] ?>" class="btn btn-primary btn-sm">
											<i class="bi bi-graph-up"></i> Input Nilai
										</a>
									</div>
								</div>
								<?php endforeach; ?>
							</div>
						</div>
					</div>
					<?php endif; ?>
					<!-- Tambahkan di tp.php -->
<a href="nilai_sumatif_detail.php?mapel_id=<?= $mapelId ?>&kelas_id=<?= $kelasId ?>" 
   class="btn btn-info btn-sm">
   <i class="bi bi-table"></i> Rekap Nilai Sumatif
</a>
					
					
                </div>
            </div>
        </div>
    </div>

    <!-- Import TP Modal -->
    <div class="modal fade" id="importTPModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Import Tujuan Pembelajaran</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="action" value="import_tp">
                    
                    <div class="modal-body">
                        <div class="alert alert-info">
                            <small>
                                <strong>Format file:</strong> JSON (dari hasil export)<br>
                                <strong>Struktur data:</strong> kode_tp, deskripsi, status
                            </small>
                        </div>
                        
                        <div class="mb-3">
                            <label for="import_file" class="form-label">Pilih File JSON</label>
                            <input type="file" class="form-control" id="import_file" 
                                   name="import_file" accept=".json" required>
                            <div class="form-text">Hanya file JSON yang didukung</div>
                        </div>
                        
                        <div class="alert alert-warning">
                            <small>
                                <i class="bi bi-exclamation-triangle"></i> 
                                TP dengan kode yang sudah ada akan dilewati (skip)
                            </small>
                        </div>
                    </div>
                    
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" class="btn btn-primary">Import Data</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Debug informasi di console
        console.log("=== TP.PHP DEBUG ===");
        console.log("Guru ID: <?= $guruId ?>");
        console.log("Mapel ID: <?= $mapelId ?>");
        console.log("Kelas ID: <?= $kelasId ?>");
        console.log("TP Count: <?= count($tpList) ?>");
        console.log("Selected Mapel: <?= $selectedMapel['nama_mapel'] ?? 'null' ?>");
        console.log("Selected Kelas: <?= $selectedMapel['nama_kelas'] ?? 'null' ?>");
        console.log("Available Mapel+Kelas: <?= count($guruMapel) ?>");
        console.log("Available Kelas for Duplication: <?= count($availableKelas) ?>");
        
        // Tampilkan detail TP di console
        <?php foreach ($tpList as $tp): ?>
        console.log("TP: <?= $tp['kode_tp'] ?> (ID: <?= $tp['id'] ?>)");
        <?php endforeach; ?>
        console.log("===================");

        // Export TP function
        function exportTP() {
            const exportData = {
                mapel_id: <?= $mapelId ?>,
                kelas_id: <?= $kelasId ?>,
                mapel: "<?= $selectedMapel['nama_mapel'] ?>",
                kelas: "<?= $selectedMapel['nama_kelas'] ?>",
                tahun_ajaran: "<?= $tahunAktif['tahun_ajaran'] ?>",
                semester: "<?= $tahunAktif['semester'] ?>",
                timestamp: new Date().toISOString(),
                exported_by: "<?= $userData['nama'] ?>",
                data: <?= json_encode(array_map(function($tp) {
                    return [
                        'kode_tp' => $tp['kode_tp'],
                        'deskripsi' => $tp['deskripsi'],
                        'status' => $tp['status'],
                        'created_at' => $tp['created_at']
                    ];
                }, $tpList)) ?>
            };
            
            const dataStr = JSON.stringify(exportData, null, 2);
            const dataBlob = new Blob([dataStr], {type: 'application/json'});
            
            const link = document.createElement('a');
            link.href = URL.createObjectURL(dataBlob);
            link.download = `TP_<?= $selectedMapel['nama_mapel'] ?>_<?= $selectedMapel['nama_kelas'] ?>_${new Date().toISOString().split('T')[0]}.json`;
            link.click();
            
            console.log('TP exported:', exportData);
            
            // Show success message
            showToast('Export berhasil', 'File TP berhasil diunduh', 'success');
        }

        // Toast notification function
        function showToast(title, message, type = 'info') {
            const toast = document.createElement('div');
            toast.className = `toast align-items-center text-bg-${type} border-0`;
            toast.innerHTML = `
                <div class="d-flex">
                    <div class="toast-body">
                        <strong>${title}</strong><br>${message}
                    </div>
                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
                </div>
            `;
            
            const toastContainer = document.createElement('div');
            toastContainer.className = 'toast-container position-fixed top-0 end-0 p-3';
            toastContainer.appendChild(toast);
            document.body.appendChild(toastContainer);
            
            const bsToast = new bootstrap.Toast(toast);
            bsToast.show();
            
            // Remove after hide
            toast.addEventListener('hidden.bs.toast', () => {
                toastContainer.remove();
            });
        }

        // Toggle debug panel
        function toggleDebug() {
            const debugContent = document.getElementById('debugContent');
            debugContent.style.display = debugContent.style.display === 'none' ? 'block' : 'none';
        }

        // Auto-expand debug panel jika ada error
        <?php if (isset($_SESSION['flash_error'])): ?>
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('debugContent').style.display = 'block';
        });
        <?php endif; ?>

        // Log form submissions
        document.addEventListener('DOMContentLoaded', function() {
            const forms = document.querySelectorAll('form');
            forms.forEach(form => {
                form.addEventListener('submit', function(e) {
                    console.log('Form submitted:', this.getAttribute('action') || 'current');
                    const action = this.querySelector('input[name="action"]');
                    if (action) {
                        console.log('Action:', action.value);
                    }
                });
            });

            // Log dropdown changes
            const mapelSelect = document.querySelector('select[name="mapel_kelas"]');
            if (mapelSelect) {
                mapelSelect.addEventListener('change', function() {
                    console.log('Mapel+Kelas changed to:', this.value);
                });
            }

            // Auto-update kode TP saat memilih kelas tujuan untuk duplikasi
            const kelasSelects = document.querySelectorAll('select[name="target_kelas_id"]');
            kelasSelects.forEach(select => {
                select.addEventListener('change', function() {
                    const tpId = this.id.replace('target_kelas_id', '');
                    const kodeInput = document.getElementById('new_kode_tp' + tpId);
                    if (kodeInput && !kodeInput.value) {
                        const selectedOption = this.options[this.selectedIndex];
                        if (selectedOption.text) {
                            // Extract class name and generate suggestion
                            const classMatch = selectedOption.text.match(/\(([^)]+)\)/);
                            if (classMatch) {
                                const tingkat = classMatch[1];
                                // Generate suggestion based on current kode pattern
                                kodeInput.placeholder = `Contoh: INF${tingkat}-TP1`;
                            }
                        }
                    }
                });
            });
        });
    </script>
</body>
</html>