<?php
require_once __DIR__ . '/../../app/config/config.php';
Session::checkAuth();
Session::checkRole(['guru']);

$guruModel = new GuruModel();
$userData = Session::getUserData();

echo "<pre>";
echo "=== TEST GET SISWA BY KELAS ===\n";

// Test dengan kelas_id dari kegiatan_id=1
$kegiatan_data = $guruModel->getKegiatanFormatifById(1);
echo "Kegiatan Data: " . print_r($kegiatan_data, true) . "\n";

if ($kegiatan_data) {
    $kelas_id = $kegiatan_data['kelas_id'];
    echo "Kelas ID: " . $kelas_id . "\n\n";
    
    // Test method baru
    if (method_exists($guruModel, 'getSiswaByKelasForNilai')) {
        echo "Testing getSiswaByKelasForNilai($kelas_id):\n";
        $siswa_list = $guruModel->getSiswaByKelasForNilai($kelas_id);
        echo "Result: " . print_r($siswa_list, true) . "\n";
    } else {
        echo "Method getSiswaByKelasForNilai tidak ada!\n";
    }
    
    // Test method lama untuk perbandingan
    echo "\nTesting getSiswaByKelas($kelas_id):\n";
    $siswa_list_old = $guruModel->getSiswaByKelas($kelas_id);
    echo "Result: " . print_r($siswa_list_old, true) . "\n";
    
    // Test query manual
    echo "\n=== MANUAL QUERY TEST ===\n";
    $sql_manual = "SELECT 
                    s.id,
                    s.nis,
                    u.nama,
                    s.kelas_id,
                    k.nama_kelas
                FROM siswa s
                JOIN users u ON s.user_id = u.id
                JOIN kelas k ON s.kelas_id = k.id
                WHERE s.kelas_id = ? AND s.status = 'aktif'";
    
    $result_manual = $guruModel->db->query($sql_manual, [$kelas_id])->fetchAll(PDO::FETCH_ASSOC);
    echo "Manual Query Result: " . print_r($result_manual, true) . "\n";
    
    // Test count siswa di database
    $sql_count = "SELECT COUNT(*) as total FROM siswa WHERE kelas_id = ? AND status = 'aktif'";
    $count_result = $guruModel->db->query($sql_count, [$kelas_id])->fetch(PDO::FETCH_ASSOC);
    echo "Total siswa aktif di kelas $kelas_id: " . $count_result['total'] . "\n";
}
echo "</pre>";
?>