<?php
require_once __DIR__ . '/../../app/config/config.php';
Session::checkAuth();
Session::checkRole(['guru']);

// Enable error reporting untuk debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

$guruModel = new GuruModel();
$userData = Session::getUserData();
$guruId = $userData['guru_id'];

// ==================== DEBUG START ====================
echo "<!-- ========== DEBUG INFORMATION ========== -->\n";
echo "<!-- Guru ID: " . $guruId . " -->\n";
echo "<!-- Guru Name: " . $userData['nama'] . " -->\n";

// Get tahun ajaran aktif
$tahunAktif = $guruModel->getActiveTahunAjaran();
echo "<!-- Tahun Ajaran Aktif: " . ($tahunAktif ? $tahunAktif['tahun_ajaran'] : 'Tidak ditemukan') . " -->\n";

// Get mapel_id and kelas_id from URL
if (isset($_GET['mapel_kelas'])) {
    $mapelKelas = explode('_', $_GET['mapel_kelas']);
    $mapelId = intval($mapelKelas[0]);
    $kelasId = intval($mapelKelas[1]);
} else {
    $mapelId = isset($_GET['mapel_id']) ? intval($_GET['mapel_id']) : 0;
    $kelasId = 0;
}

echo "<!-- Mapel ID from URL: " . $mapelId . " -->\n";
echo "<!-- Kelas ID from URL: " . $kelasId . " -->\n";

// Get guru's mapel list
$guruMapel = $guruModel->getGuruMapel($guruId);
echo "<!-- Total Guru Mapel: " . count($guruMapel) . " -->\n";

// Debug guru mapel details
foreach ($guruMapel as $index => $mapel) {
    echo "<!-- Mapel " . ($index + 1) . ": ID=" . $mapel['mapel_id'] . ", " . $mapel['nama_mapel'] . " - " . $mapel['nama_kelas'] . " (Kelas ID: " . $mapel['kelas_id'] . ") -->\n";
}

if (empty($guruMapel)) {
    die("<!-- ERROR: Tidak ada penugasan mengajar untuk guru ini. -->");
}

// If no mapel_id specified, use first one and redirect
if ($mapelId === 0 && !empty($guruMapel)) {
    $firstMapel = $guruMapel[0];
    $mapelId = $firstMapel['mapel_id'];
    $kelasId = $firstMapel['kelas_id'];
    echo "<!-- Redirecting to first mapel: " . $mapelId . " and kelas: " . $kelasId . " -->\n";
    header("Location: tp.php?mapel_kelas=" . $mapelId . "_" . $kelasId);
    exit();
}

// Validate access and get selected mapel
$hasAccess = false;
$selectedMapel = null;
foreach ($guruMapel as $mapel) {
    if ($mapel['mapel_id'] == $mapelId && $mapel['kelas_id'] == $kelasId) {
        $hasAccess = true;
        $selectedMapel = $mapel;
        break;
    }
}

echo "<!-- Access Validation: " . ($hasAccess ? 'GRANTED' : 'DENIED') . " -->\n";
echo "<!-- Selected Mapel: " . ($selectedMapel ? $selectedMapel['nama_mapel'] . ' - ' . $selectedMapel['nama_kelas'] : 'NULL') . " -->\n";
echo "<!-- Selected Kelas ID: " . ($selectedMapel ? $selectedMapel['kelas_id'] : 'NULL') . " -->\n";

if (!$hasAccess) {
    die("<!-- ERROR: Akses ditolak untuk mapel ini. -->");
}

// Handle form actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    echo "<!-- POST Request Detected -->\n";
    echo "<!-- POST Data: " . print_r($_POST, true) . " -->\n";
    
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'create_tp':
                echo "<!-- Action: CREATE TP -->\n";
                $data = [
                    'mapel_id' => $mapelId,
                    'kelas_id' => $kelasId,
                    'kode_tp' => $_POST['kode_tp'],
                    'deskripsi' => $_POST['deskripsi']
                ];
                
                echo "<!-- TP Data to Create: " . print_r($data, true) . " -->\n";
                
                if ($guruModel->createTP($data)) {
                    $_SESSION['flash_success'] = 'Tujuan Pembelajaran berhasil ditambahkan.';
                    echo "<!-- TP Creation: SUCCESS -->\n";
                } else {
                    $_SESSION['flash_error'] = 'Gagal menambahkan Tujuan Pembelajaran.';
                    echo "<!-- TP Creation: FAILED -->\n";
                }
                break;
                
            case 'update_tp':
                echo "<!-- Action: UPDATE TP -->\n";
                $tpId = intval($_POST['tp_id']);
                $data = [
                    'kode_tp' => $_POST['kode_tp'],
                    'deskripsi' => $_POST['deskripsi'],
                    'status' => $_POST['status'],
                    'kelas_id' => $kelasId
                ];
                
                echo "<!-- TP Data to Update: " . print_r($data, true) . " -->\n";
                echo "<!-- TP ID to Update: " . $tpId . " -->\n";
                
                if ($guruModel->updateTP($tpId, $data)) {
                    $_SESSION['flash_success'] = 'Tujuan Pembelajaran berhasil diperbarui.';
                    echo "<!-- TP Update: SUCCESS -->\n";
                } else {
                    $_SESSION['flash_error'] = 'Gagal memperbarui Tujuan Pembelajaran.';
                    echo "<!-- TP Update: FAILED -->\n";
                }
                break;
                
            case 'delete_tp':
                echo "<!-- Action: DELETE TP -->\n";
                $tpId = intval($_POST['tp_id']);
                echo "<!-- TP ID to Delete: " . $tpId . " -->\n";
                
                // Validasi akses sebelum hapus
                if ($guruModel->validateGuruTPAccess($guruId, $tpId)) {
                    if ($guruModel->deleteTP($tpId)) {
                        $_SESSION['flash_success'] = 'Tujuan Pembelajaran berhasil dihapus.';
                        echo "<!-- TP Delete: SUCCESS -->\n";
                    } else {
                        $_SESSION['flash_error'] = 'Gagal menghapus Tujuan Pembelajaran. Mungkin ada data terkait.';
                        echo "<!-- TP Delete: FAILED (mungkin ada data terkait) -->\n";
                    }
                } else {
                    $_SESSION['flash_error'] = 'Akses ditolak untuk menghapus TP ini.';
                    echo "<!-- TP Delete: ACCESS DENIED -->\n";
                }
                break;
        }
        echo "<!-- Redirecting to: tp.php?mapel_kelas=" . $mapelId . "_" . $kelasId . " -->\n";
        header("Location: tp.php?mapel_kelas=" . $mapelId . "_" . $kelasId);
        exit();
    }
}

// Get TP list for selected mapel DAN kelas
echo "<!-- Getting TP for Mapel ID: " . $mapelId . ", Kelas ID: " . $kelasId . " -->\n";
$tpList = $guruModel->getTPByMapel($mapelId, $kelasId);
echo "<!-- TP List Count: " . count($tpList) . " -->\n";

// Debug TP list details
foreach ($tpList as $index => $tp) {
    echo "<!-- TP " . ($index + 1) . ": ID=" . $tp['id'] . ", " . $tp['kode_tp'] . " - " . substr($tp['deskripsi'], 0, 50) . "... -->\n";
}

echo "<!-- ========== END DEBUG INFORMATION ========== -->\n";
// ==================== DEBUG END ====================
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tujuan Pembelajaran - Sistem Penilaian</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .navbar-brand {
            font-weight: 600;
        }
        
        .card {
            border-radius: 12px;
            border: none;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        }
        
        .card-header {
            border-radius: 12px 12px 0 0 !important;
            border-bottom: 1px solid rgba(0,0,0,0.05);
            font-weight: 600;
        }
        
        .btn {
            border-radius: 8px;
            font-weight: 500;
        }
        
        .mapel-selector {
            background: white;
            border-radius: 10px;
            padding: 1rem;
            margin-bottom: 1.5rem;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }
        
        .tp-item {
            border-left: 4px solid #007bff;
            background: white;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            transition: all 0.3s ease;
        }
        
        .tp-item:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        
        .empty-state {
            text-align: center;
            padding: 3rem 1rem;
            color: #6c757d;
        }
        
        .empty-state i {
            font-size: 4rem;
            margin-bottom: 1rem;
            opacity: 0.5;
        }
        
        .debug-panel {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
            font-family: 'Courier New', monospace;
            font-size: 0.875rem;
        }
        
        .debug-toggle {
            cursor: pointer;
            user-select: none;
        }
        
        .debug-content {
            display: none;
            margin-top: 1rem;
            background: white;
            padding: 1rem;
            border-radius: 4px;
            border: 1px solid #dee2e6;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <!-- Debug Panel -->
        <div class="debug-panel">
            <div class="debug-toggle" onclick="toggleDebug()">
                <i class="bi bi-bug"></i> <strong>Debug Information</strong> 
                <small class="text-muted">(Click to expand)</small>
            </div>
            <div class="debug-content" id="debugContent">
                <div class="row">
                    <div class="col-md-6">
                        <strong>User Info:</strong><br>
                        Guru ID: <?= $guruId ?><br>
                        Nama: <?= htmlspecialchars($userData['nama']) ?><br>
                        Tahun Ajaran: <?= $tahunAktif ? $tahunAktif['tahun_ajaran'] : 'Tidak ditemukan' ?>
                    </div>
                    <div class="col-md-6">
                        <strong>Current Selection:</strong><br>
                        Mapel ID: <?= $mapelId ?><br>
                        Kelas ID: <?= $kelasId ?><br>
                        Mapel: <?= $selectedMapel ? htmlspecialchars($selectedMapel['nama_mapel']) : 'NULL' ?><br>
                        Kelas: <?= $selectedMapel ? htmlspecialchars($selectedMapel['nama_kelas']) : 'NULL' ?><br>
                    </div>
                </div>
                <div class="row mt-2">
                    <div class="col-12">
                        <strong>TP Statistics:</strong><br>
                        Total TP: <?= count($tpList) ?><br>
                        Available Mapel+Kelas: <?= count($guruMapel) ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Header -->
        <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
            <div class="container">
                <a class="navbar-brand" href="dashboard.php">
                    <i class="bi bi-arrow-left"></i> Tujuan Pembelajaran
                </a>
                <div class="navbar-nav ms-auto">
                    <span class="navbar-text me-3">
                        <i class="bi bi-person-circle"></i> <?= htmlspecialchars($userData['nama']) ?>
                    </span>
                    <a href="dashboard.php" class="btn btn-outline-light btn-sm">
                        <i class="bi bi-house"></i> Dashboard
                    </a>
                </div>
            </div>
        </nav>

        <div class="container mt-4">
            <!-- Mapel Selector -->
            <div class="mapel-selector">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <h5 class="mb-0">
                            <i class="bi bi-journal-text text-primary"></i>
                            Mata Pelajaran: 
                            <span class="text-primary"><?= htmlspecialchars($selectedMapel['nama_mapel']) ?></span>
                        </h5>
                        <small class="text-muted">
                            Kelas: <?= htmlspecialchars($selectedMapel['nama_kelas']) ?> 
                            - Tingkat: <?= htmlspecialchars($selectedMapel['tingkat']) ?>
                            - Kode: <?= htmlspecialchars($selectedMapel['kode_mapel']) ?>
                        </small>
                    </div>
                    <div class="col-md-6">
                        <form method="get" class="d-flex">
                            <select name="mapel_kelas" class="form-select" onchange="this.form.submit()">
                                <?php foreach ($guruMapel as $mapel): ?>
                                    <?php 
                                    $value = $mapel['mapel_id'] . '_' . $mapel['kelas_id'];
                                    $selected = ($mapel['mapel_id'] == $mapelId && $mapel['kelas_id'] == $kelasId) ? 'selected' : '';
                                    ?>
                                    <option value="<?= $value ?>" <?= $selected ?>>
                                        <?= htmlspecialchars($mapel['nama_mapel']) ?> - <?= htmlspecialchars($mapel['nama_kelas']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Flash Messages -->
            <?php if (isset($_SESSION['flash_success'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle-fill"></i> <?= $_SESSION['flash_success'] ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                <?php unset($_SESSION['flash_success']); ?>
            <?php endif; ?>
            
            <?php if (isset($_SESSION['flash_error'])): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="bi bi-exclamation-triangle-fill"></i> <?= $_SESSION['flash_error'] ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                <?php unset($_SESSION['flash_error']); ?>
            <?php endif; ?>

            <div class="row">
                <div class="col-lg-4">
                    <!-- Add TP Form -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-white py-3">
                            <h6 class="m-0 font-weight-bold text-primary">
                                <i class="bi bi-plus-circle"></i> Tambah Tujuan Pembelajaran
                            </h6>
                        </div>
                        <div class="card-body">
                            <form method="POST">
                                <input type="hidden" name="action" value="create_tp">
                                
                                <div class="mb-3">
                                    <label for="kode_tp" class="form-label">Kode TP</label>
                                    <input type="text" class="form-control" id="kode_tp" name="kode_tp" 
                                           placeholder="Contoh: INF7-TP1" required>
                                    <div class="form-text">Format: KodeMapel-Kelas-TPUrutan</div>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="deskripsi" class="form-label">Deskripsi TP</label>
                                    <textarea class="form-control" id="deskripsi" name="deskripsi" 
                                              rows="4" placeholder="Deskripsi tujuan pembelajaran..." required></textarea>
                                </div>
                                
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="bi bi-save"></i> Simpan TP
                                </button>
                            </form>
                        </div>
                    </div>
                    
                    <!-- Quick Stats -->
                    <div class="card shadow">
                        <div class="card-header bg-white py-3">
                            <h6 class="m-0 font-weight-bold text-primary">
                                <i class="bi bi-graph-up"></i> Statistik
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row text-center">
                                <div class="col-6">
                                    <div class="h4 text-primary"><?= count($tpList) ?></div>
                                    <small class="text-muted">Total TP</small>
                                </div>
                                <div class="col-6">
                                    <?php
                                    $activeTP = array_filter($tpList, function($tp) {
                                        return $tp['status'] === 'aktif';
                                    });
                                    ?>
                                    <div class="h4 text-success"><?= count($activeTP) ?></div>
                                    <small class="text-muted">TP Aktif</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-8">
                    <!-- TP List -->
                    <div class="card shadow">
                        <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                            <h6 class="m-0 font-weight-bold text-primary">
                                <i class="bi bi-list-ul"></i> Daftar Tujuan Pembelajaran
                            </h6>
                            <span class="badge bg-primary"><?= count($tpList) ?> TP</span>
                        </div>
                        <div class="card-body">
                            <?php if (!empty($tpList)): ?>
                                <?php foreach ($tpList as $tp): ?>
                                    <div class="tp-item">
                                        <div class="d-flex justify-content-between align-items-start mb-2">
                                            <div>
                                                <h6 class="mb-1 text-primary"><?= htmlspecialchars($tp['kode_tp']) ?></h6>
                                                <p class="mb-2"><?= htmlspecialchars($tp['deskripsi']) ?></p>
                                                <small class="text-muted">
                                                    TP ID: <?= $tp['id'] ?> | 
                                                    Total Kegiatan: <?= $tp['total_kegiatan'] ?? 0 ?> |
                                                    Total Nilai Formatif: <?= $tp['total_nilai_formatif'] ?? 0 ?>
                                                </small>
                                            </div>
                                            <div class="dropdown">
                                                <button class="btn btn-sm btn-outline-secondary dropdown-toggle" 
                                                        type="button" data-bs-toggle="dropdown">
                                                    <i class="bi bi-gear"></i>
                                                </button>
                                                <ul class="dropdown-menu">
                                                    <li>
                                                        <a class="dropdown-item" href="#" 
                                                           data-bs-toggle="modal" data-bs-target="#editTPModal<?= $tp['id'] ?>">
                                                            <i class="bi bi-pencil"></i> Edit
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="kegiatan_formatif.php?tp_id=<?= $tp['id'] ?>">
                                                            <i class="bi bi-calendar-event"></i> Kelola Kegiatan
                                                        </a>
                                                    </li>
                                                    <li><hr class="dropdown-divider"></li>
                                                    <li>
                                                        <form method="POST" class="d-inline">
                                                            <input type="hidden" name="action" value="delete_tp">
                                                            <input type="hidden" name="tp_id" value="<?= $tp['id'] ?>">
                                                            <button type="submit" class="dropdown-item text-danger" 
                                                                    onclick="return confirm('Hapus TP ini? Tindakan ini tidak dapat dibatalkan.')">
                                                                <i class="bi bi-trash"></i> Hapus
                                                            </button>
                                                        </form>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="d-flex justify-content-between align-items-center">
                                            <small class="text-muted">
                                                Dibuat: <?= date('d M Y', strtotime($tp['created_at'])) ?>
                                                <?php if ($tp['nama_kelas']): ?>
                                                    | Kelas: <?= htmlspecialchars($tp['nama_kelas']) ?>
                                                <?php endif; ?>
                                            </small>
                                            <span class="badge badge-status 
                                                <?= $tp['status'] === 'aktif' ? 'bg-success' : 'bg-secondary' ?>">
                                                <?= ucfirst($tp['status']) ?>
                                            </span>
                                        </div>
                                    </div>

                                    <!-- Edit TP Modal -->
                                    <div class="modal fade" id="editTPModal<?= $tp['id'] ?>" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Edit Tujuan Pembelajaran</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                </div>
                                                <form method="POST">
                                                    <input type="hidden" name="action" value="update_tp">
                                                    <input type="hidden" name="tp_id" value="<?= $tp['id'] ?>">
                                                    
                                                    <div class="modal-body">
                                                        <div class="mb-3">
                                                            <label for="kode_tp_edit<?= $tp['id'] ?>" class="form-label">Kode TP</label>
                                                            <input type="text" class="form-control" 
                                                                   id="kode_tp_edit<?= $tp['id'] ?>" 
                                                                   name="kode_tp" value="<?= htmlspecialchars($tp['kode_tp']) ?>" required>
                                                        </div>
                                                        
                                                        <div class="mb-3">
                                                            <label for="deskripsi_edit<?= $tp['id'] ?>" class="form-label">Deskripsi TP</label>
                                                            <textarea class="form-control" 
                                                                      id="deskripsi_edit<?= $tp['id'] ?>" 
                                                                      name="deskripsi" rows="4" required><?= htmlspecialchars($tp['deskripsi']) ?></textarea>
                                                        </div>
                                                        
                                                        <div class="mb-3">
                                                            <label for="status_edit<?= $tp['id'] ?>" class="form-label">Status</label>
                                                            <select class="form-select" id="status_edit<?= $tp['id'] ?>" name="status">
                                                                <option value="draft" <?= $tp['status'] === 'draft' ? 'selected' : '' ?>>Draft</option>
                                                                <option value="aktif" <?= $tp['status'] === 'aktif' ? 'selected' : '' ?>>Aktif</option>
                                                                <option value="nonaktif" <?= $tp['status'] === 'nonaktif' ? 'selected' : '' ?>>Nonaktif</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                        <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <div class="empty-state">
                                    <i class="bi bi-bullseye"></i>
                                    <h5>Belum ada Tujuan Pembelajaran</h5>
                                    <p class="text-muted">Mulai dengan menambahkan TP pertama Anda.</p>
                                    <div class="alert alert-info mt-3">
                                        <small>
                                            <strong>Debug Info:</strong><br>
                                            Mapel ID: <?= $mapelId ?><br>
                                            Kelas ID: <?= $kelasId ?><br>
                                            Query: SELECT tp.* FROM tujuan_pembelajaran tp WHERE tp.mapel_id = <?= $mapelId ?> AND tp.kelas_id = <?= $kelasId ?>
                                        </small>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Debug informasi di console
        console.log("=== TP.PHP DEBUG ===");
        console.log("Guru ID: <?= $guruId ?>");
        console.log("Mapel ID: <?= $mapelId ?>");
        console.log("Kelas ID: <?= $kelasId ?>");
        console.log("TP Count: <?= count($tpList) ?>");
        console.log("Selected Mapel: <?= $selectedMapel['nama_mapel'] ?? 'null' ?>");
        console.log("Selected Kelas: <?= $selectedMapel['nama_kelas'] ?? 'null' ?>");
        console.log("Available Mapel+Kelas: <?= count($guruMapel) ?>");
        
        // Tampilkan detail TP di console
        <?php foreach ($tpList as $tp): ?>
        console.log("TP: <?= $tp['kode_tp'] ?> (ID: <?= $tp['id'] ?>)");
        <?php endforeach; ?>
        console.log("===================");

        // Toggle debug panel
        function toggleDebug() {
            const debugContent = document.getElementById('debugContent');
            debugContent.style.display = debugContent.style.display === 'none' ? 'block' : 'none';
        }

        // Auto-expand debug panel jika ada error
        <?php if (isset($_SESSION['flash_error'])): ?>
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('debugContent').style.display = 'block';
        });
        <?php endif; ?>

        // Log form submissions
        document.addEventListener('DOMContentLoaded', function() {
            const forms = document.querySelectorAll('form');
            forms.forEach(form => {
                form.addEventListener('submit', function(e) {
                    console.log('Form submitted:', this.getAttribute('action') || 'current');
                    const action = this.querySelector('input[name="action"]');
                    if (action) {
                        console.log('Action:', action.value);
                    }
                });
            });

            // Log dropdown changes
            const mapelSelect = document.querySelector('select[name="mapel_kelas"]');
            if (mapelSelect) {
                mapelSelect.addEventListener('change', function() {
                    console.log('Mapel+Kelas changed to:', this.value);
                });
            }
        });
    </script>
</body>
</html>