<?php
require_once __DIR__ . '/../../app/config/config.php';
Session::checkAuth();
Session::checkRole(['guru']);

$guruModel = new GuruModel();
$userData = Session::getUserData();
$guruId = $userData['guru_id'];

// Get parameters
$tp_id = $_GET['tp_id'] ?? null;
$action = $_GET['action'] ?? 'list';

// Setelah mendapatkan $tp_id
echo "<!-- Debug: TP ID = " . $tp_id . " -->\n";

if ($tp_id) {
    // Validate TP access
    echo "<!-- Debug: Validating access for guru " . $guruId . " and TP " . $tp_id . " -->\n";
    if (!$guruModel->validateGuruTPAccess($guruId, $tp_id)) {
        $message = 'Anda tidak memiliki akses ke TP ini!';
        $message_type = 'danger';
        $tp_id = null;
        echo "<!-- Debug: Access DENIED -->\n";
    } else {
        echo "<!-- Debug: Access GRANTED -->\n";
        $tp_data = $guruModel->getTPById($tp_id);
        echo "<!-- Debug: TP Data = " . print_r($tp_data, true) . " -->\n";
        // ... kode selanjutnya
    }
}

// Process actions
// Process actions
$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Debug POST data
    echo "<!-- POST Data: " . print_r($_POST, true) . " -->\n";
    
    try {
        if (isset($_POST['input_nilai_sumatif'])) {
            $success_count = 0;
            $error_count = 0;
            
            // Debug selected students
            $selected_siswa = $_POST['selected_siswa'] ?? [];
            echo "<!-- Selected Siswa: " . print_r($selected_siswa, true) . " -->\n";
            
            if (isset($_POST['nilai']) && is_array($_POST['nilai']) && !empty($selected_siswa)) {
                foreach ($selected_siswa as $siswa_id) {
                    if (isset($_POST['nilai'][$siswa_id]) && 
                        !empty($_POST['nilai'][$siswa_id]['nilai']) && 
                        $_POST['nilai'][$siswa_id]['nilai'] > 0) {
                        
                        $nilai_data = $_POST['nilai'][$siswa_id];
                        
                        $data = [
                            'tp_id' => $tp_id,
                            'siswa_id' => $siswa_id,
                            'jenis_penilaian' => $_POST['jenis_penilaian'] ?? 'tes_tertulis_objektif',
                            'nilai' => floatval($nilai_data['nilai']),
                            'deskripsi' => $nilai_data['deskripsi'] ?? '',
                            'updated_by' => $guruId
                        ];
                        
                        echo "<!-- Input Nilai Sumatif Data for siswa $siswa_id: " . print_r($data, true) . " -->\n";
                        
                        if ($guruModel->inputNilaiSumatifTP($data)) {
                            $success_count++;
                            echo "<!-- Success for siswa $siswa_id -->\n";
                        } else {
                            $error_count++;
                            echo "<!-- Failed for siswa $siswa_id -->\n";
                        }
                    } else {
                        echo "<!-- Skipped siswa $siswa_id - no valid nilai -->\n";
                    }
                }
                
                if ($success_count > 0) {
                    $message = "Berhasil menyimpan $success_count nilai sumatif!";
                    $message_type = 'success';
                    if ($error_count > 0) {
                        $message .= " ($error_count gagal)";
                    }
                } else {
                    $message = 'Tidak ada nilai yang berhasil disimpan! Pastikan:';
                    $message_type = 'warning';
                    $message .= '<br>- Pilih siswa yang akan dinilai';
                    $message .= '<br>- Isi nilai untuk siswa terpilih';
                    $message .= '<br>- Nilai harus antara 0-100';
                }
            } else {
                $message = 'Tidak ada data nilai yang valid! Pastikan memilih siswa dan mengisi nilai.';
                $message_type = 'danger';
            }
        }
        elseif (isset($_POST['update_nilai_siswa'])) {
            $data = [
                'tp_id' => $tp_id,
                'siswa_id' => $_POST['siswa_id'],
                'jenis_penilaian' => $_POST['jenis_penilaian'],
                'nilai' => $_POST['nilai'],
                'deskripsi' => $_POST['deskripsi'],
                'updated_by' => $guruId
            ];
            
            echo "<!-- Update Nilai Sumatif Data: " . print_r($data, true) . " -->\n";
            
            if ($guruModel->inputNilaiSumatifTP($data)) {
                $message = 'Nilai sumatif siswa berhasil diperbarui!';
                $message_type = 'success';
                // Redirect untuk menghindari resubmission
                header("Location: ?tp_id=$tp_id&action=edit&siswa_id=" . $_POST['siswa_id'] . "&message=" . urlencode($message) . "&message_type=" . $message_type);
                exit();
            } else {
                $message = 'Gagal memperbarui nilai sumatif siswa!';
                $message_type = 'danger';
            }
        }
    } catch (Exception $e) {
        $message = 'Error: ' . $e->getMessage();
        $message_type = 'danger';
        echo "<!-- Exception: " . $e->getMessage() . " -->\n";
    }
}

// Check for message from redirect
if (isset($_GET['message']) && isset($_GET['message_type'])) {
    $message = $_GET['message'];
    $message_type = $_GET['message_type'];
}

// Get data based on action
$tp_data = null;
$nilai_list = [];
$siswa_list = [];

if ($tp_id) {
    // Validate TP access
    if (!$guruModel->validateGuruTPAccess($guruId, $tp_id)) {
        $message = 'Anda tidak memiliki akses ke TP ini!';
        $message_type = 'danger';
        $tp_id = null;
    } else {
        $tp_data = $guruModel->getTPById($tp_id);
        $nilai_list = $guruModel->getNilaiSumatifTP($tp_id);
        
        // Get siswa list for this kelas
        if ($tp_data && !empty($tp_data['kelas_id'])) {
            $kelas_id = $tp_data['kelas_id'];
            
            if (method_exists($guruModel, 'getSiswaByKelasForNilai')) {
                $siswa_list = $guruModel->getSiswaByKelasForNilai($kelas_id);
            } else {
                $siswa_list = $guruModel->getSiswaByKelas($kelas_id);
            }
        }
    }
}

// Get specific siswa for edit
$siswa_edit = null;
if (isset($_GET['siswa_id']) && $action === 'edit') {
    $siswa_id = $_GET['siswa_id'];
    // Find the nilai data for this siswa
    foreach ($nilai_list as $nilai) {
        if ($nilai['siswa_id'] == $siswa_id) {
            $siswa_edit = $nilai;
            break;
        }
    }
    
    // If no nilai found, get siswa data
    if (!$siswa_edit) {
        foreach ($siswa_list as $siswa) {
            if ($siswa['id'] == $siswa_id) {
                $siswa_edit = $siswa;
                $siswa_edit['nilai'] = '';
                $siswa_edit['deskripsi'] = '';
                $siswa_edit['jenis_penilaian'] = 'tes_tertulis_objektif';
                break;
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nilai Sumatif - Sistem Penilaian</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .navbar-brand {
            font-weight: 600;
        }
        
        .card {
            border-radius: 12px;
            border: none;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
        }
        
        .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
        }
        
        .card-header {
            border-radius: 12px 12px 0 0 !important;
            border-bottom: 1px solid rgba(0,0,0,0.05);
            font-weight: 600;
        }
        
        .btn {
            border-radius: 8px;
            font-weight: 500;
            transition: all 0.2s ease;
        }
        
        .table {
            border-radius: 10px;
            overflow: hidden;
        }
        
        .table thead th {
            background-color: #f8f9fa;
            border-bottom: 2px solid #dee2e6;
            font-weight: 600;
        }
        
        .badge {
            font-weight: 500;
        }
        
        .nilai-input {
            max-width: 100px;
        }
        
        .deskripsi-input {
            font-size: 0.875rem;
        }
        
        .progress {
            height: 8px;
        }
        
        .stats-card {
            border-left: 4px solid #007bff;
        }
        
        .stats-card.success {
            border-left-color: #28a745;
        }
        
        .stats-card.warning {
            border-left-color: #ffc107;
        }
        
        .stats-card.info {
            border-left-color: #17a2b8;
        }
        
        .hover-row:hover {
            background-color: rgba(0, 123, 255, 0.05) !important;
        }
        
        .table-success {
            background-color: rgba(40, 167, 69, 0.1) !important;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <!-- Header -->
        <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
            <div class="container">
                <a class="navbar-brand" href="#">
                    <i class="bi bi-graph-up"></i> Nilai Sumatif
                </a>
                <div class="navbar-nav ms-auto">
                    <span class="navbar-text me-3">
                        <i class="bi bi-person-circle"></i> <?= htmlspecialchars($userData['nama']) ?>
                    </span>
                    <a href="tujuan_pembelajaran.php" class="btn btn-outline-light btn-sm me-2">
                        <i class="bi bi-arrow-left"></i> Kembali
                    </a>
                    <a href="dashboard.php" class="btn btn-outline-light btn-sm me-2">
                        <i class="bi bi-house"></i> Dashboard
                    </a>
                </div>
            </div>
        </nav>

        <div class="container mt-4">
            <!-- Messages -->
            <?php if ($message): ?>
            <div class="alert alert-<?= $message_type ?> alert-dismissible fade show" role="alert">
                <div class="d-flex align-items-center">
                    <i class="bi bi-<?= $message_type == 'success' ? 'check-circle' : 'exclamation-triangle' ?> me-2"></i>
                    <div><?= $message ?></div>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php endif; ?>

            <!-- Breadcrumb -->
            <nav aria-label="breadcrumb" class="mb-4">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="tujuan_pembelajaran.php">Tujuan Pembelajaran</a></li>
                    <?php if ($tp_data): ?>
                        <li class="breadcrumb-item active">Nilai Sumatif</li>
                    <?php endif; ?>
                </ol>
            </nav>

            <?php if ($tp_data): ?>
                <!-- TP Header -->
                <div class="card mb-4">
                    <div class="card-header bg-primary text-white">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-0"><?= htmlspecialchars($tp_data['kode_tp']) ?></h5>
                                <small>
                                    <?= $tp_data['nama_mapel'] ?> - 
                                    <?= $tp_data['nama_kelas'] ?> - 
                                    <?= $tp_data['tahun_ajaran'] ?> (<?= $tp_data['semester'] ?>)
                                </small>
                            </div>
                            <div class="text-end">
                                <small>Status: 
                                    <span class="badge bg-<?= $tp_data['status'] == 'aktif' ? 'success' : 'secondary' ?>">
                                        <?= ucfirst($tp_data['status']) ?>
                                    </span>
                                </small>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-8">
                                <p class="mb-2"><strong>Deskripsi TP:</strong></p>
                                <p class="text-muted"><?= nl2br(htmlspecialchars($tp_data['deskripsi'])) ?></p>
                            </div>
                            <div class="col-md-4">
                                <div class="row">
                                    <div class="col-6">
                                        <div class="card stats-card">
                                            <div class="card-body p-3">
                                                <div class="text-muted small">Total Siswa</div>
                                                <div class="h5 mb-0"><?= count($siswa_list) ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="card stats-card success">
                                            <div class="card-body p-3">
                                                <div class="text-muted small">Sudah Dinilai</div>
                                                <div class="h5 mb-0"><?= count($nilai_list) ?></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Progress Bar -->
                        <?php if (count($siswa_list) > 0): ?>
                        <div class="mt-3">
                            <div class="d-flex justify-content-between mb-1">
                                <small>Progress Penilaian Sumatif</small>
                                <small><?= count($nilai_list) ?> / <?= count($siswa_list) ?></small>
                            </div>
                            <div class="progress">
                                <div class="progress-bar <?= count($nilai_list) == count($siswa_list) ? 'bg-success' : 'bg-primary' ?>" 
                                     role="progressbar" 
                                     style="width: <?= (count($nilai_list) / count($siswa_list)) * 100 ?>%"
                                     aria-valuenow="<?= (count($nilai_list) / count($siswa_list)) * 100 ?>" 
                                     aria-valuemin="0" 
                                     aria-valuemax="100">
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <?php if ($action === 'edit' && $siswa_edit): ?>
                    <!-- Edit Form for Single Student -->
                    <div class="card">
                        <div class="card-header bg-warning text-dark">
                            <div class="d-flex justify-content-between align-items-center">
                                <h6 class="mb-0">
                                    <i class="bi bi-pencil"></i> Edit Nilai Sumatif - 
                                    <?= htmlspecialchars($siswa_edit['nama_siswa'] ?? $siswa_edit['nama']) ?>
                                </h6>
                                <a href="?tp_id=<?= $tp_id ?>" class="btn btn-dark btn-sm">
                                    <i class="bi bi-arrow-left"></i> Kembali
                                </a>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="POST">
                                <input type="hidden" name="update_nilai_siswa" value="1">
                                <input type="hidden" name="siswa_id" value="<?= $siswa_edit['siswa_id'] ?? $siswa_edit['id'] ?>">
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Nama Siswa</label>
                                        <input type="text" class="form-control" value="<?= htmlspecialchars($siswa_edit['nama_siswa'] ?? $siswa_edit['nama']) ?>" readonly>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label class="form-label">NIS</label>
                                        <input type="text" class="form-control" value="<?= htmlspecialchars($siswa_edit['nis']) ?>" readonly>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label class="form-label">Kelas</label>
                                        <input type="text" class="form-control" value="<?= htmlspecialchars($siswa_edit['nama_kelas'] ?? $tp_data['nama_kelas']) ?>" readonly>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Jenis Penilaian <span class="text-danger">*</span></label>
                                        <select class="form-select" name="jenis_penilaian" required>
                                            <option value="tes_kinerja" <?= ($siswa_edit['jenis_penilaian'] ?? 'tes_tertulis_objektif') == 'tes_kinerja' ? 'selected' : '' ?>>Tes Kinerja</option>
                                            <option value="proyek_besar" <?= ($siswa_edit['jenis_penilaian'] ?? 'tes_tertulis_objektif') == 'proyek_besar' ? 'selected' : '' ?>>Proyek Besar</option>
                                            <option value="portofolio_akhir" <?= ($siswa_edit['jenis_penilaian'] ?? 'tes_tertulis_objektif') == 'portofolio_akhir' ? 'selected' : '' ?>>Portofolio Akhir</option>
                                            <option value="tes_lisan" <?= ($siswa_edit['jenis_penilaian'] ?? 'tes_tertulis_objektif') == 'tes_lisan' ? 'selected' : '' ?>>Tes Lisan</option>
                                            <option value="tes_tertulis_subjektif" <?= ($siswa_edit['jenis_penilaian'] ?? 'tes_tertulis_objektif') == 'tes_tertulis_subjektif' ? 'selected' : '' ?>>Tes Tertulis Subjektif</option>
                                            <option value="tes_tertulis_objektif" <?= ($siswa_edit['jenis_penilaian'] ?? 'tes_tertulis_objektif') == 'tes_tertulis_objektif' ? 'selected' : '' ?>>Tes Tertulis Objektif</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Nilai <span class="text-danger">*</span></label>
                                        <input type="number" class="form-control" name="nilai" 
                                               value="<?= $siswa_edit['nilai'] ?? '' ?>" min="0" max="100" step="0.01" 
                                               placeholder="0-100" required>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Status</label>
                                        <input type="text" class="form-control" 
                                               value="<?= isset($siswa_edit['nilai']) ? 'Sudah Dinilai' : 'Belum Dinilai' ?>" 
                                               style="color: <?= isset($siswa_edit['nilai']) ? '#28a745' : '#dc3545' ?>; font-weight: bold;" 
                                               readonly>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label">Deskripsi / Catatan</label>
                                    <textarea class="form-control" name="deskripsi" rows="3" 
                                              placeholder="Catatan tentang penilaian sumatif siswa..."><?= htmlspecialchars($siswa_edit['deskripsi'] ?? '') ?></textarea>
                                </div>
                                
                                <div class="d-flex gap-2">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-check-circle"></i> Simpan Perubahan
                                    </button>
                                    <a href="?tp_id=<?= $tp_id ?>" class="btn btn-secondary">
                                        <i class="bi bi-x-circle"></i> Batal
                                    </a>
                                </div>
                            </form>
                        </div>
                    </div>

                <?php else: ?>
                    <!-- Bulk Input Form -->
                    <div class="card mb-4">
                        <div class="card-header bg-success text-white">
                            <h6 class="mb-0"><i class="bi bi-upload"></i> Input Nilai Sumatif Massal</h6>
                        </div>
                        <div class="card-body">
							<form method="POST" id="nilaiForm">
    <input type="hidden" name="input_nilai_sumatif" value="1">
    <input type="hidden" name="jenis_penilaian" value="tes_tertulis_objektif" id="jenisPenilaian">
    
    <div class="row mb-3">
        <div class="col-md-4">
            <label class="form-label">Jenis Penilaian untuk Semua Siswa</label>
            <select class="form-select" id="globalJenisPenilaian">
                <option value="tes_kinerja">Tes Kinerja</option>
                <option value="proyek_besar">Proyek Besar</option>
                <option value="portofolio_akhir">Portofolio Akhir</option>
                <option value="tes_lisan">Tes Lisan</option>
                <option value="tes_tertulis_subjektif">Tes Tertulis Subjektif</option>
                <option value="tes_tertulis_objektif" selected>Tes Tertulis Objektif</option>
            </select>
        </div>
        <div class="col-md-8 d-flex align-items-end">
            <div class="form-check">
                <input class="form-check-input" type="checkbox" id="selectAll">
                <label class="form-check-label" for="selectAll">
                    Pilih Semua Siswa
                </label>
            </div>
        </div>
    </div>

    <div class="table-responsive">
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th width="50">
                        <input type="checkbox" id="checkAll">
                    </th>
                    <th>Nama Siswa</th>
                    <th>NIS</th>
                    <th width="120">Nilai</th>
                    <th>Deskripsi</th>
                    <th width="100">Status</th>
                    <th width="100">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($siswa_list)): ?>
                    <?php foreach ($siswa_list as $siswa): ?>
                        <?php
                        $nilai_siswa = null;
                        foreach ($nilai_list as $nilai) {
                            if ($nilai['siswa_id'] == $siswa['id']) {
                                $nilai_siswa = $nilai;
                                break;
                            }
                        }
                        ?>
                        <tr class="hover-row <?= $nilai_siswa ? 'table-success' : '' ?>">
                            <td>
                                <!-- FIELD PENTING INI -->
                                <input type="checkbox" class="siswa-check" name="selected_siswa[]" value="<?= $siswa['id'] ?>" 
                                       <?= $nilai_siswa ? 'checked' : '' ?>>
                            </td>
                            <td>
                                <strong><?= htmlspecialchars($siswa['nama']) ?></strong>
                            </td>
                            <td><?= htmlspecialchars($siswa['nis']) ?></td>
                            <td>
                                <input type="number" class="form-control form-control-sm nilai-input" 
                                       name="nilai[<?= $siswa['id'] ?>][nilai]" 
                                       value="<?= $nilai_siswa['nilai'] ?? '' ?>" 
                                       min="0" max="100" step="0.01" 
                                       placeholder="0-100">
                            </td>
                            <td>
                                <input type="text" class="form-control form-control-sm deskripsi-input" 
                                       name="nilai[<?= $siswa['id'] ?>][deskripsi]" 
                                       value="<?= htmlspecialchars($nilai_siswa['deskripsi'] ?? '') ?>" 
                                       placeholder="Catatan...">
                            </td>
                            <td>
                                <?php if ($nilai_siswa): ?>
                                    <span class="badge bg-success">Sudah</span>
                                <?php else: ?>
                                    <span class="badge bg-warning">Belum</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="?tp_id=<?= $tp_id ?>&action=edit&siswa_id=<?= $siswa['id'] ?>" 
                                   class="btn btn-outline-primary btn-sm">
                                    <i class="bi bi-pencil"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7" class="text-center py-4">
                            <i class="bi bi-people fs-1 text-muted"></i>
                            <p class="text-muted mt-2">Tidak ada siswa dalam kelas ini.</p>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    
    <?php if (!empty($siswa_list)): ?>
    <div class="d-flex justify-content-between align-items-center mt-3">
        <div class="text-muted">
            <small>Terpilih: <span id="selectedCount">0</span> dari <?= count($siswa_list) ?> siswa</small>
        </div>
        <button type="submit" class="btn btn-success">
            <i class="bi bi-save"></i> Simpan Nilai Terpilih
        </button>
    </div>
    <?php endif; ?>
</form>
                            
                        </div>
                    </div>

                    <!-- Nilai Summary -->
                    <?php if (!empty($nilai_list)): ?>
                    <div class="card">
                        <div class="card-header bg-info text-white">
                            <h6 class="mb-0"><i class="bi bi-graph-up"></i> Ringkasan Nilai Sumatif</h6>
                        </div>
                        <div class="card-body">
                            <?php
                            $nilai_values = array_column($nilai_list, 'nilai');
                            $rata_rata = count($nilai_values) > 0 ? array_sum($nilai_values) / count($nilai_values) : 0;
                            $tertinggi = count($nilai_values) > 0 ? max($nilai_values) : 0;
                            $terendah = count($nilai_values) > 0 ? min($nilai_values) : 0;
                            ?>
                            <div class="row text-center">
                                <div class="col-md-3">
                                    <div class="card bg-light">
                                        <div class="card-body py-3">
                                            <div class="text-muted small">Rata-rata</div>
                                            <div class="h4 mb-0 text-primary"><?= number_format($rata_rata, 2) ?></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card bg-light">
                                        <div class="card-body py-3">
                                            <div class="text-muted small">Nilai Tertinggi</div>
                                            <div class="h4 mb-0 text-success"><?= number_format($tertinggi, 2) ?></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card bg-light">
                                        <div class="card-body py-3">
                                            <div class="text-muted small">Nilai Terendah</div>
                                            <div class="h4 mb-0 text-danger"><?= number_format($terendah, 2) ?></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card bg-light">
                                        <div class="card-body py-3">
                                            <div class="text-muted small">Siswa Dinilai</div>
                                            <div class="h4 mb-0 text-info"><?= count($nilai_list) ?> / <?= count($siswa_list) ?></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                <?php endif; ?>

            <?php else: ?>
                <!-- No TP Selected -->
                <div class="card">
                    <div class="card-body text-center py-5">
                        <i class="bi bi-exclamation-circle fs-1 text-warning mb-3"></i>
                        <h4>TP Tidak Ditemukan</h4>
                        <p class="text-muted">
                            Pilih tujuan pembelajaran terlebih dahulu untuk menginput nilai sumatif.
                        </p>
                        <a href="tujuan_pembelajaran.php" class="btn btn-primary">
                            <i class="bi bi-arrow-left"></i> Kembali ke Tujuan Pembelajaran
                        </a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Global jenis penilaian
            const globalJenisSelect = document.getElementById('globalJenisPenilaian');
            const jenisPenilaianInput = document.getElementById('jenisPenilaian');
            
            if (globalJenisSelect && jenisPenilaianInput) {
                globalJenisSelect.addEventListener('change', function() {
                    jenisPenilaianInput.value = this.value;
                });
                
                // Set initial value
                jenisPenilaianInput.value = globalJenisSelect.value;
            }
            
            // Select all functionality
            const checkAll = document.getElementById('checkAll');
            const selectAll = document.getElementById('selectAll');
            const siswaChecks = document.querySelectorAll('.siswa-check');
            const selectedCount = document.getElementById('selectedCount');
            
            function updateSelectedCount() {
                const checked = document.querySelectorAll('.siswa-check:checked').length;
                selectedCount.textContent = checked;
            }
            
            if (checkAll) {
                checkAll.addEventListener('change', function() {
                    siswaChecks.forEach(check => {
                        check.checked = this.checked;
                    });
                    updateSelectedCount();
                });
            }
            
            if (selectAll) {
                selectAll.addEventListener('change', function() {
                    siswaChecks.forEach(check => {
                        check.checked = this.checked;
                    });
                    updateSelectedCount();
                });
            }
            
            siswaChecks.forEach(check => {
                check.addEventListener('change', updateSelectedCount);
            });
            
            // Initial count
            updateSelectedCount();
            
            // Auto-hide alerts after 5 seconds
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(alert => {
                setTimeout(() => {
                    if (alert) {
                        const bsAlert = new bootstrap.Alert(alert);
                        bsAlert.close();
                    }
                }, 5000);
            });
            
            // Form submission confirmation
			// Form submission confirmation
			const form = document.getElementById('nilaiForm');
			if (form) {
				form.addEventListener('submit', function(e) {
					const checked = document.querySelectorAll('.siswa-check:checked');
					if (checked.length === 0) {
						e.preventDefault();
						alert('Pilih setidaknya satu siswa untuk dinilai!');
						return false;
					}
					
					// Check if at least one selected student has a nilai
					let hasValidNilai = false;
					checked.forEach(check => {
						const siswaId = check.value;
						const nilaiInput = document.querySelector(`input[name="nilai[${siswaId}][nilai]"]`);
						if (nilaiInput && nilaiInput.value && nilaiInput.value > 0) {
							hasValidNilai = true;
						}
					});
					
					if (!hasValidNilai) {
						e.preventDefault();
						alert('Setidaknya satu siswa terpilih harus memiliki nilai yang valid (0-100)!');
						return false;
					}
					
					return true;
				});
			}
			
        });
    </script>
</body>
</html>