<?php
require_once __DIR__ . '/../../app/config/config.php';
Session::checkAuth();
Session::checkRole(['guru']);

$guruModel = new GuruModel();
$userData = Session::getUserData();
$guruId = $userData['guru_id'];

// Debug info
echo "<!-- DEBUG INFO -->";
echo "<!-- Guru ID: " . $guruId . " -->";
echo "<!-- User Data: " . print_r($userData, true) . " -->";

// Get parameters
$kegiatan_id = $_GET['kegiatan_id'] ?? null;
$action = $_GET['action'] ?? 'list';

// Debug parameters
echo "<!-- Action: " . $action . " -->";
echo "<!-- Kegiatan ID: " . $kegiatan_id . " -->";

// Process actions
$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    echo "<!-- POST Data: " . print_r($_POST, true) . " -->";
    
    try {
        if (isset($_POST['input_nilai'])) {
            $success_count = 0;
            $error_count = 0;
            
            // Debug selected students
            $selected_siswa = $_POST['selected_siswa'] ?? [];
            echo "<!-- Selected Siswa: " . print_r($selected_siswa, true) . " -->";
            
            if (isset($_POST['nilai']) && is_array($_POST['nilai']) && !empty($selected_siswa)) {
                foreach ($selected_siswa as $siswa_id) {
                    if (isset($_POST['nilai'][$siswa_id]) && 
                        !empty($_POST['nilai'][$siswa_id]['nilai']) && 
                        $_POST['nilai'][$siswa_id]['nilai'] > 0) {
                        
                        $nilai_data = $_POST['nilai'][$siswa_id];
                        
                        $data = [
                            'kegiatan_formatif_id' => $kegiatan_id,
                            'tp_id' => $_POST['tp_id'],
                            'siswa_id' => $siswa_id,
                            'jenis' => $_POST['jenis_penilaian'] ?? 'tugas_tertulis',
                            'nilai' => floatval($nilai_data['nilai']),
                            'deskripsi' => $nilai_data['deskripsi'] ?? '',
                            'updated_by' => $guruId
                        ];
                        
                        echo "<!-- Input Nilai Data for siswa $siswa_id: " . print_r($data, true) . " -->";
                        
                        if ($guruModel->inputNilaiFormatifWithKegiatan($data)) {
                            $success_count++;
                            echo "<!-- Success for siswa $siswa_id -->";
                        } else {
                            $error_count++;
                            echo "<!-- Failed for siswa $siswa_id -->";
                        }
                    } else {
                        echo "<!-- Skipped siswa $siswa_id - no valid nilai -->";
                    }
                }
                
                if ($success_count > 0) {
                    $message = "Berhasil menyimpan $success_count nilai!";
                    $message_type = 'success';
                    if ($error_count > 0) {
                        $message .= " ($error_count gagal)";
                    }
                } else {
                    $message = 'Tidak ada nilai yang berhasil disimpan! Pastikan:';
                    $message_type = 'warning';
                    $message .= '<br>- Pilih siswa yang akan dinilai';
                    $message .= '<br>- Isi nilai untuk siswa terpilih';
                    $message .= '<br>- Nilai harus antara 0-100';
                }
            } else {
                $message = 'Tidak ada data nilai yang valid! Pastikan memilih siswa dan mengisi nilai.';
                $message_type = 'danger';
            }
        }
        // ... kode update_nilai_siswa tetap sama
    } catch (Exception $e) {
        $message = 'Error: ' . $e->getMessage();
        $message_type = 'danger';
        echo "<!-- Exception: " . $e->getMessage() . " -->";
    }
}

// Check for message from redirect
if (isset($_GET['message']) && isset($_GET['message_type'])) {
    $message = $_GET['message'];
    $message_type = $_GET['message_type'];
}

// Get data based on action
// Get data based on action

$kegiatan_data = null;
$nilai_list = [];
$siswa_list = [];
$tp_data = null;

// Debug info yang lebih detail
echo "<!-- DEBUG INFO -->";
echo "<!-- Guru ID: " . $guruId . " -->";
echo "<!-- User Data: " . print_r($userData, true) . " -->";
echo "<!-- Kegiatan ID: " . $kegiatan_id . " -->";
echo "<!-- Action: " . $action . " -->";

if ($kegiatan_data) {
    echo "<!-- Kegiatan Data Available: YES -->";
    echo "<!-- Kelas ID: " . ($kegiatan_data['kelas_id'] ?? 'NULL') . " -->";
    echo "<!-- TP ID: " . ($kegiatan_data['tp_id'] ?? 'NULL') . " -->";
    echo "<!-- Mapel ID: " . ($kegiatan_data['mapel_id'] ?? 'NULL') . " -->";
} else {
    echo "<!-- Kegiatan Data Available: NO -->";
}

if ($kegiatan_id) {
    // Validate kegiatan access
    if (!$guruModel->validateGuruKegiatanAccess($guruId, $kegiatan_id)) {
        $message = 'Anda tidak memiliki akses ke kegiatan ini!';
        $message_type = 'danger';
        $kegiatan_id = null;
    } else {
        // Gunakan method yang sudah diperbaiki
        if (method_exists($guruModel, 'getKegiatanFormatifWithKelas')) {
            $kegiatan_data = $guruModel->getKegiatanFormatifWithKelas($kegiatan_id);
            echo "<!-- Using getKegiatanFormatifWithKelas -->";
        } else {
            // Fallback ke method lama
            $kegiatan_data = $guruModel->getKegiatanFormatifById($kegiatan_id);
            echo "<!-- Using getKegiatanFormatifById -->";
        }
        
        $nilai_list = $guruModel->getNilaiFormatifByKegiatan($kegiatan_id);
        
        // Get siswa list for this kelas
        	
		// Get siswa list for this kelas
		if ($kegiatan_data && !empty($kegiatan_data['kelas_id'])) {
			$kelas_id = $kegiatan_data['kelas_id'];
			
			echo "<!-- Kelas ID for siswa query: " . $kelas_id . " -->";
			
			// Coba beberapa method berbeda
			if (method_exists($guruModel, 'getSiswaByKelasForNilai')) {
				$siswa_list = $guruModel->getSiswaByKelasForNilai($kelas_id);
				echo "<!-- Method used: getSiswaByKelasForNilai -->";
				echo "<!-- Siswa count from getSiswaByKelasForNilai: " . count($siswa_list) . " -->";
			} elseif (method_exists($guruModel, 'getSiswaByKelas')) {
				$siswa_list = $guruModel->getSiswaByKelas($kelas_id);
				echo "<!-- Method used: getSiswaByKelas -->";
				echo "<!-- Siswa count from getSiswaByKelas: " . count($siswa_list) . " -->";
			} else {
				echo "<!-- ERROR: No siswa method available -->";
				$siswa_list = [];
			}
			
			// Fallback: jika masih kosong, coba method alternatif
			if (empty($siswa_list)) {
				echo "<!-- Trying alternative methods -->";
				if (method_exists($guruModel, 'getAllSiswa')) {
					$all_siswa = $guruModel->getAllSiswa();
					$siswa_list = array_filter($all_siswa, function($siswa) use ($kelas_id) {
						return $siswa['kelas_id'] == $kelas_id;
					});
					echo "<!-- Siswa count from getAllSiswa + filter: " . count($siswa_list) . " -->";
				}
			}
			
			$tp_data = $guruModel->getTPById($kegiatan_data['tp_id']);
		} else {
			echo "<!-- ERROR: kegiatan_data or kelas_id not available -->";
			echo "<!-- Kegiatan Data: " . print_r($kegiatan_data, true) . " -->";
			$siswa_list = [];
		}
        
        echo "<!-- Kegiatan Data: " . print_r($kegiatan_data, true) . " -->";
        echo "<!-- Nilai Count: " . count($nilai_list) . " -->";
        echo "<!-- Siswa Count: " . count($siswa_list) . " -->";
    }
	
	
}

// Get specific siswa for edit
$siswa_edit = null;
if (isset($_GET['siswa_id']) && $action === 'edit') {
    $siswa_id = $_GET['siswa_id'];
    // Find the nilai data for this siswa
    foreach ($nilai_list as $nilai) {
        if ($nilai['siswa_id'] == $siswa_id) {
            $siswa_edit = $nilai;
            break;
        }
    }
    
    // If no nilai found, get siswa data
    if (!$siswa_edit) {
        foreach ($siswa_list as $siswa) {
            if ($siswa['id'] == $siswa_id) {
                $siswa_edit = $siswa;
                $siswa_edit['nilai'] = '';
                $siswa_edit['deskripsi'] = '';
                break;
            }
        }
    }
    
    echo "<!-- Siswa Edit Data: " . print_r($siswa_edit, true) . " -->";
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nilai Formatif - Sistem Penilaian</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .navbar-brand {
            font-weight: 600;
        }
        
        .card {
            border-radius: 12px;
            border: none;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
        }
        
        .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
        }
        
        .card-header {
            border-radius: 12px 12px 0 0 !important;
            border-bottom: 1px solid rgba(0,0,0,0.05);
            font-weight: 600;
        }
        
        .btn {
            border-radius: 8px;
            font-weight: 500;
            transition: all 0.2s ease;
        }
        
        .table {
            border-radius: 10px;
            overflow: hidden;
        }
        
        .table thead th {
            background-color: #f8f9fa;
            border-bottom: 2px solid #dee2e6;
            font-weight: 600;
        }
        
        .badge {
            font-weight: 500;
        }
        
        .debug-panel {
            background: #f8f9fa;
            border-left: 4px solid #dc3545;
            padding: 10px;
            margin: 10px 0;
            border-radius: 4px;
            font-family: monospace;
            font-size: 12px;
        }
        
        .nilai-input {
            max-width: 100px;
        }
        
        .deskripsi-input {
            font-size: 0.875rem;
        }
        
        .progress {
            height: 8px;
        }
        
        .stats-card {
            border-left: 4px solid #007bff;
        }
        
        .stats-card.success {
            border-left-color: #28a745;
        }
        
        .stats-card.warning {
            border-left-color: #ffc107;
        }
        
        .stats-card.info {
            border-left-color: #17a2b8;
        }
        
        .hover-row:hover {
            background-color: rgba(0, 123, 255, 0.05) !important;
        }
        
        .btn-group .btn {
            border-radius: 6px;
        }
        
        .table-success {
            background-color: rgba(40, 167, 69, 0.1) !important;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <!-- Header -->
        <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
            <div class="container">
                <a class="navbar-brand" href="#">
                    <i class="bi bi-pencil-square"></i> Nilai Formatif
                </a>
                <div class="navbar-nav ms-auto">
                    <span class="navbar-text me-3">
                        <i class="bi bi-person-circle"></i> <?= htmlspecialchars($userData['nama']) ?>
                    </span>
                    <a href="kegiatan_formatif.php" class="btn btn-outline-light btn-sm me-2">
                        <i class="bi bi-arrow-left"></i> Kembali
                    </a>
                    <a href="dashboard.php" class="btn btn-outline-light btn-sm me-2">
                        <i class="bi bi-house"></i> Dashboard
                    </a>
                </div>
            </div>
        </nav>

        <div class="container mt-4">
            <!-- Debug Panel (akan disembunyikan di production) -->
            <?php if (isset($_GET['debug'])): ?>
            <div class="debug-panel">
                <strong>Debug Information:</strong><br>
                Guru ID: <?= $guruId ?><br>
                Action: <?= $action ?><br>
                Kegiatan ID: <?= $kegiatan_id ?><br>
                Kegiatan Data: <?= print_r($kegiatan_data, true) ?><br>
                Nilai Count: <?= count($nilai_list) ?><br>
                Siswa Count: <?= count($siswa_list) ?><br>
                Kelas ID: <?= $kegiatan_data ? $kegiatan_data['kelas_id'] : 'null' ?><br>
                Method Used: <?= method_exists($guruModel, 'getSiswaByKelasForNilai') ? 'getSiswaByKelasForNilai' : 'getSiswaByKelas' ?>
            </div>
            <?php endif; ?>

            <!-- Messages -->
            <?php if ($message): ?>
            <div class="alert alert-<?= $message_type ?> alert-dismissible fade show" role="alert">
                <div class="d-flex align-items-center">
                    <i class="bi bi-<?= $message_type == 'success' ? 'check-circle' : 'exclamation-triangle' ?> me-2"></i>
                    <div><?= $message ?></div>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php endif; ?>

            <!-- Breadcrumb -->
            <nav aria-label="breadcrumb" class="mb-4">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="kegiatan_formatif.php">Kegiatan Formatif</a></li>
                    <?php if ($kegiatan_data): ?>
                        <li class="breadcrumb-item active">Nilai Formatif</li>
                    <?php endif; ?>
                </ol>
            </nav>

            <?php if ($kegiatan_data && $tp_data): ?>
                <!-- Kegiatan Header -->
                <div class="card mb-4">
                    <div class="card-header bg-primary text-white">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-0"><?= htmlspecialchars($kegiatan_data['nama_kegiatan']) ?></h5>
                                <small>
                                    <?= $tp_data['kode_tp'] ?> - 
                                    <?= $kegiatan_data['nama_mapel'] ?> - 
                                    <?= $kegiatan_data['nama_kelas'] ?>
                                </small>
                            </div>
                            <div class="text-end">
                                <small>Tanggal: <?= date('d/m/Y', strtotime($kegiatan_data['tanggal'])) ?></small><br>
                                <small>Bobot: <?= $kegiatan_data['bobot'] ?>%</small>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-8">
                                <p class="mb-2"><strong>Deskripsi Kegiatan:</strong></p>
                                <p class="text-muted"><?= $kegiatan_data['deskripsi'] ? nl2br(htmlspecialchars($kegiatan_data['deskripsi'])) : '<em>Tidak ada deskripsi</em>' ?></p>
                            </div>
                            <div class="col-md-4">
                                <div class="row">
                                    <div class="col-6">
                                        <div class="card stats-card">
                                            <div class="card-body p-3">
                                                <div class="text-muted small">Total Siswa</div>
                                                <div class="h5 mb-0"><?= count($siswa_list) ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="card stats-card success">
                                            <div class="card-body p-3">
                                                <div class="text-muted small">Sudah Dinilai</div>
                                                <div class="h5 mb-0"><?= count($nilai_list) ?></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Progress Bar -->
						<!-- Progress Bar -->
						<?php if (count($siswa_list) > 0): ?>
						<div class="mt-3">
							<div class="d-flex justify-content-between mb-1">
								<small>Progress Penilaian</small>
								<small><?= count($nilai_list) ?> / <?= count($siswa_list) ?></small>
							</div>
							<div class="progress">
								<div class="progress-bar <?= count($nilai_list) == count($siswa_list) ? 'bg-success' : 'bg-primary' ?>" 
									 role="progressbar" 
									 style="width: <?= (count($siswa_list) > 0 ? (count($nilai_list) / count($siswa_list)) * 100 : 0) ?>%"
									 aria-valuenow="<?= (count($siswa_list) > 0 ? (count($nilai_list) / count($siswa_list)) * 100 : 0) ?>" 
									 aria-valuemin="0" 
									 aria-valuemax="100">
								</div>
							</div>
						</div>
						<?php else: ?>
						<div class="mt-3">
							<div class="alert alert-warning">
								<i class="bi bi-exclamation-triangle"></i> Tidak ada data siswa yang ditemukan untuk kelas ini.
							</div>
						</div>
						<?php endif; ?>						
                    </div>
                </div>

                <?php if ($action === 'edit' && $siswa_edit): ?>
                    <!-- Edit Form for Single Student -->
                    <div class="card">
                        <div class="card-header bg-warning text-dark">
                            <div class="d-flex justify-content-between align-items-center">
                                <h6 class="mb-0">
                                    <i class="bi bi-pencil"></i> Edit Nilai - 
                                    <?= htmlspecialchars($siswa_edit['nama_siswa'] ?? $siswa_edit['nama']) ?>
                                </h6>
                                <a href="?kegiatan_id=<?= $kegiatan_id ?>" class="btn btn-dark btn-sm">
                                    <i class="bi bi-arrow-left"></i> Kembali
                                </a>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="POST">
                                <input type="hidden" name="update_nilai_siswa" value="1">
                                <input type="hidden" name="tp_id" value="<?= $kegiatan_data['tp_id'] ?>">
                                <input type="hidden" name="siswa_id" value="<?= $siswa_edit['siswa_id'] ?? $siswa_edit['id'] ?>">
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Nama Siswa</label>
                                        <input type="text" class="form-control" value="<?= htmlspecialchars($siswa_edit['nama_siswa'] ?? $siswa_edit['nama']) ?>" readonly>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label class="form-label">NIS</label>
                                        <input type="text" class="form-control" value="<?= htmlspecialchars($siswa_edit['nis']) ?>" readonly>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label class="form-label">Kelas</label>
                                        <input type="text" class="form-control" value="<?= htmlspecialchars($siswa_edit['nama_kelas'] ?? $kegiatan_data['nama_kelas']) ?>" readonly>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Jenis Penilaian <span class="text-danger">*</span></label>
                                        <select class="form-select" name="jenis_penilaian" required>
                                            <option value="observasi" <?= ($siswa_edit['jenis'] ?? 'tugas_tertulis') == 'observasi' ? 'selected' : '' ?>>Observasi</option>
                                            <option value="tugas_tertulis" <?= ($siswa_edit['jenis'] ?? 'tugas_tertulis') == 'tugas_tertulis' ? 'selected' : '' ?>>Tugas Tertulis</option>
                                            <option value="projek" <?= ($siswa_edit['jenis'] ?? 'tugas_tertulis') == 'projek' ? 'selected' : '' ?>>Projek</option>
                                            <option value="portofolio" <?= ($siswa_edit['jenis'] ?? 'tugas_tertulis') == 'portofolio' ? 'selected' : '' ?>>Portofolio</option>
                                            <option value="praktik" <?= ($siswa_edit['jenis'] ?? 'tugas_tertulis') == 'praktik' ? 'selected' : '' ?>>Praktik</option>
                                            <option value="wawancara" <?= ($siswa_edit['jenis'] ?? 'tugas_tertulis') == 'wawancara' ? 'selected' : '' ?>>Wawancara</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Nilai <span class="text-danger">*</span></label>
                                        <input type="number" class="form-control" name="nilai" 
                                               value="<?= $siswa_edit['nilai'] ?? '' ?>" min="0" max="100" step="0.01" 
                                               placeholder="0-100" required>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Status</label>
                                        <input type="text" class="form-control" 
                                               value="<?= isset($siswa_edit['nilai']) ? 'Sudah Dinilai' : 'Belum Dinilai' ?>" 
                                               style="color: <?= isset($siswa_edit['nilai']) ? '#28a745' : '#dc3545' ?>; font-weight: bold;" 
                                               readonly>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label">Deskripsi / Catatan</label>
                                    <textarea class="form-control" name="deskripsi" rows="3" 
                                              placeholder="Catatan tentang penilaian siswa..."><?= htmlspecialchars($siswa_edit['deskripsi'] ?? '') ?></textarea>
                                </div>
                                
                                <div class="d-flex gap-2">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-check-circle"></i> Simpan Perubahan
                                    </button>
                                    <a href="?kegiatan_id=<?= $kegiatan_id ?>" class="btn btn-secondary">
                                        <i class="bi bi-x-circle"></i> Batal
                                    </a>
                                </div>
                            </form>
                        </div>
                    </div>

                <?php else: ?>
                    <!-- Bulk Input Form -->
                    <div class="card mb-4">
                        <div class="card-header bg-success text-white">
                            <h6 class="mb-0"><i class="bi bi-upload"></i> Input Nilai Massal</h6>
                        </div>
                        <div class="card-body">
                            <form method="POST" id="nilaiForm">
                                <input type="hidden" name="input_nilai" value="1">
                                <input type="hidden" name="tp_id" value="<?= $kegiatan_data['tp_id'] ?>">
                                <input type="hidden" name="jenis_penilaian" value="tugas_tertulis" id="jenisPenilaian">
                                
                                <div class="row mb-3">
                                    <div class="col-md-4">
                                        <label class="form-label">Jenis Penilaian untuk Semua Siswa</label>
                                        <select class="form-select" id="globalJenisPenilaian">
                                            <option value="tugas_tertulis">Tugas Tertulis</option>
                                            <option value="observasi">Observasi</option>
                                            <option value="projek">Projek</option>
                                            <option value="portofolio">Portofolio</option>
                                            <option value="praktik">Praktik</option>
                                            <option value="wawancara">Wawancara</option>
                                        </select>
                                    </div>
                                    <div class="col-md-8 d-flex align-items-end">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="selectAll">
                                            <label class="form-check-label" for="selectAll">
                                                Pilih Semua Siswa
                                            </label>
                                        </div>
                                    </div>
                                </div>


								
								<div class="table-responsive">
									<table class="table table-hover">
										<thead class="table-light">
											<tr>
												<th width="50">
													<input type="checkbox" id="checkAll">
												</th>
												<th>Nama Siswa</th>
												<th>NIS</th>
												<th width="120">Nilai</th>
												<th>Deskripsi</th>
												<th width="100">Status</th>
												<th width="100">Aksi</th>
											</tr>
										</thead>
										<tbody>
											<?php if (!empty($siswa_list)): ?>
												<?php foreach ($siswa_list as $siswa): ?>
													<?php
													$nilai_siswa = null;
													foreach ($nilai_list as $nilai) {
														if ($nilai['siswa_id'] == $siswa['id']) {
															$nilai_siswa = $nilai;
															break;
														}
													}
													?>
													<tr class="hover-row <?= $nilai_siswa ? 'table-success' : '' ?>">
														<td>
															<input type="checkbox" class="siswa-check" name="selected_siswa[]" value="<?= $siswa['id'] ?>" 
																   <?= $nilai_siswa ? 'checked' : '' ?>>
														</td>
														<td>
															<strong><?= htmlspecialchars($siswa['nama'] ?? $siswa['nama_siswa'] ?? 'N/A') ?></strong>
														</td>
														<td><?= htmlspecialchars($siswa['nis'] ?? 'N/A') ?></td>
														<td>
															<input type="number" class="form-control form-control-sm nilai-input" 
																   name="nilai[<?= $siswa['id'] ?>][nilai]" 
																   value="<?= $nilai_siswa['nilai'] ?? '' ?>" 
																   min="0" max="100" step="0.01" 
																   placeholder="0-100">
														</td>
														<td>
															<input type="text" class="form-control form-control-sm deskripsi-input" 
																   name="nilai[<?= $siswa['id'] ?>][deskripsi]" 
																   value="<?= htmlspecialchars($nilai_siswa['deskripsi'] ?? '') ?>" 
																   placeholder="Catatan...">
														</td>
														<td>
															<?php if ($nilai_siswa): ?>
																<span class="badge bg-success">Sudah</span>
															<?php else: ?>
																<span class="badge bg-warning">Belum</span>
															<?php endif; ?>
														</td>
														<td>
															<a href="?kegiatan_id=<?= $kegiatan_id ?>&action=edit&siswa_id=<?= $siswa['id'] ?>" 
															   class="btn btn-outline-primary btn-sm">
																<i class="bi bi-pencil"></i>
															</a>
														</td>
													</tr>
												<?php endforeach; ?>
											<?php else: ?>
												<tr>
													<td colspan="7" class="text-center py-4">
														<i class="bi bi-people fs-1 text-muted"></i>
														<p class="text-muted mt-2">Tidak ada siswa dalam kelas ini.</p>
														<?php if ($kegiatan_data): ?>
															<div class="debug-info small text-start text-muted mt-3">
																<strong>Debug Info:</strong><br>
																Kelas ID: <?= $kegiatan_data['kelas_id'] ?? 'NULL' ?><br>
																Kegiatan ID: <?= $kegiatan_id ?><br>
																Siswa List Count: <?= count($siswa_list) ?><br>
																Available Methods: 
																<?= method_exists($guruModel, 'getSiswaByKelasForNilai') ? 'getSiswaByKelasForNilai, ' : '' ?>
																<?= method_exists($guruModel, 'getSiswaByKelas') ? 'getSiswaByKelas, ' : '' ?>
																<?= method_exists($guruModel, 'getAllSiswa') ? 'getAllSiswa' : '' ?>
															</div>
														<?php endif; ?>
													</td>
												</tr>
											<?php endif; ?>
										</tbody>
									</table>
								</div>
								
								
                                
                                <?php if (!empty($siswa_list)): ?>
                                <div class="d-flex justify-content-between align-items-center mt-3">
                                    <div class="text-muted">
                                        <small>Terpilih: <span id="selectedCount">0</span> dari <?= count($siswa_list) ?> siswa</small>
                                    </div>
                                    <button type="submit" class="btn btn-success">
                                        <i class="bi bi-save"></i> Simpan Nilai Terpilih
                                    </button>
                                </div>
                                <?php endif; ?>
                            </form>
                        </div>
                    </div>

                    <!-- Nilai Summary -->
                    <?php if (!empty($nilai_list)): ?>
                    <div class="card">
                        <div class="card-header bg-info text-white">
                            <h6 class="mb-0"><i class="bi bi-graph-up"></i> Ringkasan Nilai</h6>
                        </div>
                        <div class="card-body">
                            <?php
                            $nilai_values = array_column($nilai_list, 'nilai');
                            $rata_rata = count($nilai_values) > 0 ? array_sum($nilai_values) / count($nilai_values) : 0;
                            $tertinggi = count($nilai_values) > 0 ? max($nilai_values) : 0;
                            $terendah = count($nilai_values) > 0 ? min($nilai_values) : 0;
                            ?>
                            <div class="row text-center">
                                <div class="col-md-3">
                                    <div class="card bg-light">
                                        <div class="card-body py-3">
                                            <div class="text-muted small">Rata-rata</div>
                                            <div class="h4 mb-0 text-primary"><?= number_format($rata_rata, 2) ?></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card bg-light">
                                        <div class="card-body py-3">
                                            <div class="text-muted small">Nilai Tertinggi</div>
                                            <div class="h4 mb-0 text-success"><?= number_format($tertinggi, 2) ?></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card bg-light">
                                        <div class="card-body py-3">
                                            <div class="text-muted small">Nilai Terendah</div>
                                            <div class="h4 mb-0 text-danger"><?= number_format($terendah, 2) ?></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card bg-light">
                                        <div class="card-body py-3">
                                            <div class="text-muted small">Siswa Dinilai</div>
                                            <div class="h4 mb-0 text-info"><?= count($nilai_list) ?> / <?= count($siswa_list) ?></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                <?php endif; ?>

            <?php else: ?>
                <!-- No Kegiatan Selected -->
                <div class="card">
                    <div class="card-body text-center py-5">
                        <i class="bi bi-exclamation-circle fs-1 text-warning mb-3"></i>
                        <h4>Kegiatan Tidak Ditemukan</h4>
                        <p class="text-muted">
                            Pilih kegiatan formatif terlebih dahulu untuk menginput nilai.
                        </p>
                        <a href="kegiatan_formatif.php" class="btn btn-primary">
                            <i class="bi bi-arrow-left"></i> Kembali ke Kegiatan Formatif
                        </a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Global jenis penilaian
            const globalJenisSelect = document.getElementById('globalJenisPenilaian');
            const jenisPenilaianInput = document.getElementById('jenisPenilaian');
            
            if (globalJenisSelect && jenisPenilaianInput) {
                globalJenisSelect.addEventListener('change', function() {
                    jenisPenilaianInput.value = this.value;
                });
                
                // Set initial value
                jenisPenilaianInput.value = globalJenisSelect.value;
            }
            
            // Select all functionality
            const checkAll = document.getElementById('checkAll');
            const selectAll = document.getElementById('selectAll');
            const siswaChecks = document.querySelectorAll('.siswa-check');
            const selectedCount = document.getElementById('selectedCount');
            
            function updateSelectedCount() {
                const checked = document.querySelectorAll('.siswa-check:checked').length;
                selectedCount.textContent = checked;
            }
            
            if (checkAll) {
                checkAll.addEventListener('change', function() {
                    siswaChecks.forEach(check => {
                        check.checked = this.checked;
                    });
                    updateSelectedCount();
                });
            }
            
            if (selectAll) {
                selectAll.addEventListener('change', function() {
                    siswaChecks.forEach(check => {
                        check.checked = this.checked;
                    });
                    updateSelectedCount();
                });
            }
            
            siswaChecks.forEach(check => {
                check.addEventListener('change', updateSelectedCount);
            });
            
            // Initial count
            updateSelectedCount();
            
            // Auto-hide alerts after 5 seconds
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(alert => {
                setTimeout(() => {
                    if (alert) {
                        const bsAlert = new bootstrap.Alert(alert);
                        bsAlert.close();
                    }
                }, 5000);
            });
            
            // Form submission confirmation
            const form = document.getElementById('nilaiForm');
            if (form) {
                form.addEventListener('submit', function(e) {
                    const checked = document.querySelectorAll('.siswa-check:checked').length;
                    if (checked === 0) {
                        e.preventDefault();
                        alert('Pilih setidaknya satu siswa untuk dinilai!');
                        return false;
                    }
                });
            }
        });
    </script>
</body>
</html>