<?php
require_once __DIR__ . '/../../app/config/config.php';
Session::checkAuth();
Session::checkRole(['guru']);

$guruModel = new GuruModel();
$userData = Session::getUserData();
$guruId = $userData['guru_id'];

// Get data
$tahunAktif = $guruModel->getActiveTahunAjaran();
$guruMapel = $guruModel->getGuruMapel($guruId);

// Get selected mapel and kelas
$selectedMapelId = $_GET['mapel_id'] ?? null;
$selectedKelasId = $_GET['kelas_id'] ?? null;

// Get siswa and TPs if mapel and kelas selected
$siswa = [];
$tps = [];
if ($selectedMapelId && $selectedKelasId) {
    $siswa = $guruModel->getSiswaByKelas($selectedKelasId);
    $tps = $guruModel->getTPByMapel($selectedMapelId);
    
    // Handle nilai submission
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['input_nilai'])) {
        $data = [
            'tp_id' => $_POST['tp_id'],
            'siswa_id' => $_POST['siswa_id'],
            'jenis' => $_POST['jenis'],
            'nilai' => $_POST['nilai'],
            'deskripsi' => $_POST['deskripsi'],
            'updated_by' => $userData['id']
        ];
        
        $result = $guruModel->inputNilaiFormatif($data);
        if ($result) {
            Session::setFlash('success', 'Nilai berhasil disimpan!');
        } else {
            Session::setFlash('error', 'Gagal menyimpan nilai!');
        }
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Input Nilai - Sistem Penilaian</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .navbar-brand { font-weight: 600; }
        .card { border-radius: 12px; border: none; box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05); }
        .card-header { border-radius: 12px 12px 0 0 !important; border-bottom: 1px solid rgba(0,0,0,0.05); font-weight: 600; }
        .btn { border-radius: 8px; font-weight: 500; transition: all 0.2s ease; }
        .fade-in { animation: fadeIn 0.5s ease-in; }
        @keyframes fadeIn { from { opacity: 0; transform: translateY(10px); } to { opacity: 1; transform: translateY(0); } }
    </style>
</head>
<body>
    <div class="container-fluid">
        <!-- Header -->
        <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
            <div class="container">
                <a class="navbar-brand" href="dashboard.php">
                    <i class="bi bi-arrow-left"></i> Input Nilai
                </a>
                <div class="navbar-nav ms-auto">
                    <span class="navbar-text me-3">
                        <i class="bi bi-person-circle"></i> <?= htmlspecialchars($userData['nama']) ?>
                    </span>
                    <a href="dashboard.php" class="btn btn-outline-light btn-sm me-2">
                        <i class="bi bi-house"></i> Dashboard
                    </a>
                    <a href="logout.php" class="btn btn-outline-light btn-sm">
                        <i class="bi bi-box-arrow-right"></i> Logout
                    </a>
                </div>
            </div>
        </nav>

        <div class="container mt-4 fade-in">
            <!-- Tahun Ajaran Info -->
            <?php if ($tahunAktif): ?>
            <div class="alert alert-primary-gradient d-flex justify-content-between align-items-center mb-4">
                <div class="d-flex align-items-center">
                    <div class="tahun-ajaran-icon me-3">
                        <i class="bi bi-calendar-check fs-2 text-white"></i>
                    </div>
                    <div>
                        <h6 class="alert-heading mb-1 text-white">
                            <i class="bi bi-star-fill me-2"></i>Tahun Ajaran Aktif
                        </h6>
                        <div class="d-flex align-items-center flex-wrap gap-2">
                            <span class="badge bg-white text-primary fs-6">
                                <i class="bi bi-calendar3 me-1"></i><?= $tahunAktif['tahun_ajaran'] ?>
                            </span>
                            <span class="badge bg-white bg-opacity-20 text-white fs-6">
                                <i class="bi bi-arrow-repeat me-1"></i>Semester <?= ucfirst($tahunAktif['semester']) ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <div class="row">
                <div class="col-lg-12">
                    <!-- Kelas dan Mapel Selector -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-white py-3">
                            <h6 class="m-0 font-weight-bold text-primary">
                                <i class="bi bi-journal-text me-2"></i>Pilih Kelas dan Mata Pelajaran
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <?php foreach ($guruMapel as $mapel): ?>
                                <div class="col-md-4 mb-3">
                                    <div class="card h-100 border-primary">
                                        <div class="card-body text-center">
                                            <h6 class="card-title"><?= $mapel['nama_mapel'] ?></h6>
                                            <p class="card-text text-muted small"><?= $mapel['nama_kelas'] ?></p>
                                            <p class="card-text">
                                                <span class="badge bg-primary"><?= $mapel['total_siswa'] ?> Siswa</span>
                                            </p>
                                            <div class="d-grid gap-2">
                                                <a href="nilai.php?mapel_id=<?= $mapel['mapel_id'] ?>&kelas_id=<?= $mapel['kelas_id'] ?>" 
                                                   class="btn btn-outline-primary btn-sm">
                                                    <i class="bi bi-pencil me-1"></i> Input Nilai
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Nilai Input Interface -->
                    <?php if ($selectedMapelId && $selectedKelasId): ?>
                    <div class="card shadow">
                        <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                            <h6 class="m-0 font-weight-bold text-primary">
                                <i class="bi bi-pencil me-2"></i>Input Nilai Formatif
                            </h6>
                            <div>
                                <span class="badge bg-primary me-2"><?= count($siswa) ?> Siswa</span>
                                <span class="badge bg-info"><?= count($tps) ?> TP</span>
                            </div>
                        </div>
                        <div class="card-body">
                            <?php if (!empty($siswa) && !empty($tps)): ?>
                                <!-- Form Input Nilai -->
                                <form method="POST" class="mb-4">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <label class="form-label">Siswa</label>
                                            <select name="siswa_id" class="form-select" required>
                                                <option value="">Pilih Siswa</option>
                                                <?php foreach ($siswa as $s): ?>
                                                <option value="<?= $s['id'] ?>"><?= $s['nama'] ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <label class="form-label">TP</label>
                                            <select name="tp_id" class="form-select" required>
                                                <option value="">Pilih TP</option>
                                                <?php foreach ($tps as $tp): ?>
                                                <option value="<?= $tp['id'] ?>"><?= $tp['kode_tp'] ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                        <div class="col-md-2">
                                            <label class="form-label">Jenis</label>
                                            <select name="jenis" class="form-select" required>
                                                <option value="formatif1">Formatif 1</option>
                                                <option value="formatif2">Formatif 2</option>
                                                <option value="formatif3">Formatif 3</option>
                                            </select>
                                        </div>
                                        <div class="col-md-2">
                                            <label class="form-label">Nilai</label>
                                            <input type="number" name="nilai" class="form-control" min="0" max="100" step="0.1" required>
                                        </div>
                                        <div class="col-md-2">
                                            <label class="form-label">&nbsp;</label>
                                            <button type="submit" name="input_nilai" class="btn btn-success w-100">
                                                <i class="bi bi-save"></i> Simpan
                                            </button>
                                        </div>
                                    </div>
                                    <div class="row mt-2">
                                        <div class="col-md-12">
                                            <label class="form-label">Deskripsi</label>
                                            <textarea name="deskripsi" class="form-control" rows="2" placeholder="Deskripsi nilai..."></textarea>
                                        </div>
                                    </div>
                                </form>
                                
                                <!-- Info -->
                                <div class="alert alert-info">
                                    <i class="bi bi-info-circle me-2"></i>
                                    Pilih siswa, TP, jenis penilaian, dan masukkan nilai formatif.
                                </div>
                            <?php else: ?>
                                <div class="text-center py-5">
                                    <i class="bi bi-exclamation-triangle fs-1 text-warning mb-3"></i>
                                    <h5 class="text-muted">Data tidak lengkap</h5>
                                    <p class="text-muted">Tidak ada siswa atau TP untuk kelas dan mapel yang dipilih</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>