<?php
// logout.php - versi corrected
// Coba beberapa kemungkinan path config.php

$possible_paths = [
    __DIR__ . '/app/config/config.php',           // Jika logout.php di root
    __DIR__ . '/../app/config/config.php',        // Jika logout.php di folder lain
    __DIR__ . '/../../app/config/config.php',     // Jika logout.php di subfolder
    'app/config/config.php',                      // Path relatif
    '../app/config/config.php',                   // Path relatif dari subfolder
];

$config_loaded = false;
foreach ($possible_paths as $path) {
    if (file_exists($path)) {
        require_once $path;
        $config_loaded = true;
        break;
    }
}

// Jika tidak ada config yang ditemukan, coba langsung include class Session
if (!$config_loaded) {
    // Coba include Session class langsung
    $session_paths = [
        __DIR__ . '/app/models/Session.php',
        __DIR__ . '/../app/models/Session.php', 
        __DIR__ . '/../../app/models/Session.php',
    ];
    
    foreach ($session_paths as $path) {
        if (file_exists($path)) {
            require_once $path;
            break;
        }
    }
    
    // Buat session object dan destroy
    $session = new Session();
    $session->destroy();
    
    // Redirect ke login (gunakan path default)
    header('Location: auth/login.php');
    exit();
}

// Jika config berhasil dimuat, lanjutkan dengan normal
$session = new Session();
$session->destroy();

// Gunakan BASE_URL jika ada, atau default path
if (defined('BASE_URL')) {
    header('Location: ' . BASE_URL . 'auth/login.php');
} else {
    header('Location: auth/login.php');
}
exit();
?>