<?php
require_once __DIR__ . '/../../app/config/config.php';
Session::checkAuth();
Session::checkRole(['guru']);

$guruModel = new GuruModel();
$userData = Session::getUserData();
$guruId = $userData['guru_id'];

// Get tp_id from URL
$tpId = isset($_GET['tp_id']) ? intval($_GET['tp_id']) : 0;

if ($tpId === 0) {
    die("TP ID tidak valid.");
}

// Get TP details
$tp = $guruModel->getTPById($tpId);
if (!$tp) {
    die("Tujuan Pembelajaran tidak ditemukan.");
}

// Validate access - guru must teach this mapel
$guruMapel = $guruModel->getGuruMapel($guruId);
$hasAccess = false;
foreach ($guruMapel as $mapel) {
    if ($mapel['mapel_id'] == $tp['mapel_id']) {
        $hasAccess = true;
        break;
    }
}

if (!$hasAccess) {
    die("Akses ditolak untuk TP ini.");
}

// Handle form actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'create_kegiatan':
                $data = [
                    'tp_id' => $tpId,
                    'guru_id' => $guruId,
                    'nama_kegiatan' => $_POST['nama_kegiatan'],
                    'jenis_kegiatan' => $_POST['jenis_kegiatan'],
                    'deskripsi' => $_POST['deskripsi'],
                    'bobot' => $_POST['bobot'],
                    'tanggal' => $_POST['tanggal']
                ];
                
                if ($guruModel->createKegiatanFormatif($data)) {
                    Session::setFlash('success', 'Kegiatan formatif berhasil ditambahkan.');
                } else {
                    Session::setFlash('error', 'Gagal menambahkan kegiatan formatif.');
                }
                break;
				
			// Tambahkan di bagian Handle form actions (setelah case 'create_kegiatan'):
			case 'update_kegiatan':
				$kegiatanId = intval($_POST['kegiatan_id']);
				$data = [
					'nama_kegiatan' => $_POST['nama_kegiatan'],
					'jenis_kegiatan' => $_POST['jenis_kegiatan'],
					'deskripsi' => $_POST['deskripsi'],
					'bobot' => $_POST['bobot'],
					'tanggal' => $_POST['tanggal'],
					'status' => $_POST['status']
				];
				
				if ($guruModel->updateKegiatanFormatif($kegiatanId, $data)) {
					Session::setFlash('success', 'Kegiatan formatif berhasil diperbarui.');
				} else {
					Session::setFlash('error', 'Gagal memperbarui kegiatan formatif.');
				}
				break;
				
			case 'delete_kegiatan':
				$kegiatanId = intval($_POST['kegiatan_id']);
				if ($guruModel->deleteKegiatanFormatif($kegiatanId)) {
					Session::setFlash('success', 'Kegiatan formatif berhasil dihapus.');
				} else {
					Session::setFlash('error', 'Gagal menghapus kegiatan formatif.');
				}
			break;
        }
        header("Location: kegiatan_formatif.php?tp_id=" . $tpId);
        exit();
    }
}

// Get kegiatan list for this TP
$kegiatanList = $guruModel->getKegiatanFormatifByTP($tpId);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kegiatan Formatif - Sistem Penilaian</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .navbar-brand {
            font-weight: 600;
        }
        
        .card {
            border-radius: 12px;
            border: none;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        }
        
        .card-header {
            border-radius: 12px 12px 0 0 !important;
            border-bottom: 1px solid rgba(0,0,0,0.05);
            font-weight: 600;
        }
        
        .btn {
            border-radius: 8px;
            font-weight: 500;
        }
        
        .kegiatan-item {
            border-left: 4px solid #28a745;
            background: white;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            transition: all 0.3s ease;
        }
        
        .kegiatan-item:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        
        .jenis-badge {
            font-size: 0.7rem;
            padding: 0.25em 0.6em;
        }
        
        .bobot-badge {
            background: #e9ecef;
            color: #495057;
            font-weight: 600;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <!-- Header -->
        <nav class="navbar navbar-expand-lg navbar-dark bg-success">
            <div class="container">
                <a class="navbar-brand" href="tp.php?mapel_id=<?= $tp['mapel_id'] ?>">
                    <i class="bi bi-arrow-left"></i> Kegiatan Formatif
                </a>
                <div class="navbar-nav ms-auto">
                    <span class="navbar-text me-3">
                        <i class="bi bi-person-circle"></i> <?= htmlspecialchars($userData['nama']) ?>
                    </span>
                    <a href="dashboard.php" class="btn btn-outline-light btn-sm">
                        <i class="bi bi-house"></i> Dashboard
                    </a>
                </div>
            </div>
        </nav>

        <div class="container mt-4">
            <!-- TP Info -->
            <div class="card shadow mb-4">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h5 class="text-success mb-1">
                                <i class="bi bi-bullseye"></i> <?= htmlspecialchars($tp['kode_tp']) ?>
                            </h5>
                            <p class="mb-0 text-muted"><?= htmlspecialchars($tp['deskripsi']) ?></p>
                            <small class="text-muted">
                                Mapel: <?= htmlspecialchars($tp['nama_mapel']) ?> - <?= htmlspecialchars($tp['kode_mapel']) ?>
                            </small>
                        </div>
                        <div class="col-md-4 text-end">
                            <a href="nilai_formatif.php?tp_id=<?= $tpId ?>" class="btn btn-primary">
                                <i class="bi bi-pencil-square"></i> Input Nilai
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Flash Messages -->
            <?php if (Session::hasFlash('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle-fill"></i> <?= Session::getFlash('success') ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>
            
            <?php if (Session::hasFlash('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="bi bi-exclamation-triangle-fill"></i> <?= Session::getFlash('error') ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="row">
                <div class="col-lg-4">
                    <!-- Add Kegiatan Form -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-white py-3">
                            <h6 class="m-0 font-weight-bold text-success">
                                <i class="bi bi-plus-circle"></i> Tambah Kegiatan Formatif
                            </h6>
                        </div>
                        <div class="card-body">
                            <form method="POST">
                                <input type="hidden" name="action" value="create_kegiatan">
                                
                                <div class="mb-3">
                                    <label for="nama_kegiatan" class="form-label">Nama Kegiatan</label>
                                    <input type="text" class="form-control" id="nama_kegiatan" name="nama_kegiatan" 
                                           placeholder="Contoh: Diskusi Kelompok Algoritma" required>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="jenis_kegiatan" class="form-label">Jenis Kegiatan</label>
                                    <select class="form-select" id="jenis_kegiatan" name="jenis_kegiatan" required>
                                        <option value="">Pilih Jenis Kegiatan</option>
                                        <option value="diskusi_kelas">Diskusi Kelas</option>
                                        <option value="diskusi_kelompok">Diskusi Kelompok</option>
                                        <option value="kuis_singkat">Kuis Singkat</option>
                                        <option value="presentasi">Presentasi</option>
                                        <option value="tugas_harian">Tugas Harian</option>
                                    </select>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="deskripsi" class="form-label">Deskripsi Kegiatan</label>
                                    <textarea class="form-control" id="deskripsi" name="deskripsi" 
                                              rows="3" placeholder="Deskripsi kegiatan..."></textarea>
                                </div>
                                
                                <div class="row">
                                    <div class="col-6">
                                        <div class="mb-3">
                                            <label for="bobot" class="form-label">Bobot (%)</label>
                                            <input type="number" class="form-control" id="bobot" name="bobot" 
                                                   min="0" max="100" step="0.01" required>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="mb-3">
                                            <label for="tanggal" class="form-label">Tanggal</label>
                                            <input type="date" class="form-control" id="tanggal" name="tanggal" 
                                                   value="<?= date('Y-m-d') ?>" required>
                                        </div>
                                    </div>
                                </div>
                                
                                <button type="submit" class="btn btn-success w-100">
                                    <i class="bi bi-save"></i> Simpan Kegiatan
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-lg-8">
                    <!-- Kegiatan List -->
                    <div class="card shadow">
                        <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                            <h6 class="m-0 font-weight-bold text-success">
                                <i class="bi bi-calendar-event"></i> Daftar Kegiatan Formatif
                            </h6>
                            <span class="badge bg-success"><?= count($kegiatanList) ?> Kegiatan</span>
                        </div>
                        <div class="card-body">
                            <?php if (!empty($kegiatanList)): ?>
                                <?php 
                                $totalBobot = 0;
                                foreach ($kegiatanList as $kegiatan):
                                    $totalBobot += $kegiatan['bobot'];
                                ?>
                                    <div class="kegiatan-item">
                                        <div class="d-flex justify-content-between align-items-start mb-2">
                                            <div class="flex-grow-1">
                                                <h6 class="mb-1"><?= htmlspecialchars($kegiatan['nama_kegiatan']) ?></h6>
                                                <p class="mb-2 text-muted small"><?= htmlspecialchars($kegiatan['deskripsi']) ?></p>
                                                
                                                <div class="d-flex gap-2 flex-wrap">
                                                    <span class="badge jenis-badge bg-primary">
                                                        <?= str_replace('_', ' ', ucfirst($kegiatan['jenis_kegiatan'])) ?>
                                                    </span>
                                                    <span class="badge jenis-badge bobot-badge">
                                                        Bobot: <?= $kegiatan['bobot'] ?>%
                                                    </span>
                                                    <span class="badge jenis-badge bg-secondary">
                                                        <?= date('d M Y', strtotime($kegiatan['tanggal'])) ?>
                                                    </span>
                                                    <span class="badge jenis-badge 
                                                        <?= $kegiatan['status'] === 'aktif' ? 'bg-success' : 'bg-warning' ?>">
                                                        <?= ucfirst($kegiatan['status']) ?>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="dropdown ms-2">
                                                <button class="btn btn-sm btn-outline-secondary dropdown-toggle" 
                                                        type="button" data-bs-toggle="dropdown">
                                                    <i class="bi bi-gear"></i>
                                                </button>
                                                <ul class="dropdown-menu">
                                                    <li>
                                                        <a class="dropdown-item" href="nilai_formatif.php?kegiatan_id=<?= $kegiatan['id'] ?>">
                                                            <i class="bi bi-pencil-square"></i> Input Nilai
                                                        </a>
                                                    </li>
                                                    <li><hr class="dropdown-divider"></li>
                                                    <li>
                                                        <a class="dropdown-item text-danger" href="#">
                                                            <i class="bi bi-trash"></i> Hapus
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                                
                                <!-- Total Bobot -->
                                <div class="mt-3 p-3 bg-light rounded">
                                    <div class="row text-center">
                                        <div class="col-6">
                                            <div class="h6 text-muted">Total Kegiatan</div>
                                            <div class="h4 text-primary"><?= count($kegiatanList) ?></div>
                                        </div>
                                        <div class="col-6">
                                            <div class="h6 text-muted">Total Bobot</div>
                                            <div class="h4 <?= $totalBobot == 100 ? 'text-success' : 'text-warning' ?>">
                                                <?= $totalBobot ?>%
                                            </div>
                                            <?php if ($totalBobot != 100): ?>
                                                <small class="text-warning">Total bobot harus 100%</small>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-5 text-muted">
                                    <i class="bi bi-calendar-event fs-1"></i>
                                    <h5>Belum ada Kegiatan Formatif</h5>
                                    <p>Tambahkan kegiatan pertama untuk TP ini.</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>