<?php
require_once __DIR__ . '/../../app/config/config.php';
Session::checkAuth();
Session::checkRole(['guru']);

$guruModel = new GuruModel();
$userData = Session::getUserData();
$guruId = $userData['guru_id'];

// Debug info
echo "<!-- DEBUG INFO -->";
echo "<!-- Guru ID: " . $guruId . " -->";
echo "<!-- User Data: " . print_r($userData, true) . " -->";

// Get parameters
$action = $_GET['action'] ?? 'list';
$tp_id = $_GET['tp_id'] ?? null;
$kegiatan_id = $_GET['id'] ?? null;

// Debug parameters
echo "<!-- Action: " . $action . " -->";
echo "<!-- TP ID: " . $tp_id . " -->";
echo "<!-- Kegiatan ID: " . $kegiatan_id . " -->";

// Process actions
$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    echo "<!-- POST Data: " . print_r($_POST, true) . " -->";
    
    try {
        if (isset($_POST['create_kegiatan'])) {
            $data = [
                'tp_id' => $_POST['tp_id'],
                'guru_id' => $guruId,
                'nama_kegiatan' => $_POST['nama_kegiatan'],
                'jenis_kegiatan' => $_POST['jenis_kegiatan'],
                'deskripsi' => $_POST['deskripsi'],
                'bobot' => $_POST['bobot'],
                'tanggal' => $_POST['tanggal']
            ];
            
            echo "<!-- Create Data: " . print_r($data, true) . " -->";
            
            if ($guruModel->createKegiatanFormatif($data)) {
                $message = 'Kegiatan formatif berhasil dibuat!';
                $message_type = 'success';
                // Redirect untuk menghindari resubmission
                header("Location: ?tp_id=" . $_POST['tp_id'] . "&message=" . urlencode($message) . "&message_type=" . $message_type);
                exit();
            } else {
                $message = 'Gagal membuat kegiatan formatif!';
                $message_type = 'danger';
            }
        }
        elseif (isset($_POST['update_kegiatan'])) {
            $kegiatan_id_to_update = $_POST['kegiatan_id'] ?? $kegiatan_id;
            
            $data = [
                'nama_kegiatan' => $_POST['nama_kegiatan'],
                'jenis_kegiatan' => $_POST['jenis_kegiatan'],
                'deskripsi' => $_POST['deskripsi'],
                'bobot' => $_POST['bobot'],
                'tanggal' => $_POST['tanggal'],
                'status' => $_POST['status']
            ];
            
            echo "<!-- Update Data: " . print_r($data, true) . " -->";
            echo "<!-- Kegiatan ID to Update: " . $kegiatan_id_to_update . " -->";
            
            if ($kegiatan_id_to_update && $guruModel->validateGuruKegiatanAccess($guruId, $kegiatan_id_to_update)) {
                if ($guruModel->updateKegiatanFormatif($kegiatan_id_to_update, $data)) {
                    $message = 'Kegiatan formatif berhasil diperbarui!';
                    $message_type = 'success';
                    // Redirect setelah update berhasil
                    header("Location: ?tp_id=" . $tp_id . "&message=" . urlencode($message) . "&message_type=" . $message_type);
                    exit();
                } else {
                    $message = 'Gagal memperbarui kegiatan formatif!';
                    $message_type = 'danger';
                }
            } else {
                $message = 'Anda tidak memiliki akses untuk mengubah kegiatan ini!';
                $message_type = 'danger';
            }
        }
        elseif (isset($_POST['delete_kegiatan'])) {
            $kegiatan_id_to_delete = $_POST['kegiatan_id'] ?? null;
            
            if ($kegiatan_id_to_delete && $guruModel->validateGuruKegiatanAccess($guruId, $kegiatan_id_to_delete)) {
                if ($guruModel->deleteKegiatanFormatif($kegiatan_id_to_delete)) {
                    $message = 'Kegiatan formatif berhasil dihapus!';
                    $message_type = 'success';
                    
                    // Redirect untuk menghindari resubmission
                    header("Location: ?tp_id=$tp_id&message=" . urlencode($message) . "&message_type=" . $message_type);
                    exit();
                } else {
                    $message = 'Gagal menghapus kegiatan formatif! Kegiatan mungkin sudah memiliki nilai.';
                    $message_type = 'danger';
                }
            } else {
                $message = 'Anda tidak memiliki akses untuk menghapus kegiatan ini!';
                $message_type = 'danger';
            }
        }
    } catch (Exception $e) {
        $message = 'Error: ' . $e->getMessage();
        $message_type = 'danger';
        echo "<!-- Exception: " . $e->getMessage() . " -->";
    }
}

// Check for message from redirect
if (isset($_GET['message']) && isset($_GET['message_type'])) {
    $message = $_GET['message'];
    $message_type = $_GET['message_type'];
}

// Get data based on action
$tp_data = null;
$kegiatan_data = null;
$kegiatan_list = [];
$guru_mapel = $guruModel->getGuruMapel($guruId);

echo "<!-- Guru Mapel Count: " . count($guru_mapel) . " -->";

if ($tp_id) {
    // Validate TP access
    if (!$guruModel->validateGuruTPAccess($guruId, $tp_id)) {
        $message = 'Anda tidak memiliki akses ke Tujuan Pembelajaran ini!';
        $message_type = 'danger';
        $tp_id = null;
    } else {
        $tp_data = $guruModel->getTPById($tp_id);
        $kegiatan_list = $guruModel->getKegiatanFormatifByTP($tp_id);
        
        echo "<!-- TP Data: " . print_r($tp_data, true) . " -->";
        echo "<!-- Kegiatan Count: " . count($kegiatan_list) . " -->";
    }
}

if ($kegiatan_id && $action === 'edit') {
    if ($guruModel->validateGuruKegiatanAccess($guruId, $kegiatan_id)) {
        $kegiatan_data = $guruModel->getKegiatanFormatifById($kegiatan_id);
        echo "<!-- Kegiatan Data: " . print_r($kegiatan_data, true) . " -->";
        
        // Jika tidak ada data kegiatan, redirect kembali
        if (!$kegiatan_data) {
            header("Location: ?tp_id=$tp_id&message=Kegiatan tidak ditemukan&message_type=danger");
            exit();
        }
    } else {
        $message = 'Anda tidak memiliki akses untuk mengedit kegiatan ini!';
        $message_type = 'danger';
        // Redirect jika tidak memiliki akses
        header("Location: ?tp_id=$tp_id&message=" . urlencode($message) . "&message_type=" . $message_type);
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kegiatan Formatif - Sistem Penilaian</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .navbar-brand {
            font-weight: 600;
        }
        
        .card {
            border-radius: 12px;
            border: none;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
        }
        
        .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
        }
        
        .card-header {
            border-radius: 12px 12px 0 0 !important;
            border-bottom: 1px solid rgba(0,0,0,0.05);
            font-weight: 600;
        }
        
        .btn {
            border-radius: 8px;
            font-weight: 500;
            transition: all 0.2s ease;
        }
        
        .table {
            border-radius: 10px;
            overflow: hidden;
        }
        
        .table thead th {
            background-color: #f8f9fa;
            border-bottom: 2px solid #dee2e6;
            font-weight: 600;
        }
        
        .badge {
            font-weight: 500;
        }
        
        .debug-panel {
            background: #f8f9fa;
            border-left: 4px solid #dc3545;
            padding: 10px;
            margin: 10px 0;
            border-radius: 4px;
            font-family: monospace;
            font-size: 12px;
        }
        
        /* Fix untuk modal flickering */
        .modal {
            background-color: rgba(0, 0, 0, 0.5);
            transition: opacity 0.15s linear;
        }
        
        .modal-backdrop {
            opacity: 0.5;
        }
        
        .modal.fade .modal-dialog {
            transform: translate(0, -50px);
            transition: transform 0.3s ease-out;
        }
        
        .modal.show .modal-dialog {
            transform: none;
        }
        
        /* Pastikan modal berada di atas elemen lain */
        .modal {
            z-index: 1060;
        }
        
        .modal-backdrop {
            z-index: 1050;
        }
        
        .btn-group .btn {
            border-radius: 6px;
        }
        
        .edit-form-container {
            background: white;
            border-radius: 12px;
            padding: 2rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <!-- Header -->
        <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
            <div class="container">
                <a class="navbar-brand" href="#">
                    <i class="bi bi-calendar-event"></i> Kegiatan Formatif
                </a>
                <div class="navbar-nav ms-auto">
                    <span class="navbar-text me-3">
                        <i class="bi bi-person-circle"></i> <?= htmlspecialchars($userData['nama']) ?>
                    </span>
                    <a href="dashboard.php" class="btn btn-outline-light btn-sm me-2">
                        <i class="bi bi-house"></i> Dashboard
                    </a>
                    <a href="logout.php" class="btn btn-outline-light btn-sm">
                        <i class="bi bi-box-arrow-right"></i> Logout
                    </a>
                </div>
            </div>
        </nav>

        <div class="container mt-4">
            <!-- Debug Panel (akan disembunyikan di production) -->
            <?php if (isset($_GET['debug'])): ?>
            <div class="debug-panel">
                <strong>Debug Information:</strong><br>
                Guru ID: <?= $guruId ?><br>
                Action: <?= $action ?><br>
                TP ID: <?= $tp_id ?><br>
                Kegiatan ID: <?= $kegiatan_id ?><br>
                Guru Mapel Count: <?= count($guru_mapel) ?><br>
                Kegiatan Count: <?= count($kegiatan_list) ?><br>
                TP Data: <?= print_r($tp_data, true) ?><br>
                Kegiatan Data: <?= print_r($kegiatan_data, true) ?><br>
            </div>
            <?php endif; ?>

            <!-- Messages -->
            <?php if ($message): ?>
            <div class="alert alert-<?= $message_type ?> alert-dismissible fade show" role="alert">
                <div class="d-flex align-items-center">
                    <i class="bi bi-<?= $message_type == 'success' ? 'check-circle' : 'exclamation-triangle' ?> me-2"></i>
                    <div><?= $message ?></div>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php endif; ?>

            <!-- Breadcrumb -->
            <nav aria-label="breadcrumb" class="mb-4">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="?">Kegiatan Formatif</a></li>
                    <?php if ($tp_data): ?>
                        <li class="breadcrumb-item active"><?= $tp_data['kode_tp'] ?></li>
                    <?php endif; ?>
                    <?php if ($action === 'edit' && $kegiatan_data): ?>
                        <li class="breadcrumb-item active">Edit Kegiatan</li>
                    <?php endif; ?>
                </ol>
            </nav>

            <div class="row">
                <!-- Sidebar - TP Selection -->
                <div class="col-lg-3 mb-4">
                    <div class="card">
                        <div class="card-header bg-white">
                            <h6 class="mb-0"><i class="bi bi-folder"></i> Tujuan Pembelajaran</h6>
                        </div>
                        <div class="card-body">
                            <?php if (!empty($guru_mapel)): ?>
                                <div class="list-group list-group-flush">
                                    <?php foreach ($guru_mapel as $mapel): ?>
                                        <?php
                                        $tp_list = $guruModel->getTPByMapel($mapel['mapel_id'], $mapel['kelas_id']);
                                        ?>
                                        <div class="mb-3">
                                            <small class="text-muted fw-bold"><?= $mapel['nama_mapel'] ?> - <?= $mapel['nama_kelas'] ?></small>
                                            <?php foreach ($tp_list as $tp): ?>
                                                <a href="?tp_id=<?= $tp['id'] ?>" 
                                                   class="list-group-item list-group-item-action <?= $tp_id == $tp['id'] ? 'active' : '' ?>">
                                                    <div class="d-flex w-100 justify-content-between">
                                                        <small><?= $tp['kode_tp'] ?></small>
                                                        <span class="badge bg-<?= $tp_id == $tp['id'] ? 'light text-dark' : 'primary' ?>">
                                                            <?= $tp['total_kegiatan'] ?>
                                                        </span>
                                                    </div>
                                                    <small class="text-<?= $tp_id == $tp['id'] ? 'light' : 'muted' ?>">
                                                        <?= substr($tp['deskripsi'], 0, 50) ?>...
                                                    </small>
                                                </a>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php else: ?>
                                <p class="text-muted text-center">Belum ada penugasan mengajar.</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Main Content -->
                <div class="col-lg-9">
                    <?php if ($tp_id && $tp_data && $action !== 'edit'): ?>
                        <!-- TP Header -->
                        <div class="card mb-4">
                            <div class="card-header bg-primary text-white">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h5 class="mb-0"><?= $tp_data['kode_tp'] ?></h5>
                                        <small><?= $tp_data['deskripsi'] ?></small>
                                    </div>
                                    <button class="btn btn-light btn-sm" data-bs-toggle="modal" data-bs-target="#createModal">
                                        <i class="bi bi-plus-circle"></i> Tambah Kegiatan
                                    </button>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-3">
                                        <small class="text-muted">Mata Pelajaran</small>
                                        <div class="fw-bold"><?= $tp_data['nama_mapel'] ?></div>
                                    </div>
                                    <div class="col-md-3">
                                        <small class="text-muted">Kelas</small>
                                        <div class="fw-bold"><?= $tp_data['nama_kelas'] ?></div>
                                    </div>
                                    <div class="col-md-3">
                                        <small class="text-muted">Status</small>
                                        <div>
                                            <span class="badge bg-<?= $tp_data['status'] == 'aktif' ? 'success' : 'secondary' ?>">
                                                <?= ucfirst($tp_data['status']) ?>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <small class="text-muted">Total Kegiatan</small>
                                        <div class="fw-bold"><?= $tp_data['total_kegiatan'] ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Kegiatan List -->
                        <div class="card">
                            <div class="card-header bg-white">
                                <h6 class="mb-0"><i class="bi bi-list-ul"></i> Daftar Kegiatan Formatif</h6>
                            </div>
                            <div class="card-body">
                                <?php if (!empty($kegiatan_list)): ?>
                                    <div class="table-responsive">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Nama Kegiatan</th>
                                                    <th>Jenis</th>
                                                    <th>Tanggal</th>
                                                    <th>Bobot</th>
                                                    <th>Status</th>
                                                    <th>Total Nilai</th>
                                                    <th>Aksi</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($kegiatan_list as $kegiatan): ?>
                                                <tr>
                                                    <td>
                                                        <strong><?= htmlspecialchars($kegiatan['nama_kegiatan']) ?></strong>
                                                        <?php if ($kegiatan['deskripsi']): ?>
                                                            <br><small class="text-muted"><?= substr(htmlspecialchars($kegiatan['deskripsi']), 0, 50) ?>...</small>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-info"><?= ucfirst(str_replace('_', ' ', $kegiatan['jenis_kegiatan'])) ?></span>
                                                    </td>
                                                    <td><?= date('d/m/Y', strtotime($kegiatan['tanggal'])) ?></td>
                                                    <td><?= $kegiatan['bobot'] ?>%</td>
                                                    <td>
                                                        <span class="badge bg-<?= $kegiatan['status'] == 'aktif' ? 'success' : ($kegiatan['status'] == 'selesai' ? 'primary' : 'secondary') ?>">
                                                            <?= ucfirst($kegiatan['status']) ?>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-primary"><?= $kegiatan['total_nilai'] ?> Nilai</span>
                                                    </td>
                                                    <td>
                                                        <div class="btn-group btn-group-sm">
                                                            <a href="?tp_id=<?= $tp_id ?>&id=<?= $kegiatan['id'] ?>&action=edit" 
                                                               class="btn btn-outline-primary">
                                                                <i class="bi bi-pencil"></i>
                                                            </a>
                                                            <a href="nilai_formatif.php?kegiatan_id=<?= $kegiatan['id'] ?>" 
                                                               class="btn btn-outline-success">
                                                                <i class="bi bi-pencil-square"></i>
                                                            </a>
                                                            <button type="button" class="btn btn-outline-danger" 
                                                                    data-bs-toggle="modal" 
                                                                    data-bs-target="#deleteModal<?= $kegiatan['id'] ?>">
                                                                <i class="bi bi-trash"></i>
                                                            </button>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                <?php else: ?>
                                    <div class="text-center py-4">
                                        <i class="bi bi-calendar-x fs-1 text-muted"></i>
                                        <p class="text-muted mt-2">Belum ada kegiatan formatif untuk TP ini.</p>
                                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createModal">
                                            <i class="bi bi-plus-circle"></i> Buat Kegiatan Pertama
                                        </button>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                    <?php elseif ($kegiatan_id && $action === 'edit' && $kegiatan_data): ?>
                        <!-- Edit Form -->
                        <div class="card">
                            <div class="card-header bg-primary text-white">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h5 class="mb-0"><i class="bi bi-pencil"></i> Edit Kegiatan Formatif</h5>
                                        <small><?= $tp_data['kode_tp'] ?> - <?= $tp_data['nama_mapel'] ?></small>
                                    </div>
                                    <a href="?tp_id=<?= $tp_id ?>" class="btn btn-light btn-sm">
                                        <i class="bi bi-arrow-left"></i> Kembali
                                    </a>
                                </div>
                            </div>
                            <div class="card-body">
                                <form method="POST">
                                    <input type="hidden" name="update_kegiatan" value="1">
                                    <input type="hidden" name="kegiatan_id" value="<?= $kegiatan_data['id'] ?>">
                                    
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Nama Kegiatan <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="nama_kegiatan" 
                                                   value="<?= htmlspecialchars($kegiatan_data['nama_kegiatan']) ?>" required>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Jenis Kegiatan <span class="text-danger">*</span></label>
                                            <select class="form-select" name="jenis_kegiatan" required>
                                                <option value="">Pilih Jenis</option>
                                                <option value="diskusi_kelas" <?= $kegiatan_data['jenis_kegiatan'] == 'diskusi_kelas' ? 'selected' : '' ?>>Diskusi Kelas</option>
                                                <option value="diskusi_kelompok" <?= $kegiatan_data['jenis_kegiatan'] == 'diskusi_kelompok' ? 'selected' : '' ?>>Diskusi Kelompok</option>
                                                <option value="kuis_singkat" <?= $kegiatan_data['jenis_kegiatan'] == 'kuis_singkat' ? 'selected' : '' ?>>Kuis Singkat</option>
                                                <option value="presentasi" <?= $kegiatan_data['jenis_kegiatan'] == 'presentasi' ? 'selected' : '' ?>>Presentasi</option>
                                                <option value="tugas_harian" <?= $kegiatan_data['jenis_kegiatan'] == 'tugas_harian' ? 'selected' : '' ?>>Tugas Harian</option>
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-4 mb-3">
                                            <label class="form-label">Tanggal <span class="text-danger">*</span></label>
                                            <input type="date" class="form-control" name="tanggal" 
                                                   value="<?= $kegiatan_data['tanggal'] ?>" required>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <label class="form-label">Bobot (%) <span class="text-danger">*</span></label>
                                            <input type="number" class="form-control" name="bobot" 
                                                   value="<?= $kegiatan_data['bobot'] ?>" min="0" max="100" step="0.01" required>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <label class="form-label">Status <span class="text-danger">*</span></label>
                                            <select class="form-select" name="status" required>
                                                <option value="draft" <?= $kegiatan_data['status'] == 'draft' ? 'selected' : '' ?>>Draft</option>
                                                <option value="aktif" <?= $kegiatan_data['status'] == 'aktif' ? 'selected' : '' ?>>Aktif</option>
                                                <option value="selesai" <?= $kegiatan_data['status'] == 'selesai' ? 'selected' : '' ?>>Selesai</option>
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">Deskripsi</label>
                                        <textarea class="form-control" name="deskripsi" rows="4" placeholder="Deskripsi kegiatan..."><?= htmlspecialchars($kegiatan_data['deskripsi']) ?></textarea>
                                    </div>
                                    
                                    <div class="d-flex gap-2">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="bi bi-check-circle"></i> Simpan Perubahan
                                        </button>
                                        <a href="?tp_id=<?= $tp_id ?>" class="btn btn-secondary">
                                            <i class="bi bi-x-circle"></i> Batal
                                        </a>
                                    </div>
                                </form>
                            </div>
                        </div>

                    <?php else: ?>
                        <!-- Welcome/Instruction Card -->
                        <div class="card">
                            <div class="card-body text-center py-5">
                                <i class="bi bi-calendar-event fs-1 text-primary mb-3"></i>
                                <h4>Kelola Kegiatan Formatif</h4>
                                <p class="text-muted">
                                    Pilih Tujuan Pembelajaran dari sidebar untuk melihat atau mengelola kegiatan formatif.
                                </p>
                                <div class="row mt-4">
                                    <div class="col-md-4 mb-3">
                                        <div class="card bg-light">
                                            <div class="card-body">
                                                <i class="bi bi-plus-circle fs-2 text-success"></i>
                                                <h6>Buat Kegiatan</h6>
                                                <small class="text-muted">Buat kegiatan formatif baru untuk TP yang dipilih</small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <div class="card bg-light">
                                            <div class="card-body">
                                                <i class="bi bi-pencil-square fs-2 text-warning"></i>
                                                <h6>Input Nilai</h6>
                                                <small class="text-muted">Input nilai siswa untuk setiap kegiatan</small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <div class="card bg-light">
                                            <div class="card-body">
                                                <i class="bi bi-graph-up fs-2 text-info"></i>
                                                <h6>Pantau Progress</h6>
                                                <small class="text-muted">Lihat progress penilaian formatif</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Create Modal -->
    <div class="modal fade" id="createModal" tabindex="-1" aria-labelledby="createModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="createModalLabel">Buat Kegiatan Formatif Baru</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form method="POST">
                    <input type="hidden" name="create_kegiatan" value="1">
                    <input type="hidden" name="tp_id" value="<?= $tp_id ?>">
                    
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Nama Kegiatan <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="nama_kegiatan" placeholder="Masukkan nama kegiatan" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Jenis Kegiatan <span class="text-danger">*</span></label>
                            <select class="form-select" name="jenis_kegiatan" required>
                                <option value="">Pilih Jenis Kegiatan</option>
                                <option value="diskusi_kelas">Diskusi Kelas</option>
                                <option value="diskusi_kelompok">Diskusi Kelompok</option>
                                <option value="kuis_singkat">Kuis Singkat</option>
                                <option value="presentasi">Presentasi</option>
                                <option value="tugas_harian">Tugas Harian</option>
                            </select>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Tanggal <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" name="tanggal" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Bobot (%) <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" name="bobot" min="0" max="100" step="0.01" placeholder="0.00" required>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Deskripsi</label>
                            <textarea class="form-control" name="deskripsi" rows="3" placeholder="Deskripsi kegiatan (opsional)"></textarea>
                        </div>
                    </div>
                    
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Delete Modals -->
    <?php if (!empty($kegiatan_list)): ?>
        <?php foreach ($kegiatan_list as $kegiatan): ?>
        <div class="modal fade" id="deleteModal<?= $kegiatan['id'] ?>" tabindex="-1" aria-labelledby="deleteModalLabel<?= $kegiatan['id'] ?>" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form method="POST">
                        <input type="hidden" name="delete_kegiatan" value="1">
                        <input type="hidden" name="kegiatan_id" value="<?= $kegiatan['id'] ?>">
                        
                        <div class="modal-header">
                            <h5 class="modal-title" id="deleteModalLabel<?= $kegiatan['id'] ?>">Hapus Kegiatan</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <p>Apakah Anda yakin ingin menghapus kegiatan "<strong><?= htmlspecialchars($kegiatan['nama_kegiatan']) ?></strong>"?</p>
                            <p class="text-danger small">
                                <i class="bi bi-exclamation-triangle"></i>
                                Kegiatan yang sudah memiliki nilai tidak dapat dihapus.
                            </p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                            <button type="submit" class="btn btn-danger">Hapus</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    <?php endif; ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Set today's date as default for date input in create modal
        document.addEventListener('DOMContentLoaded', function() {
            const today = new Date().toISOString().split('T')[0];
            const dateInput = document.querySelector('#createModal input[name="tanggal"]');
            if (dateInput) {
                dateInput.value = today;
            }
            
            // Fix untuk modal delete yang berkedip
            const deleteModals = document.querySelectorAll('.modal');
            deleteModals.forEach(modal => {
                modal.addEventListener('show.bs.modal', function (event) {
                    // Tambahkan class untuk mencegah flicker
                    this.style.display = 'block';
                    setTimeout(() => {
                        this.classList.add('show');
                    }, 150);
                });
                
                modal.addEventListener('hide.bs.modal', function (event) {
                    this.classList.remove('show');
                    setTimeout(() => {
                        this.style.display = 'none';
                    }, 150);
                });
            });
            
            // Auto-hide alerts after 5 seconds
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(alert => {
                setTimeout(() => {
                    if (alert) {
                        const bsAlert = new bootstrap.Alert(alert);
                        bsAlert.close();
                    }
                }, 5000);
            });
        });
    </script>
</body>
</html>