<?php
// Enable maximum error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/debug.log');

// Start output buffering to catch any early output
ob_start();

echo "<!-- DEBUG: Starting kegiatan.php -->\n";

try {
    echo "<!-- DEBUG: Before require config -->\n";
    require_once __DIR__ . '/../../app/config/config.php';
    echo "<!-- DEBUG: After require config -->\n";

    echo "<!-- DEBUG: Before Session::checkAuth() -->\n";
    Session::checkAuth();
    echo "<!-- DEBUG: After Session::checkAuth() -->\n";

    echo "<!-- DEBUG: Before Session::checkRole() -->\n";
    Session::checkRole(['guru']);
    echo "<!-- DEBUG: After Session::checkRole() -->\n";

    echo "<!-- DEBUG: Before GuruModel instantiation -->\n";
    $guruModel = new GuruModel();
    echo "<!-- DEBUG: After GuruModel instantiation -->\n";

    echo "<!-- DEBUG: Before Session::getUserData() -->\n";
    $userData = Session::getUserData();
    echo "<!-- DEBUG: After Session::getUserData() -->\n";
    
    if (!$userData) {
        throw new Exception("User data not found in session");
    }

    $guruId = $userData['guru_id'];
    echo "<!-- DEBUG: Guru ID: " . $guruId . " -->\n";

    // Get data
    echo "<!-- DEBUG: Before getActiveTahunAjaran() -->\n";
    $tahunAktif = $guruModel->getActiveTahunAjaran();
    echo "<!-- DEBUG: After getActiveTahunAjaran() -->\n";
    
    if (!$tahunAktif) {
        throw new Exception("Tahun ajaran aktif tidak ditemukan");
    }
    
    echo "<!-- DEBUG: Tahun Aktif: " . print_r($tahunAktif, true) . " -->\n";

    echo "<!-- DEBUG: Before getGuruMapel() -->\n";
    $guruMapel = $guruModel->getGuruMapel($guruId);
    echo "<!-- DEBUG: After getGuruMapel() -->\n";
    echo "<!-- DEBUG: Guru Mapel count: " . count($guruMapel) . " -->\n";

    // SOLUSI: Auto-select first mapel and kelas if none selected
    $selectedMapelId = $_GET['mapel_id'] ?? null;
    $selectedKelasId = $_GET['kelas_id'] ?? null;
    
    // Jika tidak ada mapel dan kelas yang dipilih, tapi guru punya mapel, pilih yang pertama
    if (!$selectedMapelId && !$selectedKelasId && !empty($guruMapel)) {
        $firstMapel = $guruMapel[0];
        $selectedMapelId = $firstMapel['mapel_id'];
        $selectedKelasId = $firstMapel['kelas_id'];
        
        // Redirect ke mapel dan kelas yang dipilih otomatis
        header("Location: kegiatan.php?mapel_id=$selectedMapelId&kelas_id=$selectedKelasId");
        exit();
    }
    
    echo "<!-- DEBUG: Selected Mapel: " . $selectedMapelId . ", Kelas: " . $selectedKelasId . " -->\n";

    // Get kegiatan data if mapel and kelas are selected
    $kegiatanData = [];
    $selectedMapelName = '';
    $selectedKelasName = '';

    if ($selectedMapelId && $selectedKelasId) {
        echo "<!-- DEBUG: Validating guru access -->\n";
        // Validate that guru has access to this mapel and kelas
        if ($guruModel->validateGuruMapelAccess($guruId, $selectedMapelId, $selectedKelasId)) {
            echo "<!-- DEBUG: Access validated, getting kegiatan data -->\n";
            $kegiatanData = $guruModel->getKegiatanByMapelKelas($selectedMapelId, $selectedKelasId, $tahunAktif['id']);
            echo "<!-- DEBUG: Kegiatan data count: " . count($kegiatanData) . " -->\n";
            
            // Get mapel and kelas names for display
            foreach ($guruMapel as $mapel) {
                if ($mapel['mapel_id'] == $selectedMapelId && $mapel['kelas_id'] == $selectedKelasId) {
                    $selectedMapelName = $mapel['nama_mapel'];
                    $selectedKelasName = $mapel['nama_kelas'];
                    break;
                }
            }
            echo "<!-- DEBUG: Selected Mapel Name: " . $selectedMapelName . " -->\n";
            echo "<!-- DEBUG: Selected Kelas Name: " . $selectedKelasName . " -->\n";
        } else {
            echo "<!-- DEBUG: Access denied, redirecting -->\n";
            Session::setFlash('error', 'Anda tidak memiliki akses ke mapel dan kelas yang dipilih');
            header("Location: kegiatan.php");
            exit();
        }
    }

    // Handle form submissions
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        echo "<!-- DEBUG: POST request detected -->\n";
        echo "<!-- DEBUG: POST data: " . print_r($_POST, true) . " -->\n";
        
        if (isset($_POST['add_kegiatan'])) {
            echo "<!-- DEBUG: Processing add_kegiatan -->\n";
            $data = [
                'mapel_id' => $selectedMapelId,
                'kelas_id' => $selectedKelasId,
                'tahun_ajaran_id' => $tahunAktif['id'],
                'nama_kegiatan' => $_POST['nama_kegiatan'],
                'deskripsi' => $_POST['deskripsi'],
                'tanggal_mulai' => $_POST['tanggal_mulai'],
                'tanggal_selesai' => $_POST['tanggal_selesai'],
                'bobot' => $_POST['bobot'],
                'status' => 'aktif'
            ];
            
            $result = $guruModel->addKegiatan($data);
            if ($result) {
                Session::setFlash('success', 'Kegiatan berhasil ditambahkan');
            } else {
                Session::setFlash('error', 'Gagal menambahkan kegiatan');
            }
            header("Location: kegiatan.php?mapel_id=$selectedMapelId&kelas_id=$selectedKelasId");
            exit();
        }
        
        if (isset($_POST['edit_kegiatan'])) {
            echo "<!-- DEBUG: Processing edit_kegiatan -->\n";
            $kegiatanId = $_POST['kegiatan_id'];
            $data = [
                'nama_kegiatan' => $_POST['nama_kegiatan'],
                'deskripsi' => $_POST['deskripsi'],
                'tanggal_mulai' => $_POST['tanggal_mulai'],
                'tanggal_selesai' => $_POST['tanggal_selesai'],
                'bobot' => $_POST['bobot'],
                'status' => $_POST['status']
            ];
            
            $result = $guruModel->updateKegiatan($kegiatanId, $data);
            if ($result) {
                Session::setFlash('success', 'Kegiatan berhasil diperbarui');
            } else {
                Session::setFlash('error', 'Gagal memperbarui kegiatan');
            }
            header("Location: kegiatan.php?mapel_id=$selectedMapelId&kelas_id=$selectedKelasId");
            exit();
        }
        
        if (isset($_POST['delete_kegiatan'])) {
            echo "<!-- DEBUG: Processing delete_kegiatan -->\n";
            $kegiatanId = $_POST['kegiatan_id'];
            $result = $guruModel->deleteKegiatan($kegiatanId);
            if ($result) {
                Session::setFlash('success', 'Kegiatan berhasil dihapus');
            } else {
                Session::setFlash('error', 'Gagal menghapus kegiatan');
            }
            header("Location: kegiatan.php?mapel_id=$selectedMapelId&kelas_id=$selectedKelasId");
            exit();
        }
    }

    echo "<!-- DEBUG: Reached HTML output section -->\n";

} catch (Exception $e) {
    echo "<!-- DEBUG: Exception caught: " . $e->getMessage() . " -->\n";
    echo "<!-- DEBUG: Exception in file: " . $e->getFile() . ":" . $e->getLine() . " -->\n";
    error_log("Exception in kegiatan.php: " . $e->getMessage() . " in " . $e->getFile() . ":" . $e->getLine());
    
    // Tampilkan error secara jelas di halaman
    echo "<div style='background: #f8d7da; color: #721c24; padding: 20px; margin: 10px; border: 1px solid #f5c6cb; border-radius: 5px;'>";
    echo "<h3>Error Terjadi:</h3>";
    echo "<p><strong>Pesan:</strong> " . htmlspecialchars($e->getMessage()) . "</p>";
    echo "<p><strong>File:</strong> " . $e->getFile() . ":" . $e->getLine() . "</p>";
    echo "<p><strong>Trace:</strong><pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre></p>";
    echo "</div>";
}

// Flush the output buffer to see debug comments
ob_end_flush();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kegiatan Formatif - Sistem Penilaian</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .navbar-brand { font-weight: 600; }
        .card { border-radius: 12px; border: none; box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05); }
        .card-header { border-radius: 12px 12px 0 0 !important; border-bottom: 1px solid rgba(0,0,0,0.05); font-weight: 600; }
        .btn { border-radius: 8px; font-weight: 500; transition: all 0.2s ease; }
        .fade-in { animation: fadeIn 0.5s ease-in; }
        @keyframes fadeIn { from { opacity: 0; transform: translateY(10px); } to { opacity: 1; transform: translateY(0); } }
        .status-badge { font-size: 0.75rem; }
        .kegiatan-item { transition: all 0.2s ease; border-left: 4px solid transparent; }
        .kegiatan-item:hover { border-left-color: #0d6efd; background-color: #f8f9fa; }
        .modal-header { background: linear-gradient(135deg, #0d6efd 0%, #0a58ca 100%); color: white; }
        .alert-primary-gradient {
            background: linear-gradient(135deg, #0d6efd 0%, #0a58ca 100%);
            color: white;
            border: none;
        }
        .debug-info {
            background: #f8f9fa;
            border-left: 4px solid #dc3545;
            padding: 10px;
            margin: 10px 0;
            font-family: monospace;
            font-size: 12px;
        }
        .selection-guide {
            background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%);
            border-left: 4px solid #2196f3;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <!-- Header -->
        <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
            <div class="container">
                <a class="navbar-brand" href="dashboard.php">
                    <i class="bi bi-arrow-left"></i> Kegiatan Formatif
                </a>
                <div class="navbar-nav ms-auto">
                    <span class="navbar-text me-3">
                        <i class="bi bi-person-circle"></i> 
                        <?php 
                        if (isset($userData['nama'])) {
                            echo htmlspecialchars($userData['nama']);
                        } else {
                            echo 'Unknown User';
                        }
                        ?>
                    </span>
                    <a href="dashboard.php" class="btn btn-outline-light btn-sm me-2">
                        <i class="bi bi-house"></i> Dashboard
                    </a>
                    <a href="logout.php" class="btn btn-outline-light btn-sm">
                        <i class="bi bi-box-arrow-right"></i> Logout
                    </a>
                </div>
            </div>
        </nav>

        <div class="container mt-4 fade-in">
            <!-- Debug Information Panel -->
            <div class="debug-info">
                <strong>Debug Information:</strong><br>
                Guru ID: <?= isset($guruId) ? $guruId : 'Not set' ?><br>
                Tahun Aktif: <?= isset($tahunAktif) ? $tahunAktif['tahun_ajaran'] : 'Not found' ?><br>
                Mapel Count: <?= isset($guruMapel) ? count($guruMapel) : 0 ?><br>
                Selected Mapel: <?= $selectedMapelId ? $selectedMapelId : 'None' ?><br>
                Selected Kelas: <?= $selectedKelasId ? $selectedKelasId : 'None' ?><br>
                Kegiatan Count: <?= isset($kegiatanData) ? count($kegiatanData) : 0 ?><br>
            </div>

            <!-- Flash Messages -->
            <?php 
            if (class_exists('Session') && method_exists('Session', 'hasFlash')) {
                if (Session::hasFlash('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle-fill me-2"></i><?= Session::getFlash('success') ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <?php if (Session::hasFlash('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="bi bi-exclamation-triangle-fill me-2"></i><?= Session::getFlash('error') ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif;
            } ?>

            <!-- Tahun Ajaran Info -->
            <?php if (isset($tahunAktif) && $tahunAktif): ?>
            <div class="alert alert-primary-gradient d-flex justify-content-between align-items-center mb-4">
                <div class="d-flex align-items-center">
                    <div class="tahun-ajaran-icon me-3">
                        <i class="bi bi-calendar-check fs-2 text-white"></i>
                    </div>
                    <div>
                        <h6 class="alert-heading mb-1 text-white">
                            <i class="bi bi-star-fill me-2"></i>Tahun Ajaran Aktif
                        </h6>
                        <div class="d-flex align-items-center flex-wrap gap-2">
                            <span class="badge bg-white text-primary fs-6">
                                <i class="bi bi-calendar3 me-1"></i><?= $tahunAktif['tahun_ajaran'] ?>
                            </span>
                            <span class="badge bg-white bg-opacity-20 text-white fs-6">
                                <i class="bi bi-arrow-repeat me-1"></i>Semester <?= ucfirst($tahunAktif['semester']) ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <?php else: ?>
                <div class="alert alert-warning">
                    <i class="bi bi-exclamation-triangle me-2"></i>Tahun ajaran aktif tidak ditemukan!
                </div>
            <?php endif; ?>

            <div class="row">
                <div class="col-lg-12">
                    <!-- Kelas dan Mapel Selector -->
                    <div class="card shadow mb-4">
                        <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                            <h6 class="m-0 font-weight-bold text-primary">
                                <i class="bi bi-journal-text me-2"></i>Pilih Kelas dan Mata Pelajaran
                            </h6>
                            <?php if ($selectedMapelId && $selectedKelasId && isset($selectedMapelName) && isset($selectedKelasName)): ?>
                                <span class="badge bg-primary">
                                    <i class="bi bi-check-circle me-1"></i>
                                    <?= htmlspecialchars($selectedMapelName) ?> - <?= htmlspecialchars($selectedKelasName) ?>
                                </span>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <?php if (!isset($guruMapel) || empty($guruMapel)): ?>
                                <div class="alert alert-warning text-center">
                                    <i class="bi bi-exclamation-triangle me-2"></i>
                                    Tidak ada mata pelajaran yang diampu. Silakan hubungi administrator.
                                </div>
                            <?php else: ?>
                                <!-- Selection Guide -->
                                <?php if (!$selectedMapelId || !$selectedKelasId): ?>
                                <div class="alert selection-guide mb-4">
                                    <div class="d-flex align-items-center">
                                        <i class="bi bi-info-circle-fill text-primary fs-4 me-3"></i>
                                        <div>
                                            <h6 class="alert-heading mb-1 text-primary">Pilih Mata Pelajaran</h6>
                                            <p class="mb-0">Klik pada salah satu kartu di bawah untuk memulai mengelola kegiatan formatif. Sistem akan otomatis memilih mapel pertama untuk Anda.</p>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <div class="row">
                                    <?php foreach ($guruMapel as $index => $mapel): ?>
                                    <div class="col-md-4 mb-3">
                                        <div class="card h-100 border-primary <?= ($selectedMapelId == $mapel['mapel_id'] && $selectedKelasId == $mapel['kelas_id']) ? 'bg-primary text-white' : '' ?>">
                                            <div class="card-body text-center">
                                                <h6 class="card-title"><?= htmlspecialchars($mapel['nama_mapel']) ?></h6>
                                                <p class="card-text <?= ($selectedMapelId == $mapel['mapel_id'] && $selectedKelasId == $mapel['kelas_id']) ? 'text-white' : 'text-muted' ?> small">
                                                    <?= htmlspecialchars($mapel['nama_kelas']) ?> (<?= $mapel['total_siswa'] ?? 0 ?> siswa)
                                                </p>
                                                <div class="d-grid gap-2">
                                                    <a href="kegiatan.php?mapel_id=<?= $mapel['mapel_id'] ?>&kelas_id=<?= $mapel['kelas_id'] ?>" 
                                                       class="btn <?= ($selectedMapelId == $mapel['mapel_id'] && $selectedKelasId == $mapel['kelas_id']) ? 'btn-light' : 'btn-outline-primary' ?> btn-sm">
                                                        <i class="bi bi-calendar-event me-1"></i> 
                                                        <?= ($selectedMapelId == $mapel['mapel_id'] && $selectedKelasId == $mapel['kelas_id']) ? 'Sedang Dipilih' : 'Kelola Kegiatan' ?>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Kegiatan Management -->
                    <?php if ($selectedMapelId && $selectedKelasId && isset($selectedMapelName) && isset($selectedKelasName)): ?>
                    <div class="card shadow">
                        <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                            <h6 class="m-0 font-weight-bold text-primary">
                                <i class="bi bi-calendar-event me-2"></i>Manajemen Kegiatan Formatif
                                <small class="text-muted ms-2"><?= htmlspecialchars($selectedMapelName) ?> - <?= htmlspecialchars($selectedKelasName) ?></small>
                            </h6>
                            <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addKegiatanModal">
                                <i class="bi bi-plus-circle me-1"></i> Tambah Kegiatan
                            </button>
                        </div>
                        <div class="card-body">
                            <?php if (!isset($kegiatanData) || empty($kegiatanData)): ?>
                                <div class="text-center py-5">
                                    <i class="bi bi-calendar-event fs-1 text-muted mb-3"></i>
                                    <h5 class="text-muted">Belum ada kegiatan formatif</h5>
                                    <p class="text-muted">Mulai dengan menambahkan kegiatan formatif pertama Anda</p>
                                    <button class="btn btn-primary mt-2" data-bs-toggle="modal" data-bs-target="#addKegiatanModal">
                                        <i class="bi bi-plus-circle me-1"></i> Tambah Kegiatan Pertama
                                    </button>
                                </div>
                            <?php else: ?>
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>Nama Kegiatan</th>
                                                <th>Deskripsi</th>
                                                <th>Tanggal Mulai</th>
                                                <th>Tanggal Selesai</th>
                                                <th>Bobot</th>
                                                <th>Status</th>
                                                <th>Aksi</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($kegiatanData as $kegiatan): ?>
                                            <tr class="kegiatan-item">
                                                <td>
                                                    <strong><?= htmlspecialchars($kegiatan['nama_kegiatan']) ?></strong>
                                                </td>
                                                <td><?= htmlspecialchars($kegiatan['deskripsi']) ?></td>
                                                <td><?= date('d/m/Y', strtotime($kegiatan['tanggal_mulai'])) ?></td>
                                                <td><?= date('d/m/Y', strtotime($kegiatan['tanggal_selesai'])) ?></td>
                                                <td>
                                                    <span class="badge bg-info"><?= $kegiatan['bobot'] ?>%</span>
                                                </td>
                                                <td>
                                                    <span class="badge <?= $kegiatan['status'] == 'aktif' ? 'bg-success' : 'bg-secondary' ?> status-badge">
                                                        <?= ucfirst($kegiatan['status']) ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <div class="btn-group btn-group-sm">
                                                        <button class="btn btn-outline-primary" 
                                                                data-bs-toggle="modal" 
                                                                data-bs-target="#editKegiatanModal"
                                                                data-kegiatan-id="<?= $kegiatan['id'] ?>"
                                                                data-nama-kegiatan="<?= htmlspecialchars($kegiatan['nama_kegiatan']) ?>"
                                                                data-deskripsi="<?= htmlspecialchars($kegiatan['deskripsi']) ?>"
                                                                data-tanggal-mulai="<?= $kegiatan['tanggal_mulai'] ?>"
                                                                data-tanggal-selesai="<?= $kegiatan['tanggal_selesai'] ?>"
                                                                data-bobot="<?= $kegiatan['bobot'] ?>"
                                                                data-status="<?= $kegiatan['status'] ?>">
                                                            <i class="bi bi-pencil"></i>
                                                        </button>
                                                        <button class="btn btn-outline-danger" 
                                                                data-bs-toggle="modal" 
                                                                data-bs-target="#deleteKegiatanModal"
                                                                data-kegiatan-id="<?= $kegiatan['id'] ?>"
                                                                data-nama-kegiatan="<?= htmlspecialchars($kegiatan['nama_kegiatan']) ?>">
                                                            <i class="bi bi-trash"></i>
                                                        </button>
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                                
                                <!-- Bobot Total -->
                                <?php 
                                $totalBobot = array_sum(array_column($kegiatanData, 'bobot'));
                                $bobotClass = $totalBobot == 100 ? 'bg-success' : ($totalBobot > 100 ? 'bg-danger' : 'bg-warning');
                                ?>
                                <div class="mt-3 p-3 bg-light rounded">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="fw-bold">Total Bobot:</span>
                                        <span class="badge <?= $bobotClass ?> fs-6">
                                            <?= $totalBobot ?>%
                                            <?php if ($totalBobot != 100): ?>
                                                <small class="ms-1">
                                                    <?php if ($totalBobot < 100): ?>
                                                        (Kurang <?= 100 - $totalBobot ?>%)
                                                    <?php else: ?>
                                                        (Lebih <?= $totalBobot - 100 ?>%)
                                                    <?php endif; ?>
                                                </small>
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                    <?php if ($totalBobot != 100): ?>
                                        <div class="alert alert-warning mt-2 mb-0 py-2">
                                            <small>
                                                <i class="bi bi-exclamation-triangle me-1"></i>
                                                Total bobot harus tepat 100%. Saat ini total bobot adalah <?= $totalBobot ?>%.
                                            </small>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php else: ?>
                        <!-- Guidance when no mapel is selected -->
                        <div class="card shadow">
                            <div class="card-body text-center py-5">
                                <i class="bi bi-mouse fs-1 text-primary mb-3"></i>
                                <h5 class="text-primary">Pilih Mata Pelajaran dan Kelas</h5>
                                <p class="text-muted">Klik pada salah satu kartu mata pelajaran di atas untuk mulai mengelola kegiatan formatif</p>
                                <div class="mt-3">
                                    <small class="text-muted">
                                        <i class="bi bi-lightbulb me-1"></i>
                                        Tips: Sistem akan otomatis memilih mapel pertama untuk memudahkan Anda
                                    </small>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal structures remain the same -->
    <!-- Add Kegiatan Modal -->
    <div class="modal fade" id="addKegiatanModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="bi bi-plus-circle me-2"></i>Tambah Kegiatan Formatif</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <form method="POST">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="nama_kegiatan" class="form-label">Nama Kegiatan</label>
                            <input type="text" class="form-control" id="nama_kegiatan" name="nama_kegiatan" required>
                        </div>
                        <div class="mb-3">
                            <label for="deskripsi" class="form-label">Deskripsi</label>
                            <textarea class="form-control" id="deskripsi" name="deskripsi" rows="3"></textarea>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="tanggal_mulai" class="form-label">Tanggal Mulai</label>
                                    <input type="date" class="form-control" id="tanggal_mulai" name="tanggal_mulai" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="tanggal_selesai" class="form-label">Tanggal Selesai</label>
                                    <input type="date" class="form-control" id="tanggal_selesai" name="tanggal_selesai" required>
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="bobot" class="form-label">Bobot (%)</label>
                            <input type="number" class="form-control" id="bobot" name="bobot" min="1" max="100" required>
                            <div class="form-text">Bobot harus antara 1-100%</div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" name="add_kegiatan" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Kegiatan Modal -->
    <div class="modal fade" id="editKegiatanModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="bi bi-pencil me-2"></i>Edit Kegiatan Formatif</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <form method="POST">
                    <input type="hidden" id="edit_kegiatan_id" name="kegiatan_id">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="edit_nama_kegiatan" class="form-label">Nama Kegiatan</label>
                            <input type="text" class="form-control" id="edit_nama_kegiatan" name="nama_kegiatan" required>
                        </div>
                        <div class="mb-3">
                            <label for="edit_deskripsi" class="form-label">Deskripsi</label>
                            <textarea class="form-control" id="edit_deskripsi" name="deskripsi" rows="3"></textarea>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="edit_tanggal_mulai" class="form-label">Tanggal Mulai</label>
                                    <input type="date" class="form-control" id="edit_tanggal_mulai" name="tanggal_mulai" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="edit_tanggal_selesai" class="form-label">Tanggal Selesai</label>
                                    <input type="date" class="form-control" id="edit_tanggal_selesai" name="tanggal_selesai" required>
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="edit_bobot" class="form-label">Bobot (%)</label>
                            <input type="number" class="form-control" id="edit_bobot" name="bobot" min="1" max="100" required>
                        </div>
                        <div class="mb-3">
                            <label for="edit_status" class="form-label">Status</label>
                            <select class="form-select" id="edit_status" name="status" required>
                                <option value="aktif">Aktif</option>
                                <option value="nonaktif">Nonaktif</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" name="edit_kegiatan" class="btn btn-primary">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Delete Kegiatan Modal -->
    <div class="modal fade" id="deleteKegiatanModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="bi bi-exclamation-triangle me-2"></i>Konfirmasi Hapus</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <form method="POST">
                    <input type="hidden" id="delete_kegiatan_id" name="kegiatan_id">
                    <div class="modal-body">
                        <p>Apakah Anda yakin ingin menghapus kegiatan formatif <strong id="delete_nama_kegiatan"></strong>?</p>
                        <p class="text-danger"><small>Tindakan ini tidak dapat dibatalkan.</small></p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" name="delete_kegiatan" class="btn btn-danger">Hapus</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        console.log('DEBUG: JavaScript loaded successfully');

        // Edit Modal Handler
        const editKegiatanModal = document.getElementById('editKegiatanModal');
        if (editKegiatanModal) {
            editKegiatanModal.addEventListener('show.bs.modal', function(event) {
                const button = event.relatedTarget;
                console.log('DEBUG: Edit modal opened for kegiatan:', button.getAttribute('data-kegiatan-id'));
                
                document.getElementById('edit_kegiatan_id').value = button.getAttribute('data-kegiatan-id');
                document.getElementById('edit_nama_kegiatan').value = button.getAttribute('data-nama-kegiatan');
                document.getElementById('edit_deskripsi').value = button.getAttribute('data-deskripsi');
                document.getElementById('edit_tanggal_mulai').value = button.getAttribute('data-tanggal-mulai');
                document.getElementById('edit_tanggal_selesai').value = button.getAttribute('data-tanggal-selesai');
                document.getElementById('edit_bobot').value = button.getAttribute('data-bobot');
                document.getElementById('edit_status').value = button.getAttribute('data-status');
            });
        }

        // Delete Modal Handler
        const deleteKegiatanModal = document.getElementById('deleteKegiatanModal');
        if (deleteKegiatanModal) {
            deleteKegiatanModal.addEventListener('show.bs.modal', function(event) {
                const button = event.relatedTarget;
                console.log('DEBUG: Delete modal opened for kegiatan:', button.getAttribute('data-kegiatan-id'));
                
                document.getElementById('delete_kegiatan_id').value = button.getAttribute('data-kegiatan-id');
                document.getElementById('delete_nama_kegiatan').textContent = button.getAttribute('data-nama-kegiatan');
            });
        }

        // Date validation
        const tanggalMulai = document.getElementById('tanggal_mulai');
        const tanggalSelesai = document.getElementById('tanggal_selesai');
        
        if (tanggalMulai && tanggalSelesai) {
            tanggalMulai.addEventListener('change', function() {
                if (tanggalSelesai.value && this.value > tanggalSelesai.value) {
                    tanggalSelesai.value = this.value;
                }
            });
            
            tanggalSelesai.addEventListener('change', function() {
                if (tanggalMulai.value && this.value < tanggalMulai.value) {
                    this.value = tanggalMulai.value;
                }
            });
        }
    </script>
</body>
</html>