<?php
require_once __DIR__ . '/../../app/config/config.php';
Session::checkAuth();
Session::checkRole(['guru']);

$guruModel = new GuruModel();
$userData = Session::getUserData();
$guruId = $userData['guru_id'];

// Get data for dashboard
$stats = $guruModel->getDashboardStats($guruId);
$tahunAktif = $guruModel->getActiveTahunAjaran();
$guruMapel = $guruModel->getGuruMapel($guruId);
$waliKelas = $guruModel->getWaliKelasByGuru($guruId);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Guru - Sistem Penilaian</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .navbar-brand {
            font-weight: 600;
        }
        
        .stat-card {
            border-radius: 12px;
            border: none;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
            overflow: hidden;
            position: relative;
        }
        
        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 4px;
        }
		
		/* Animasi tambahan */
		.stat-card .col-auto div {
			transition: transform 0.3s ease;
		}

		.stat-card:hover .col-auto div {
			transform: scale(1.1);
		}

		.alert-teal-gradient {
			animation: slideInUp 0.5s ease-out;
		}

		@keyframes slideInUp {
			from {
				opacity: 0;
				transform: translateY(20px);
			}
			to {
				opacity: 1;
				transform: translateY(0);
			}
		}
        
        .stat-card.primary::before { background: linear-gradient(90deg, #007bff, #5dade2); }
        .stat-card.success::before { background: linear-gradient(90deg, #28a745, #58d68d); }
        .stat-card.info::before { background: linear-gradient(90deg, #17a2b8, #48c9b0); }
        .stat-card.warning::before { background: linear-gradient(90deg, #ffc107, #f7dc6f); }
        /* Gradien untuk kartu statistik */
		.stat-card.primary {
			background: linear-gradient(135deg, #ffffff 0%, #f0f8ff 100%);
			border-left: 4px solid #007bff;
		}

		.stat-card.success {
			background: linear-gradient(135deg, #ffffff 0%, #f0fff4 100%);
			border-left: 4px solid #28a745;
		}

		.stat-card.info {
			background: linear-gradient(135deg, #ffffff 0%, #f0fdff 100%);
			border-left: 4px solid #17a2b8;
		}

		.stat-card.warning {
			background: linear-gradient(135deg, #ffffff 0%, #fffaf0 100%);
			border-left: 4px solid #ffc107;
		}
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.15);
        }
        
        .stat-card .card-body {
            padding: 1.5rem;
        }
        
        .stat-card .text-xs {
            font-size: 0.8rem;
            font-weight: 600;
            letter-spacing: 0.5px;
        }
        
        .stat-card .h5 {
            font-size: 1.8rem;
            font-weight: 700;
            margin-top: 0.5rem;
        }
        
        .stat-card .col-auto i {
            font-size: 2.5rem;
            opacity: 0.7;
        }
        
        .quick-action-card {
            transition: all 0.3s ease;
            border-radius: 10px;
            border: none;
            box-shadow: 0 3px 5px rgba(0,0,0,0.08);
            background: white;
        }
        
        .quick-action-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 15px rgba(0,0,0,0.1);
        }
        
        .card {
            border-radius: 12px;
            border: none;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        }
        
        .card-header {
            border-radius: 12px 12px 0 0 !important;
            border-bottom: 1px solid rgba(0,0,0,0.05);
            font-weight: 600;
        }
        
        .alert {
            border-radius: 10px;
            border: none;
            box-shadow: 0 3px 5px rgba(0,0,0,0.05);
        }
		
		/* Alert Wali Kelas dengan gradien */
		.alert-teal-gradient {
			background: linear-gradient(135deg, #20c997 0%, #17a2b8 100%);
			border: none;
			border-radius: 12px;
			color: white;
			padding: 1.5rem;
			box-shadow: 0 4px 15px rgba(32, 201, 151, 0.3);
		}

		.wali-kelas-icon {
			background: rgba(255, 255, 255, 0.2);
			border-radius: 50%;
			width: 60px;
			height: 60px;
			display: flex;
			align-items: center;
			justify-content: center;
			backdrop-filter: blur(10px);
		}
        
        .table {
            border-radius: 10px;
            overflow: hidden;
        }
        
        .table thead th {
            background-color: #f8f9fa;
            border-bottom: 2px solid #dee2e6;
            font-weight: 600;
        }
        
        .btn {
            border-radius: 8px;
            font-weight: 500;
            transition: all 0.2s ease;
        }
        
        .btn-group .btn {
            border-radius: 6px;
        }
        
        .navbar {
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        
        .container.mt-4 {
            padding-bottom: 2rem;
        }
        
        .text-teal { color: #20c997; }
        .bg-teal { background-color: #20c997; }
        .btn-teal { 
            background-color: #20c997; 
            border-color: #20c997;
            color: white;
        }
        .btn-teal:hover {
            background-color: #199d7a;
            border-color: #199d7a;
        }
        .btn-outline-teal {
            color: #20c997;
            border-color: #20c997;
        }
        .btn-outline-teal:hover {
            background-color: #20c997;
            border-color: #20c997;
            color: white;
        }
        .alert-teal {
            background-color: #d1f2eb;
            border-color: #20c997;
            color: #0c5460;
        }
		
		/* Badge dalam alert */
		.alert-teal-gradient .badge.bg-white {
			color: #20c997 !important;
			font-weight: 600;
			padding: 0.5rem 1rem;
		}

		.alert-teal-gradient .badge.bg-white.bg-opacity-20 {
			background-color: rgba(255, 255, 255, 0.2) !important;
			color: white !important;
			backdrop-filter: blur(10px);
		}


		/* Tombol dengan efek hover */
		.btn-teal-hover {
			background: white;
			color: #20c997;
			border: 2px solid white;
			font-weight: 600;
			transition: all 0.3s ease;
		}

		.btn-teal-hover:hover {
			background: transparent;
			color: white;
			border: 2px solid white;
			transform: translateY(-2px);
		}
        
        /* Animasi untuk konten yang dimuat */
        .fade-in {
            animation: fadeIn 0.5s ease-in;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        /* Efek hover untuk baris tabel */
        .table-hover tbody tr {
            transition: all 0.2s ease;
        }
        
        .table-hover tbody tr:hover {
            background-color: rgba(0, 123, 255, 0.05);
            transform: scale(1.005);
        }
		
		/* Ikon dengan background bulat */
		.bg-primary.bg-opacity-10 {
			background-color: rgba(0, 123, 255, 0.1) !important;
		}

		.bg-success.bg-opacity-10 {
			background-color: rgba(40, 167, 69, 0.1) !important;
		}

		.bg-info.bg-opacity-10 {
			background-color: rgba(23, 162, 184, 0.1) !important;
		}

		.bg-warning.bg-opacity-10 {
			background-color: rgba(255, 193, 7, 0.1) !important;
		}
		
		/* Badge dengan background transparan */
		.badge.bg-primary.bg-opacity-10 {
			background-color: rgba(0, 123, 255, 0.1) !important;
			border: 1px solid rgba(0, 123, 255, 0.2);
		}

		.badge.bg-success.bg-opacity-10 {
			background-color: rgba(40, 167, 69, 0.1) !important;
			border: 1px solid rgba(40, 167, 69, 0.2);
		}

		.badge.bg-info.bg-opacity-10 {
			background-color: rgba(23, 162, 184, 0.1) !important;
			border: 1px solid rgba(23, 162, 184, 0.2);
		}

		.badge.bg-warning.bg-opacity-10 {
			background-color: rgba(255, 193, 7, 0.1) !important;
			border: 1px solid rgba(255, 193, 7, 0.2);
		}

		/* Alert Wali Kelas dengan gradien */
		.alert-teal-gradient {
			background: linear-gradient(135deg, #20c997 0%, #17a2b8 100%);
			border: none;
			border-radius: 12px;
			color: white;
			padding: 1.5rem;
			box-shadow: 0 4px 15px rgba(32, 201, 151, 0.3);
		}

		.wali-kelas-icon {
			background: rgba(255, 255, 255, 0.2);
			border-radius: 50%;
			width: 60px;
			height: 60px;
			display: flex;
			align-items: center;
			justify-content: center;
			backdrop-filter: blur(10px);
		}
		
		/* Alert Tahun Ajaran dengan gradien biru */
		.alert-primary-gradient {

			background: linear-gradient(135deg, #20c997 0%, #17a2b8 100%);
			border: none;
			border-radius: 12px;
			color: white;
			padding: 1.5rem;
			box-shadow: 0 4px 15px rgba(0, 123, 255, 0.3);
			position: relative;
			overflow: hidden;
		}

		.alert-primary-gradient::before {
			content: '';
			position: absolute;
			top: 0;
			right: 0;
			width: 100px;
			height: 100px;
			background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0) 70%);
			border-radius: 50%;
			transform: translate(30px, -30px);
		}

		.tahun-ajaran-icon {
			background: rgba(255, 255, 255, 0.2);
			border-radius: 50%;
			width: 60px;
			height: 60px;
			display: flex;
			align-items: center;
			justify-content: center;
			backdrop-filter: blur(10px);
			border: 1px solid rgba(255, 255, 255, 0.3);
		}

		/* Badge dalam alert tahun ajaran */
		.alert-primary-gradient .badge.bg-white {
			color: #007bff !important;
			font-weight: 600;
			padding: 0.5rem 1rem;
			border: 1px solid rgba(255, 255, 255, 0.3);
		}

		.alert-primary-gradient .badge.bg-white.bg-opacity-20 {
			background-color: rgba(255, 255, 255, 0.2) !important;
			color: white !important;
			backdrop-filter: blur(10px);
			border: 1px solid rgba(255, 255, 255, 0.2);
		}

		.alert-primary-gradient .badge.bg-white.bg-opacity-10 {
			background-color: rgba(255, 255, 255, 0.1) !important;
			color: white !important;
			backdrop-filter: blur(10px);
			border: 1px solid rgba(255, 255, 255, 0.1);
		}

		/* Status badge */
		.alert-primary-gradient .badge.bg-success.bg-opacity-20 {
			background-color: rgba(40, 167, 69, 0.2) !important;
			color: #d4edda !important;
			border: 1px solid rgba(40, 167, 69, 0.3);
			font-weight: 500;
		}

		/* Animasi untuk tahun ajaran */
		.alert-primary-gradient {
			animation: slideInDown 0.5s ease-out;
		}

		@keyframes slideInDown {
			from {
				opacity: 0;
				transform: translateY(-20px);
			}
			to {
				opacity: 1;
				transform: translateY(0);
			}
		}

		/* Hover effects */
		.alert-primary-gradient:hover {
			transform: translateY(-2px);
			box-shadow: 0 6px 20px rgba(0, 123, 255, 0.4);
			transition: all 0.3s ease;
		}

		.tahun-ajaran-icon {
			transition: all 0.3s ease;
		}

		.alert-primary-gradient:hover .tahun-ajaran-icon {
			transform: scale(1.05) rotate(5deg);
			background: rgba(255, 255, 255, 0.25);
		}

		/* Responsive design */
		@media (max-width: 768px) {
			.alert-primary-gradient {
				text-align: center;
				padding: 1rem;
			}
			
			.alert-primary-gradient .d-flex {
				flex-direction: column;
				gap: 1rem;
			}
			
			.tahun-ajaran-icon {
				width: 50px;
				height: 50px;
			}
			
			.tahun-ajaran-icon i {
				font-size: 1.5rem !important;
			}
			
			.alert-primary-gradient .text-end {
				text-align: center !important;
			}
		}
    </style>
</head>
<body>
    <div class="container-fluid">
        <!-- Header -->
        <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
            <div class="container">
                <a class="navbar-brand" href="#">
                    <i class="bi bi-person-badge"></i> Dashboard Guru
                </a>
                <div class="navbar-nav ms-auto">
                    <span class="navbar-text me-3">
                        <i class="bi bi-person-circle"></i> <?= htmlspecialchars($userData['nama']) ?>
                    </span>
                    <a href="logout.php" class="btn btn-outline-light btn-sm">
                        <i class="bi bi-box-arrow-right"></i> Logout
                    </a>
                </div>
            </div>
        </nav>

        <div class="container mt-4 fade-in">
			
			<!-- Tahun Ajaran Info -->
			<?php if ($tahunAktif): ?>
			<div class="alert alert-primary-gradient d-flex justify-content-between align-items-center mb-4">
				<div class="d-flex align-items-center">
					<div class="tahun-ajaran-icon me-3">
						<i class="bi bi-calendar-check fs-2 text-white"></i>
					</div>
					<div>
						<h6 class="alert-heading mb-1 text-white">
							<i class="bi bi-star-fill me-2"></i>Tahun Ajaran Aktif
						</h6>
						<div class="d-flex align-items-center flex-wrap gap-2">
							<span class="badge bg-white text-primary fs-6">
								<i class="bi bi-calendar3 me-1"></i><?= $tahunAktif['tahun_ajaran'] ?>
							</span>
							<span class="badge bg-white bg-opacity-20 text-white fs-6">
								<i class="bi bi-arrow-repeat me-1"></i>Semester <?= ucfirst($tahunAktif['semester']) ?>
							</span>
							<span class="badge bg-white bg-opacity-10 text-white fs-6">
								<i class="bi bi-clock me-1"></i>Aktif
							</span>
						</div>
					</div>
				</div>
				<div class="text-end">
					<div class="text-white-50 small mb-1">Status Sistem</div>
					<span class="badge bg-success bg-opacity-20 text-white">
						<i class="bi bi-check-circle me-1"></i>Berjalan
					</span>
				</div>
			</div>
			<?php endif; ?>
			
			<!-- Statistics Cards -->
			<div class="row mb-4">
				<div class="col-xl-3 col-md-6 mb-3">
					<div class="card stat-card primary h-100">
						<div class="card-body">
							<div class="row no-gutters align-items-center">
								<div class="col mr-2">
									<div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
										Kelas yang Diampu
									</div>
									<div class="h5 mb-0 font-weight-bold text-gray-800">
										<?= $stats['total_kelas'] ?? 0 ?>
									</div>
									<div class="mt-2">
										<span class="badge bg-primary bg-opacity-10 text-primary">
											<i class="bi bi-house-door me-1"></i> Kelas Aktif
										</span>
									</div>
								</div>
								<div class="col-auto">
									<div class="bg-primary bg-opacity-10 rounded-circle p-3">
										<i class="bi bi-house-door fs-3 text-primary"></i>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div class="col-xl-3 col-md-6 mb-3">
					<div class="card stat-card success h-100">
						<div class="card-body">
							<div class="row no-gutters align-items-center">
								<div class="col mr-2">
									<div class="text-xs font-weight-bold text-success text-uppercase mb-1">
										Mata Pelajaran
									</div>
									<div class="h5 mb-0 font-weight-bold text-gray-800">
										<?= $stats['total_mapel'] ?? 0 ?>
									</div>
									<div class="mt-2">
										<span class="badge bg-success bg-opacity-10 text-success">
											<i class="bi bi-journal-text me-1"></i> Mapel Diajar
										</span>
									</div>
								</div>
								<div class="col-auto">
									<div class="bg-success bg-opacity-10 rounded-circle p-3">
										<i class="bi bi-journal-text fs-3 text-success"></i>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div class="col-xl-3 col-md-6 mb-3">
					<div class="card stat-card info h-100">
						<div class="card-body">
							<div class="row no-gutters align-items-center">
								<div class="col mr-2">
									<div class="text-xs font-weight-bold text-info text-uppercase mb-1">
										Total Siswa
									</div>
									<div class="h5 mb-0 font-weight-bold text-gray-800">
										<?= $stats['total_siswa'] ?? 0 ?>
									</div>
									<div class="mt-2">
										<span class="badge bg-info bg-opacity-10 text-info">
											<i class="bi bi-people me-1"></i> Total Murid
										</span>
									</div>
								</div>
								<div class="col-auto">
									<div class="bg-info bg-opacity-10 rounded-circle p-3">
										<i class="bi bi-people fs-3 text-info"></i>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div class="col-xl-3 col-md-6 mb-3">
					<div class="card stat-card warning h-100">
						<div class="card-body">
							<div class="row no-gutters align-items-center">
								<div class="col mr-2">
									<div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
										Tujuan Pembelajaran
									</div>
									<div class="h5 mb-0 font-weight-bold text-gray-800">
										<?= $stats['total_tp'] ?? 0 ?>
									</div>
									<div class="mt-2">
										<span class="badge bg-warning bg-opacity-10 text-warning">
											<i class="bi bi-bullseye me-1"></i> TP Aktif
										</span>
									</div>
								</div>
								<div class="col-auto">
									<div class="bg-warning bg-opacity-10 rounded-circle p-3">
										<i class="bi bi-bullseye fs-3 text-warning"></i>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<!-- Wali Kelas Info -->
			<?php if ($waliKelas): ?>
			<div class="alert alert-teal-gradient d-flex justify-content-between align-items-center mb-4">
				<div class="d-flex align-items-center">
					<div class="wali-kelas-icon me-3">
						<i class="bi bi-person-gear fs-2 text-white"></i>
					</div>
					<div>
						<h6 class="alert-heading mb-1 text-white">
							<i class="bi bi-award me-2"></i>Wali Kelas
						</h6>
						<div class="d-flex align-items-center flex-wrap">
							<span class="badge bg-white text-teal fs-6 me-2 mb-1">
								<i class="bi bi-house-door me-1"></i><?= $waliKelas['nama_kelas'] ?>
							</span>
							<span class="badge bg-white bg-opacity-20 text-white fs-6 mb-1">
								<i class="bi bi-people me-1"></i><?= $waliKelas['total_siswa'] ?> Siswa
							</span>
						</div>
					</div>
				</div>
				<a href="wali_kelas.php?kelas_id=<?= $waliKelas['kelas_id'] ?>" class="btn btn-light btn-teal-hover">
					<i class="bi bi-gear me-1"></i> Kelola Wali Kelas
				</a>
			</div>
			<?php endif; ?>

            <!-- Kelas yang Diampu -->
            <div class="row">
                <div class="col-lg-8">
                    <div class="card shadow">
                        <div class="card-header bg-white py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Kelas yang Diampu</h6>
                        </div>
                        <div class="card-body">
                            <?php if (!empty($guruMapel)): ?>
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>Kelas</th>
                                                <th>Mata Pelajaran</th>
                                                <th>Jumlah Siswa</th>
                                                <th>Aksi</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($guruMapel as $mapel): ?>
                                            <tr>
                                                <td>
                                                    <strong><?= $mapel['nama_kelas'] ?></strong><br>
                                                    <small class="text-muted"><?= $mapel['tingkat'] ?> - <?= $mapel['jurusan'] ?: 'Umum' ?></small>
                                                </td>
                                                <td>
                                                    <strong><?= $mapel['nama_mapel'] ?></strong><br>
                                                    <small class="text-muted"><?= $mapel['kode_mapel'] ?></small>
                                                </td>
                                                <td>
                                                    <span class="badge bg-primary"><?= $mapel['total_siswa'] ?> Siswa</span>
                                                </td>
                                                <td>
                                                    <div class="btn-group btn-group-sm">
                                                        <a href="nilai.php?mapel_id=<?= $mapel['mapel_id'] ?>&kelas_id=<?= $mapel['kelas_id'] ?>" 
                                                           class="btn btn-outline-primary">
                                                            <i class="bi bi-pencil"></i> Input Nilai
                                                        </a>
                                                        <a href="tp.php?mapel_id=<?= $mapel['mapel_id'] ?>" 
                                                           class="btn btn-outline-success">
                                                            <i class="bi bi-bullseye"></i> TP
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <p class="text-muted text-center py-4">
                                    <i class="bi bi-info-circle fs-1"></i><br>
                                    Belum ada penugasan mengajar untuk tahun ajaran ini.
                                </p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

					<!-- Ganti bagian Quick Actions yang existing -->
				<div class="col-lg-4">
					<!-- Quick Actions -->
					<div class="card shadow mb-4">
						<div class="card-header bg-white py-3">
							<h6 class="m-0 font-weight-bold text-primary">Quick Actions</h6>
						</div>
						<div class="card-body">
							<div class="row">
								<div class="col-6 mb-3">
									<a href="tp.php" class="card quick-action-card text-decoration-none h-100">
										<div class="card-body text-center p-3">
											<i class="bi bi-bullseye fs-1 text-primary mb-2"></i>
											<div class="fw-bold">Input TP</div>
											<small class="text-muted">Nilai Sumatif TP</small>
										</div>
									</a>
								</div>
								<div class="col-6 mb-3">
									<a href="kegiatan_formatif.php" class="card quick-action-card text-decoration-none h-100">
										<div class="card-body text-center p-3">
											<i class="bi bi-calendar-event fs-1 text-success mb-2"></i>
											<div class="fw-bold">Input Kegiatan</div>
											<small class="text-muted">Nilai Formatif TP</small>
										</div>
									</a>
								</div>
								<div class="col-6 mb-3">
									<a href="rekap_nilai.php" class="card quick-action-card text-decoration-none h-100">
										<div class="card-body text-center p-3">
											<i class="bi bi-pencil-square fs-1 text-warning mb-2"></i>
											<div class="fw-bold">Hasil Formatif</div>
											<small class="text-muted">Per Kegiatan</small>
										</div>
									</a>
								</div>
								<div class="col-6 mb-3">
									<a href="rekap_nilai.php" class="card quick-action-card text-decoration-none h-100">
										<div class="card-body text-center p-3">
											<i class="bi bi-graph-up fs-1 text-info mb-2"></i>
											<div class="fw-bold">Hasil Sumatif</div>
											<small class="text-muted">TP & Akhir</small>
										</div>
									</a>
								</div>
								<div class="col-6 mb-3">
									<a href="rekap_data.php" class="card quick-action-card text-decoration-none h-100">
										<div class="card-body text-center p-3">
											<i class="bi bi-table fs-1 text-teal mb-2"></i>
											<div class="fw-bold">Rekap Data</div>
											<small class="text-muted">Detail Nilai</small>
										</div>
									</a>
								</div>
								<div class="col-6 mb-3">
									<a href="ledger.php" class="card quick-action-card text-decoration-none h-100">
										<div class="card-body text-center p-3">
											<i class="bi bi-calculator fs-1 text-purple mb-2"></i>
											<div class="fw-bold">Ledger</div>
											<small class="text-muted">Nilai Akhir</small>
										</div>
									</a>
								</div>
							</div>
						</div>
					</div>
					<!-- System Info tetap sama -->
				

                    <!-- System Info -->
                    <div class="card shadow">
                        <div class="card-header bg-white py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Info Guru</h6>
                        </div>
                        <div class="card-body text-center">
                            <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" 
                                 style="width: 80px; height: 80px;">
                                <i class="bi bi-person-badge fs-2"></i>
                            </div>
                            <h6><?= htmlspecialchars($userData['nama']) ?></h6>
                            <p class="text-muted small">
                                <i class="bi bi-person"></i> <?= htmlspecialchars($userData['username']) ?><br>
                                <i class="bi bi-shield-check"></i> Guru
                            </p>
                            <div class="small text-muted">
                                Login: <?= date('H:i') ?><br>
                                <?= $tahunAktif ? $tahunAktif['tahun_ajaran'] . ' - ' . ucfirst($tahunAktif['semester']) : 'Tahun ajaran tidak aktif' ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
	<style>
        .text-teal { color: #20c997; }
        .bg-teal { background-color: #20c997; }
        .btn-teal { 
            background-color: #20c997; 
            border-color: #20c997;
            color: white;
        }
        .btn-teal:hover {
            background-color: #199d7a;
            border-color: #199d7a;
        }
        .btn-outline-teal {
            color: #20c997;
            border-color: #20c997;
        }
        .btn-outline-teal:hover {
            background-color: #20c997;
            border-color: #20c997;
            color: white;
        }
        .alert-teal {
            background-color: #d1f2eb;
            border-color: #20c997;
            color: #0c5460;
        }
    </style>
</body>
</html>
