<?php
// DEBUG: Tampilkan semua error
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Include config
require_once __DIR__ . '/../../app/config/config.php';

echo "<!-- Debug: BASE_URL = " . BASE_URL . " -->";
echo "<!-- Debug: Current URL = http://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'] . " -->";

$error = '';
$username = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    echo "<!-- Debug: Form submitted -->";
    
    $username = Helper::sanitize($_POST['username']);
    $password = $_POST['password'];
    
    echo "<!-- Debug: Username: $username -->";
    
    // Include UserModel
    require_once __DIR__ . '/../../app/models/UserModel.php';
    
    $userModel = new UserModel();
    $user = $userModel->login($username, $password);
    
    if ($user) {
        echo "<!-- Debug: Login successful -->";
        echo "<!-- Debug: User Level: " . $user['level'] . " -->";
        
        Session::set('user_id', $user['id']);
        Session::set('username', $user['username']);
        Session::set('nama', $user['nama']);
        Session::set('level', $user['level']);
        Session::set('siswa_id', $user['siswa_id']);
        Session::set('guru_id', $user['guru_id']);
        
        // Debug session
        echo "<!-- Debug: Session Data Set -->";
        echo "<!-- Debug: Redirecting to: " . BASE_URL . $user['level'] . "/dashboard.php -->";
        
        // Redirect based on role dengan full URL
        $redirectUrl = BASE_URL . $user['level'] . '/dashboard.php';
        echo "<!-- Debug: Final Redirect URL: $redirectUrl -->";
        
        header('Location: ' . $redirectUrl);
        exit;
        
    } else {
        $error = "Username atau password salah!";
        echo "<!-- Debug: Login failed -->";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Sistem Penilaian</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { 
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        .login-container { 
            max-width: 400px; 
            margin: 0 auto;
        }
        .card { 
            border-radius: 15px; 
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
            border: none;
        }
        .card-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 15px 15px 0 0 !important;
            padding: 2rem 1rem;
        }
        .debug-info {
            background: #f8f9fa;
            border-radius: 5px;
            padding: 10px;
            font-size: 12px;
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="login-container">
            <div class="card">
                <div class="card-header text-white text-center">
                    <h4><i class="bi bi-person-circle"></i> Sistem Penilaian</h4>
                    <p class="mb-0">Silakan login untuk melanjutkan</p>
                </div>
                <div class="card-body p-4">
                    <?php if ($error): ?>
                        <div class="alert alert-danger alert-dismissible fade show">
                            <?= $error ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>
                    
                    <form method="POST">
                        <div class="mb-3">
                            <label for="username" class="form-label">Username</label>
                            <input type="text" class="form-control" id="username" name="username" 
                                   value="<?= $username ?>" required autofocus>
                        </div>
                        <div class="mb-3">
                            <label for="password" class="form-label">Password</label>
                            <input type="password" class="form-control" id="password" name="password" required>
                        </div>
                        <button type="submit" class="btn btn-primary w-100 py-2">
                            <i class="bi bi-box-arrow-in-right"></i> Login
                        </button>
                    </form>

                    <div class="mt-4">
                        <h6>Akun Testing:</h6>
                        <div class="small">
                            <strong>Admin:</strong> admin / password<br>
                            <strong>Guru:</strong> ninisctk / password<br>
                            <strong>Siswa:</strong> 7A042025 / password
                        </div>
                    </div>

                    <!-- Debug Info -->
                    <div class="debug-info">
                        <strong>Debug Info:</strong><br>
                        BASE_URL: <?= BASE_URL ?><br>
                        Current: http://<?= $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'] ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>