// Edit Siswa functionality
document.addEventListener('DOMContentLoaded', function() {
    // Edit Siswa
    document.querySelectorAll('.edit-siswa').forEach(btn => {
        btn.addEventListener('click', function() {
            const siswaId = this.getAttribute('data-id');
            loadSiswaData(siswaId);
        });
    });

    // Delete Siswa
    document.querySelectorAll('.delete-siswa').forEach(btn => {
        btn.addEventListener('click', function() {
            const siswaId = this.getAttribute('data-id');
            const siswaNama = this.getAttribute('data-nama');
            
            document.getElementById('delete_siswa_id').value = siswaId;
            document.getElementById('delete_siswa_nama').textContent = siswaNama;
            
            const deleteModal = new bootstrap.Modal(document.getElementById('deleteSiswaModal'));
            deleteModal.show();
        });
    });

    // Delete confirmation
    document.getElementById('confirmDeleteSiswa').addEventListener('change', function() {
        document.getElementById('deleteSiswaConfirmBtn').disabled = !this.checked;
    });

    // Reset delete confirmation when modal is closed
    document.getElementById('deleteSiswaModal').addEventListener('hidden.bs.modal', function () {
        document.getElementById('confirmDeleteSiswa').checked = false;
        document.getElementById('deleteSiswaConfirmBtn').disabled = true;
    });

    // Reset edit modal when closed
    document.getElementById('editSiswaModal').addEventListener('hidden.bs.modal', function () {
        // Reset form
        document.getElementById('editSiswaForm').reset();
        
        // Show form content, hide loading
        document.getElementById('editFormContent').style.display = 'block';
        document.getElementById('editLoading').classList.add('d-none');
    });
});

function loadSiswaData(siswaId) {
    const loadingEl = document.getElementById('editLoading');
    const formContentEl = document.getElementById('editFormContent');
    
    // Show loading, hide form
    loadingEl.classList.remove('d-none');
    formContentEl.style.display = 'none';
    
    // Fetch siswa data
    fetch(`siswa.php?get_siswa&id=${siswaId}`)
        .then(response => {
            if (!response.ok) {
                throw new Error('Gagal memuat data siswa');
            }
            return response.json();
        })
        .then(data => {
            if (data.error) {
                throw new Error(data.error);
            }
            
            // Populate form
            document.getElementById('edit_siswa_id').value = siswaId;
            document.getElementById('edit_nis').value = data.nis || '';
            document.getElementById('edit_nama').value = data.nama || '';
            document.getElementById('edit_username').value = data.username || '';
            document.getElementById('edit_kelas_id').value = data.kelas_id || '';
            
            // Show form, hide loading
            loadingEl.classList.add('d-none');
            formContentEl.style.display = 'block';
            
            // Show modal
            const editModal = new bootstrap.Modal(document.getElementById('editSiswaModal'));
            editModal.show();
        })
        .catch(error => {
            console.error('Error:', error);
            alert(error.message);
            
            // Hide loading, show form
            loadingEl.classList.add('d-none');
            formContentEl.style.display = 'block';
            
            // Close modal if open
            const editModal = bootstrap.Modal.getInstance(document.getElementById('editSiswaModal'));
            if (editModal) {
                editModal.hide();
            }
        });
}