<?php
require_once __DIR__ . '/../../app/config/config.php';
Session::checkAuth();
Session::checkRole(['admin']);

$adminModel = new AdminModel();
$tahunAjaran = $adminModel->getAllTahunAjaran();
$tahunAktif = $adminModel->getActiveTahunAjaran();

$success = $_GET['success'] ?? '';
$error = '';

// Handle activate tahun ajaran
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['activate_tahun'])) {
    $tahunId = intval($_POST['tahun_id']);
    
    if ($adminModel->activateTahunAjaran($tahunId)) {
        Helper::redirect('tahun_ajaran.php?success=1');
    } else {
        $error = "Gagal mengaktifkan tahun ajaran";
    }
}

// Handle add tahun ajaran
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_tahun'])) {
    $data = [
        'tahun_ajaran' => Helper::sanitize($_POST['tahun_ajaran']),
        'semester' => Helper::sanitize($_POST['semester']),
        'tanggal_mulai' => $_POST['tanggal_mulai'],
        'tanggal_selesai' => $_POST['tanggal_selesai']
    ];
    
    if ($adminModel->addTahunAjaran($data)) {
        Helper::redirect('tahun_ajaran.php?success=2');
    } else {
        $error = "Gagal menambah tahun ajaran!";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manajemen Tahun Ajaran - Sistem Penilaian</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body>
    <?php include __DIR__ . '/includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include __DIR__ . '/includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Manajemen Tahun Ajaran</h1>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addTahunModal">
                        <i class="bi bi-plus-circle"></i> Tambah Tahun Ajaran
                    </button>
                </div>

                <?php if ($success == '1'): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        Tahun ajaran berhasil diaktifkan!
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php elseif ($success == '2'): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        Tahun ajaran berhasil ditambahkan!
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php if ($error): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?= $error ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <!-- Tahun Ajaran Aktif -->
                <?php if ($tahunAktif): ?>
                <div class="alert alert-info d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="alert-heading mb-1">
                            <i class="bi bi-star-fill"></i> Tahun Ajaran Aktif
                        </h6>
                        <strong class="me-2"><?= $tahunAktif['tahun_ajaran'] ?></strong>
                        <span class="badge bg-primary">Semester <?= ucfirst($tahunAktif['semester']) ?></span>
                        <small class="text-muted ms-2">
                            Periode: <?= date('d M Y', strtotime($tahunAktif['tanggal_mulai'])) ?> - <?= date('d M Y', strtotime($tahunAktif['tanggal_selesai'])) ?>
                        </small>
                    </div>
                    <div>
                        <span class="badge bg-success me-2">AKTIF</span>
                        <small class="text-muted">Sistem mengikuti tahun ini</small>
                    </div>
                </div>
                <?php else: ?>
                <div class="alert alert-warning">
                    <i class="bi bi-exclamation-triangle"></i> Tidak ada tahun ajaran yang aktif. Silakan aktifkan tahun ajaran.
                </div>
                <?php endif; ?>

                <div class="card shadow">
                    <div class="card-header bg-white d-flex justify-content-between align-items-center">
                        <h6 class="mb-0">Daftar Tahun Ajaran</h6>
                        <small class="text-muted">Total: <?= count($tahunAjaran) ?> tahun ajaran</small>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>Tahun Ajaran</th>
                                        <th>Semester</th>
                                        <th>Periode</th>
                                        <th>Status</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!empty($tahunAjaran)): ?>
                                        <?php foreach ($tahunAjaran as $ta): ?>
                                        <tr>
                                            <td>
                                                <strong><?= htmlspecialchars($ta['tahun_ajaran']) ?></strong>
                                            </td>
                                            <td>
                                                <span class="badge bg-<?= $ta['semester'] == 'ganjil' ? 'primary' : 'info' ?>">
                                                    <?= ucfirst($ta['semester']) ?>
                                                </span>
                                            </td>
                                            <td>
                                                <small>
                                                    <?= date('d M Y', strtotime($ta['tanggal_mulai'])) ?><br>
                                                    <span class="text-muted">s/d</span><br>
                                                    <?= date('d M Y', strtotime($ta['tanggal_selesai'])) ?>
                                                </small>
                                            </td>
                                            <td>
                                                <?php if ($ta['status'] == 'aktif'): ?>
                                                    <span class="badge bg-success">Aktif</span>
                                                <?php else: ?>
                                                    <span class="badge bg-secondary">Nonaktif</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if ($ta['status'] != 'aktif'): ?>
                                                <form method="POST" style="display: inline;">
                                                    <input type="hidden" name="tahun_id" value="<?= $ta['id'] ?>">
                                                    
                                                    <button type="submit" name="activate_tahun" 
                                                            class="btn btn-sm btn-success"
                                                            onclick="return confirm('Aktifkan tahun ajaran <?= $ta['tahun_ajaran'] ?>? Sistem akan menyesuaikan data.')">
                                                        <i class="bi bi-check-circle"></i> Aktifkan
                                                    </button>
                                                </form>
                                                <?php else: ?>
                                                <span class="text-success">
                                                    <i class="bi bi-check-lg"></i> Sedang aktif
                                                </span>
                                                <?php endif; ?>
                                                
                                                <button class="btn btn-sm btn-outline-primary">
                                                    <i class="bi bi-pencil"></i>
                                                </button>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="5" class="text-center text-muted py-4">
                                                <i class="bi bi-calendar-x fs-1 d-block mb-2"></i>
                                                Tidak ada data tahun ajaran
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Info Panel -->
                <div class="row mt-4">
                    <div class="col-md-6">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h6><i class="bi bi-info-circle text-primary"></i> Informasi Tahun Ajaran</h6>
                                <ul class="small mb-0 ps-3">
                                    <li>Sistem hanya bisa memiliki <strong>satu tahun ajaran aktif</strong></li>
                                    <li>Mengaktifkan tahun ajaran baru akan <strong>menonaktifkan</strong> tahun sebelumnya</li>
                                    <li>Data penugasan guru dan nilai mengikuti tahun ajaran aktif</li>
                                    <li><strong>Kenaikan kelas dilakukan manual</strong> melalui menu manajemen kelas</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h6><i class="bi bi-shield-check text-success"></i> Status Sistem</h6>
                                <div class="small">
                                    <strong>Tahun Ajaran Aktif:</strong><br>
                                    <?php if ($tahunAktif): ?>
                                        ✅ <?= $tahunAktif['tahun_ajaran'] ?> - <?= ucfirst($tahunAktif['semester']) ?><br>
                                        <small class="text-muted">
                                            Berlaku: <?= date('d M Y', strtotime($tahunAktif['tanggal_mulai'])) ?> - <?= date('d M Y', strtotime($tahunAktif['tanggal_selesai'])) ?>
                                        </small>
                                    <?php else: ?>
                                        ❌ Tidak ada tahun ajaran aktif<br>
                                        <small class="text-muted">Sistem tidak dapat beroperasi</small>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <!-- Add Tahun Ajaran Modal -->
    <div class="modal fade" id="addTahunModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST">
                    <div class="modal-header">
                        <h5 class="modal-title">Tambah Tahun Ajaran Baru</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="tahun_ajaran" class="form-label">Tahun Ajaran</label>
                            <input type="text" class="form-control" id="tahun_ajaran" name="tahun_ajaran" required
                                   placeholder="Contoh: 2024/2025" pattern="\d{4}/\d{4}">
                            <div class="form-text">Format: 2024/2025</div>
                        </div>
                        <div class="mb-3">
                            <label for="semester" class="form-label">Semester</label>
                            <select class="form-select" id="semester" name="semester" required>
                                <option value="">Pilih Semester</option>
                                <option value="ganjil">Ganjil</option>
                                <option value="genap">Genap</option>
                            </select>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="tanggal_mulai" class="form-label">Tanggal Mulai</label>
                                    <input type="date" class="form-control" id="tanggal_mulai" name="tanggal_mulai" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="tanggal_selesai" class="form-label">Tanggal Selesai</label>
                                    <input type="date" class="form-control" id="tanggal_selesai" name="tanggal_selesai" required>
                                </div>
                            </div>
                        </div>
                        <div class="alert alert-info small">
                            <i class="bi bi-lightbulb"></i> 
                            <strong>Tips:</strong> 
                            <ul class="mb-0">
                                <li>Tahun ajaran baru akan ditambahkan sebagai nonaktif</li>
                                <li>Kenaikan kelas dilakukan manual melalui menu Kelas</li>
                                <li>Dalam 1 tahun ajaran (contoh: 2024/2025), kelas tetap sama antara semester ganjil dan genap</li>
                            </ul>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" name="add_tahun" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Set default dates
        document.addEventListener('DOMContentLoaded', function() {
            const today = new Date();
            const year = today.getFullYear();
            
            // Set default tahun ajaran
            document.getElementById('tahun_ajaran').value = year + '/' + (year + 1);
            
            // Set default dates for semester ganjil
            document.getElementById('tanggal_mulai').value = year + '-07-15';
            document.getElementById('tanggal_selesai').value = year + '-12-20';
            
            // Update dates based on semester selection
            document.getElementById('semester').addEventListener('change', function() {
                const semester = this.value;
                const year = today.getFullYear();
                
                if (semester === 'ganjil') {
                    document.getElementById('tanggal_mulai').value = year + '-07-15';
                    document.getElementById('tanggal_selesai').value = year + '-12-20';
                } else if (semester === 'genap') {
                    document.getElementById('tanggal_mulai').value = (year + 1) + '-01-06';
                    document.getElementById('tanggal_selesai').value = (year + 1) + '-06-20';
                }
            });
        });
    </script>
</body>
</html>