<?php
require_once __DIR__ . '/../../app/config/config.php';
Session::checkAuth();
Session::checkRole(['admin']);

$adminModel = new AdminModel();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['add_mapel'])) {
        // Tambah mapel baru
        $kode_mapel = trim($_POST['kode_mapel'] ?? '');
        $nama_mapel = trim($_POST['nama_mapel'] ?? '');
        $deskripsi = trim($_POST['deskripsi'] ?? '');
        
        // Validasi input
        if (empty($kode_mapel) || empty($nama_mapel)) {
            header('Location: mapel.php?error=1&message=Kode dan Nama Mapel harus diisi');
            exit;
        }
        
        try {
            $result = $adminModel->addMapel($kode_mapel, $nama_mapel, $deskripsi);
            
            if ($result) {
                header('Location: mapel.php?success=1');
            } else {
                header('Location: mapel.php?error=1&message=Gagal menambahkan mapel');
            }
        } catch (Exception $e) {
            error_log('Error adding mapel: ' . $e->getMessage());
            header('Location: mapel.php?error=1&message=Terjadi kesalahan sistem');
        }
        exit;
    }
    
    if (isset($_POST['edit_mapel'])) {
        // Edit mapel
        $id = $_POST['id'] ?? '';
        $kode_mapel = trim($_POST['kode_mapel'] ?? '');
        $nama_mapel = trim($_POST['nama_mapel'] ?? '');
        $deskripsi = trim($_POST['deskripsi'] ?? '');
        
        // Validasi input
        if (empty($id) || empty($kode_mapel) || empty($nama_mapel)) {
            header('Location: mapel.php?error=2&message=Data tidak lengkap');
            exit;
        }
        
        try {
            $result = $adminModel->updateMapel($id, $kode_mapel, $nama_mapel, $deskripsi);
            
            if ($result) {
                header('Location: mapel.php?success=2');
            } else {
                header('Location: mapel.php?error=2&message=Gagal mengupdate mapel');
            }
        } catch (Exception $e) {
            error_log('Error updating mapel: ' . $e->getMessage());
            header('Location: mapel.php?error=2&message=Terjadi kesalahan sistem');
        }
        exit;
    }
}

// Handle DELETE request
if (isset($_GET['delete_id'])) {
    $id = $_GET['delete_id'] ?? '';
    
    if (empty($id)) {
        header('Location: mapel.php?error=3&message=ID mapel tidak valid');
        exit;
    }
    
    try {
        $result = $adminModel->deleteMapel($id);
        
        if ($result) {
            header('Location: mapel.php?success=3');
        } else {
            header('Location: mapel.php?error=3&message=Gagal menghapus mapel');
        }
    } catch (Exception $e) {
        error_log('Error deleting mapel: ' . $e->getMessage());
        header('Location: mapel.php?error=3&message=Terjadi kesalahan sistem');
    }
    exit;
}

// Jika tidak ada aksi yang valid, redirect ke halaman mapel
header('Location: mapel.php');
exit;
?>