<?php
require_once __DIR__ . '/../../app/config/config.php';
Session::checkAuth();
Session::checkRole(['admin']);

$adminModel = new AdminModel();
$mapel = $adminModel->getAllMapel();

$success = $_GET['success'] ?? '';
$error = $_GET['error'] ?? '';
$error_message = $_GET['message'] ?? '';
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mata Pelajaran - Sistem Penilaian</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        .card {
            transition: transform 0.2s;
        }
        .card:hover {
            transform: translateY(-2px);
        }
    </style>
</head>
<body>
    <?php include __DIR__ . '/includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include __DIR__ . '/includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Mata Pelajaran</h1>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addMapelModal">
                        <i class="bi bi-plus-circle"></i> Tambah Mapel
                    </button>
                </div>

                <!-- Alert Messages -->
                <?php if ($success): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle-fill"></i>
                        <?php
                        switch($success) {
                            case '1': echo "Mata pelajaran berhasil ditambahkan!"; break;
                            case '2': echo "Mata pelajaran berhasil diupdate!"; break;
                            case '3': echo "Mata pelajaran berhasil dihapus!"; break;
                            default: echo "Operasi berhasil!";
                        }
                        ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php if ($error): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="bi bi-exclamation-triangle-fill"></i>
                        <strong>Error!</strong> 
                        <?php
                        if (!empty($error_message)) {
                            echo htmlspecialchars($error_message);
                        } else {
                            switch($error) {
                                case '1': echo "Gagal menambahkan mata pelajaran!"; break;
                                case '2': echo "Gagal mengupdate mata pelajaran!"; break;
                                case '3': echo "Gagal menghapus mata pelajaran!"; break;
                                default: echo "Terjadi kesalahan!";
                            }
                        }
                        ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <!-- Mapel Cards -->
                <div class="row">
                    <?php if (!empty($mapel)): ?>
                        <?php foreach ($mapel as $m): ?>
                        <div class="col-xl-4 col-lg-6 mb-4">
                            <div class="card h-100">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h6 class="card-title mb-0">
                                        <i class="bi bi-journal-text text-primary"></i>
                                        <?= htmlspecialchars($m['kode_mapel']) ?>
                                    </h6>
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-sm btn-outline-primary edit-btn" 
                                                data-id="<?= $m['id'] ?>"
                                                data-kode="<?= htmlspecialchars($m['kode_mapel']) ?>"
                                                data-nama="<?= htmlspecialchars($m['nama_mapel']) ?>"
                                                data-deskripsi="<?= htmlspecialchars($m['deskripsi']) ?>">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                        <button type="button" class="btn btn-sm btn-outline-danger delete-btn" 
                                                data-id="<?= $m['id'] ?>"
                                                data-nama="<?= htmlspecialchars($m['nama_mapel']) ?>">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <h5 class="card-title"><?= htmlspecialchars($m['nama_mapel']) ?></h5>
                                    <p class="card-text text-muted small">
                                        <?= $m['deskripsi'] ? htmlspecialchars($m['deskripsi']) : 'Tidak ada deskripsi' ?>
                                    </p>
                                </div>
                                <div class="card-footer bg-transparent">
                                    <small class="text-muted">
                                        <i class="bi bi-clock"></i> 
                                        Dibuat: <?= Helper::formatDate($m['created_at'] ?? date('Y-m-d')) ?>
                                    </small>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body text-center py-5">
                                    <i class="bi bi-journal-x fs-1 text-muted d-block mb-3"></i>
                                    <h5 class="text-muted">Belum ada mata pelajaran</h5>
                                    <p class="text-muted">Tambahkan mata pelajaran pertama Anda</p>
                                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addMapelModal">
                                        <i class="bi bi-plus-circle"></i> Tambah Mapel Pertama
                                    </button>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </main>
        </div>
    </div>

    <!-- Add Mapel Modal -->
    <div class="modal fade" id="addMapelModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST" action="mapel_action.php">
                    <div class="modal-header">
                        <h5 class="modal-title">Tambah Mata Pelajaran</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="kode_mapel" class="form-label">Kode Mapel</label>
                            <input type="text" class="form-control" id="kode_mapel" name="kode_mapel" required
                                   placeholder="Contoh: MAT, BIN, ING">
                        </div>
                        <div class="mb-3">
                            <label for="nama_mapel" class="form-label">Nama Mata Pelajaran</label>
                            <input type="text" class="form-control" id="nama_mapel" name="nama_mapel" required
                                   placeholder="Contoh: Matematika, Bahasa Indonesia">
                        </div>
                        <div class="mb-3">
                            <label for="deskripsi" class="form-label">Deskripsi</label>
                            <textarea class="form-control" id="deskripsi" name="deskripsi" rows="3"
                                      placeholder="Deskripsi singkat mata pelajaran"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" name="add_mapel" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Mapel Modal -->
    <div class="modal fade" id="editMapelModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST" action="mapel_action.php">
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Mata Pelajaran</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" id="edit_id" name="id">
                        <div class="mb-3">
                            <label for="edit_kode_mapel" class="form-label">Kode Mapel</label>
                            <input type="text" class="form-control" id="edit_kode_mapel" name="kode_mapel" required>
                        </div>
                        <div class="mb-3">
                            <label for="edit_nama_mapel" class="form-label">Nama Mata Pelajaran</label>
                            <input type="text" class="form-control" id="edit_nama_mapel" name="nama_mapel" required>
                        </div>
                        <div class="mb-3">
                            <label for="edit_deskripsi" class="form-label">Deskripsi</label>
                            <textarea class="form-control" id="edit_deskripsi" name="deskripsi" rows="3"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" name="edit_mapel" class="btn btn-primary">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Edit Button Handler
        const editButtons = document.querySelectorAll('.edit-btn');
        editButtons.forEach(button => {
            button.addEventListener('click', function() {
                const id = this.getAttribute('data-id');
                const kode = this.getAttribute('data-kode');
                const nama = this.getAttribute('data-nama');
                const deskripsi = this.getAttribute('data-deskripsi');
                
                // Set values to edit form
                document.getElementById('edit_id').value = id;
                document.getElementById('edit_kode_mapel').value = kode;
                document.getElementById('edit_nama_mapel').value = nama;
                document.getElementById('edit_deskripsi').value = deskripsi;
                
                // Show edit modal
                const editModal = new bootstrap.Modal(document.getElementById('editMapelModal'));
                editModal.show();
            });
        });
        
        // Delete Button Handler
        const deleteButtons = document.querySelectorAll('.delete-btn');
        deleteButtons.forEach(button => {
            button.addEventListener('click', function() {
                const id = this.getAttribute('data-id');
                const nama = this.getAttribute('data-nama');
                
                if (confirm(`Apakah Anda yakin ingin menghapus mata pelajaran "${nama}"?`)) {
                    window.location.href = `mapel_action.php?delete_id=${id}`;
                }
            });
        });
        
        // Auto-close alerts after 5 seconds
        const alerts = document.querySelectorAll('.alert');
        alerts.forEach(alert => {
            setTimeout(() => {
                const bsAlert = new bootstrap.Alert(alert);
                bsAlert.close();
            }, 5000);
        });
    });
    </script>
</body>
</html>