<?php
require_once __DIR__ . '/../../app/config/config.php';
Session::checkAuth();
Session::checkRole(['admin']);

$kelasId = intval($_GET['id'] ?? 0);
if ($kelasId == 0) {
    Helper::redirect('kelas.php');
}

$adminModel = new AdminModel();
$kelas = $adminModel->getKelasById($kelasId);
if (!$kelas) {
    Helper::redirect('kelas.php');
}

// Get siswa in this class
$siswa = $adminModel->getSiswaByKelas($kelasId);
$tahunAktif = $adminModel->getActiveTahunAjaran();
$waliKelas = $tahunAktif ? $adminModel->getWaliKelasByKelas($kelasId, $tahunAktif['id']) : false;

// Get all kelas for move siswa (including from other tahun ajaran)
$allKelasForMove = $adminModel->getAllKelasWithoutFilter();

$success = $_GET['success'] ?? '';
$error = '';

// Handle move siswa to another class
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['move_siswa'])) {
    $siswaId = intval($_POST['siswa_id']);
    $newKelasId = intval($_POST['new_kelas_id']);
    
    if ($adminModel->moveSiswaToKelas($siswaId, $newKelasId, $tahunAktif['id'])) {
        Helper::redirect("kelas_siswa.php?id=$kelasId&success=1");
    } else {
        $error = "Gagal memindahkan siswa!";
    }
}

// Handle remove siswa from class
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['remove_siswa'])) {
    $siswaId = intval($_POST['siswa_id']);
    
    if ($adminModel->removeSiswaFromKelas($siswaId)) {
        Helper::redirect("kelas_siswa.php?id=$kelasId&success=2");
    } else {
        $error = "Gagal mengeluarkan siswa dari kelas!";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Siswa Kelas <?= htmlspecialchars($kelas['nama_kelas']) ?> - Sistem Penilaian</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body>
    <?php include __DIR__ . '/includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include __DIR__ . '/includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <!-- Header -->
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <div>
                        <h1 class="h2">
                            <i class="bi bi-people"></i>
                            Siswa Kelas <?= htmlspecialchars($kelas['nama_kelas']) ?>
                        </h1>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="kelas.php">Kelas</a></li>
                                <li class="breadcrumb-item active"><?= htmlspecialchars($kelas['nama_kelas']) ?></li>
                            </ol>
                        </nav>
                    </div>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <a href="kelas.php" class="btn btn-secondary me-2">
                            <i class="bi bi-arrow-left"></i> Kembali
                        </a>
                        <a href="siswa.php" class="btn btn-primary">
                            <i class="bi bi-plus-circle"></i> Tambah Siswa
                        </a>
                    </div>
                </div>

                <?php if ($success == '1'): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        Siswa berhasil dipindahkan ke kelas lain!
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php elseif ($success == '2'): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        Siswa berhasil dikeluarkan dari kelas!
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php if ($error): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?= $error ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <!-- Class Info Card -->
				<!-- Class Info Card -->
				<div class="row mb-4">
					<div class="col-12">
						<div class="card">
							<div class="card-body">
								<div class="row">
									<div class="col-md-4">
										<h5 class="card-title"><?= htmlspecialchars($kelas['nama_kelas']) ?></h5>
										<p class="card-text">
											<strong>Tingkat:</strong> Kelas <?= $kelas['tingkat'] ?><br>
											<strong>Jurusan:</strong> <?= $kelas['jurusan'] ? htmlspecialchars($kelas['jurusan']) : 'Umum' ?><br>
											<strong>Kapasitas:</strong> <?= $kelas['total_siswa'] ?>/<?= $kelas['kapasitas'] ?> siswa
										</p>
										<?php 
										$tahunKelas = $adminModel->getTahunAjaranById($kelas['tahun_ajaran_id']);
										if ($tahunKelas): 
										?>
										<p class="card-text">
											<strong>Tahun Ajaran:</strong> <?= $tahunKelas['tahun_ajaran'] ?> - <?= ucfirst($tahunKelas['semester']) ?>
										</p>
										<?php endif; ?>
									</div>
									<div class="col-md-4">
										<div class="progress mb-2" style="height: 20px;">
											<div class="progress-bar <?= ($kelas['total_siswa'] / $kelas['kapasitas']) * 100 >= 90 ? 'bg-danger' : 'bg-success' ?>" 
												 role="progressbar" 
												 style="width: <?= ($kelas['total_siswa'] / $kelas['kapasitas']) * 100 ?>%"
												 aria-valuenow="<?= $kelas['total_siswa'] ?>" 
												 aria-valuemin="0" 
												 aria-valuemax="<?= $kelas['kapasitas'] ?>">
												<?= round(($kelas['total_siswa'] / $kelas['kapasitas']) * 100) ?>%
											</div>
										</div>
										<small class="text-muted">
											<?= $kelas['kapasitas'] - $kelas['total_siswa'] ?> kursi tersisa
										</small>
									</div>
									<div class="col-md-4">
										<?php if ($waliKelas): ?>
										<div class="alert alert-info py-2">
											<strong>Wali Kelas:</strong><br>
											<?= htmlspecialchars($waliKelas['nama_guru']) ?><br>
											<small class="text-muted">NIP: <?= htmlspecialchars($waliKelas['nip']) ?></small>
										</div>
										<?php else: ?>
										<div class="alert alert-warning py-2">
											<i class="bi bi-exclamation-triangle"></i>
											Belum ada wali kelas
										</div>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

                <!-- Students Table -->
                <div class="card shadow">
                    <div class="card-header bg-white d-flex justify-content-between align-items-center">
                        <h6 class="mb-0">
                            <i class="bi bi-list-ul"></i>
                            Daftar Siswa (<?= count($siswa) ?> siswa)
                        </h6>
                        <div class="btn-group">
                            <button class="btn btn-sm btn-outline-secondary" onclick="window.print()">
                                <i class="bi bi-printer"></i> Print
                            </button>
                            <button class="btn btn-sm btn-outline-secondary">
                                <i class="bi bi-download"></i> Export
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php if (!empty($siswa)): ?>
                            <div class="table-responsive">
                                <table class="table table-hover table-striped">
                                    <thead class="table-light">
                                        <tr>
                                            <th>#</th>
                                            <th>NIS</th>
                                            <th>Nama Siswa</th>
                                            <th>Username</th>
                                            <th>Status</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($siswa as $index => $s): ?>
                                        <tr>
                                            <td><?= $index + 1 ?></td>
                                            <td>
                                                <code><?= htmlspecialchars($s['nis']) ?></code>
                                            </td>
                                            <td>
                                                <strong><?= htmlspecialchars($s['nama']) ?></strong>
                                            </td>
                                            <td><?= htmlspecialchars($s['username']) ?></td>
                                            <td>
                                                <span class="badge bg-success">Aktif</span>
                                            </td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <a href="siswa_detail.php?id=<?= $s['id'] ?>" 
                                                       class="btn btn-outline-primary" 
                                                       title="Detail Siswa">
                                                        <i class="bi bi-eye"></i>
                                                    </a>
                                                    <button class="btn btn-outline-warning move-siswa-btn"
                                                            data-siswa-id="<?= $s['id'] ?>"
                                                            data-siswa-nama="<?= htmlspecialchars($s['nama']) ?>"
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#moveSiswaModal"
                                                            title="Pindah Kelas">
                                                        <i class="bi bi-arrow-left-right"></i>
                                                    </button>
                                                    <button class="btn btn-outline-danger remove-siswa-btn"
                                                            data-siswa-id="<?= $s['id'] ?>"
                                                            data-siswa-nama="<?= htmlspecialchars($s['nama']) ?>"
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#removeSiswaModal"
                                                            title="Keluarkan dari Kelas">
                                                        <i class="bi bi-person-dash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <div class="text-center py-5">
                                <i class="bi bi-people fs-1 text-muted d-block mb-3"></i>
                                <h5 class="text-muted">Belum ada siswa di kelas ini</h5>
                                <p class="text-muted">Tambahkan siswa baru atau pindahkan siswa dari kelas lain</p>
                                <div class="btn-group">
                                    <a href="siswa.php" class="btn btn-primary">
                                        <i class="bi bi-plus-circle"></i> Tambah Siswa Baru
                                    </a>
                                    <button class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#moveSiswaModal">
                                        <i class="bi bi-arrow-left-right"></i> Pindahkan Siswa
                                    </button>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Quick Stats -->
                <div class="row mt-4">
                    <div class="col-md-3">
                        <div class="card bg-primary text-white">
                            <div class="card-body text-center py-3">
                                <h4 class="mb-0"><?= count($siswa) ?></h4>
                                <small>Total Siswa</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-success text-white">
                            <div class="card-body text-center py-3">
                                <h4 class="mb-0"><?= $kelas['kapasitas'] - count($siswa) ?></h4>
                                <small>Kursi Kosong</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-info text-white">
                            <div class="card-body text-center py-3">
                                <h4 class="mb-0"><?= $kelas['kapasitas'] ?></h4>
                                <small>Kapasitas</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-warning text-white">
                            <div class="card-body text-center py-3">
                                <h4 class="mb-0"><?= round((count($siswa) / $kelas['kapasitas']) * 100) ?>%</h4>
                                <small>Terisi</small>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <!-- Move Siswa Modal -->
    <div class="modal fade" id="moveSiswaModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST">
                    <input type="hidden" name="siswa_id" id="move_siswa_id">
                    <div class="modal-header">
                        <h5 class="modal-title">Pindahkan Siswa ke Kelas Lain</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-info">
                            Siswa: <strong id="move_siswa_nama">-</strong><br>
                            Dari: <strong><?= htmlspecialchars($kelas['nama_kelas']) ?></strong>
                        </div>
                        
                        <div class="mb-3">
                            <label for="new_kelas_id" class="form-label">Pindah ke Kelas:</label>
                            <select class="form-select" id="new_kelas_id" name="new_kelas_id" required>
                                <option value="">Pilih Kelas Tujuan</option>
                                <?php 
                                $otherKelas = array_filter($allKelasForMove, function($k) use ($kelasId) {
                                    return $k['id'] != $kelasId;
                                });
                                foreach ($otherKelas as $k): 
                                    $tahunKelas = $adminModel->getTahunAjaranById($k['tahun_ajaran_id']);
                                ?>
                                <option value="<?= $k['id'] ?>">
                                    <?= htmlspecialchars($k['nama_kelas']) ?> (Kelas <?= $k['tingkat'] ?>)
                                    - <?= $k['total_siswa'] ?>/<?= $k['kapasitas'] ?> siswa
                                    <?php if ($tahunKelas): ?>
                                    - TA: <?= $tahunKelas['tahun_ajaran'] ?> - <?= ucfirst($tahunKelas['semester']) ?>
                                    <?php endif; ?>
                                </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div class="alert alert-warning small">
                            <i class="bi bi-lightbulb"></i> 
                            Siswa akan dipindahkan ke kelas baru dan riwayat kelas akan diperbarui.
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" name="move_siswa" class="btn btn-primary">Pindahkan Siswa</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Remove Siswa Modal -->
    <div class="modal fade" id="removeSiswaModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST">
                    <input type="hidden" name="siswa_id" id="remove_siswa_id">
                    <div class="modal-header">
                        <h5 class="modal-title text-danger">Keluarkan Siswa dari Kelas</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-danger">
                            <i class="bi bi-exclamation-triangle"></i>
                            <strong>PERHATIAN:</strong> Tindakan ini akan mengeluarkan siswa dari kelas!
                        </div>
                        <p>Anda akan mengeluarkan: <strong id="remove_siswa_nama">-</strong></p>
                        <p>Dari kelas: <strong><?= htmlspecialchars($kelas['nama_kelas']) ?></strong></p>
                        
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="confirmRemove">
                            <label class="form-check-label" for="confirmRemove">
                                Saya yakin ingin mengeluarkan siswa ini dari kelas
                            </label>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" name="remove_siswa" class="btn btn-danger" id="removeConfirmBtn" disabled>
                            <i class="bi bi-person-dash"></i> Keluarkan Siswa
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Move Siswa functionality
        document.querySelectorAll('.move-siswa-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                const siswaId = this.getAttribute('data-siswa-id');
                const siswaNama = this.getAttribute('data-siswa-nama');
                
                document.getElementById('move_siswa_id').value = siswaId;
                document.getElementById('move_siswa_nama').textContent = siswaNama;
            });
        });

        // Remove Siswa functionality
        document.querySelectorAll('.remove-siswa-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                const siswaId = this.getAttribute('data-siswa-id');
                const siswaNama = this.getAttribute('data-siswa-nama');
                
                document.getElementById('remove_siswa_id').value = siswaId;
                document.getElementById('remove_siswa_nama').textContent = siswaNama;
            });
        });

        // Remove confirmation checkbox
        document.getElementById('confirmRemove').addEventListener('change', function() {
            document.getElementById('removeConfirmBtn').disabled = !this.checked;
        });

        // Reset remove confirmation when modal is closed
        document.getElementById('removeSiswaModal').addEventListener('hidden.bs.modal', function () {
            document.getElementById('confirmRemove').checked = false;
            document.getElementById('removeConfirmBtn').disabled = true;
        });
    </script>
</body>
</html>