<?php
require_once __DIR__ . '/../../app/config/config.php';
Session::checkAuth();
Session::checkRole(['admin']);

$kelasId = intval($_GET['id'] ?? 0);
if ($kelasId == 0) {
    Helper::redirect('kelas.php');
}

$adminModel = new AdminModel();
$kelas = $adminModel->getKelasById($kelasId);
if (!$kelas) {
    Helper::redirect('kelas.php');
}

$tahunAktif = $adminModel->getActiveTahunAjaran();
$mapelKelas = $tahunAktif ? $adminModel->getMapelByKelas($kelasId, $tahunAktif['id']) : [];
$allMapel = $adminModel->getAllMapel();
$guru = $adminModel->getAllGuru();

$success = $_GET['success'] ?? '';
$error = '';

// Handle assign mapel to class
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['assign_mapel'])) {
    if (!$tahunAktif) {
        $error = "Tidak ada tahun ajaran aktif!";
    } else {
        $data = [
            'guru_id' => intval($_POST['guru_id']),
            'mapel_id' => intval($_POST['mapel_id']),
            'kelas_id' => $kelasId,
            'tahun_ajaran_id' => $tahunAktif['id']
        ];
        
        if ($adminModel->assignGuruMapel($data)) {
            Helper::redirect("kelas_mapel.php?id=$kelasId&success=1");
        } else {
            $error = "Gagal menugaskan mapel! Penugasan mungkin sudah ada.";
        }
    }
}

// Handle remove mapel assignment
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['remove_mapel'])) {
    $assignmentId = intval($_POST['assignment_id']);
    if ($adminModel->removeGuruMapel($assignmentId)) {
        Helper::redirect("kelas_mapel.php?id=$kelasId&success=2");
    } else {
        $error = "Gagal menghapus penugasan mapel!";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mata Pelajaran Kelas <?= htmlspecialchars($kelas['nama_kelas']) ?> - Sistem Penilaian</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body>
    <?php include __DIR__ . '/includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include __DIR__ . '/includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <!-- Header -->
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <div>
                        <h1 class="h2">
                            <i class="bi bi-journal-text"></i>
                            Mata Pelajaran Kelas <?= htmlspecialchars($kelas['nama_kelas']) ?>
                        </h1>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="kelas.php">Kelas</a></li>
                                <li class="breadcrumb-item active"><?= htmlspecialchars($kelas['nama_kelas']) ?></li>
                            </ol>
                        </nav>
                    </div>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <a href="kelas.php" class="btn btn-secondary me-2">
                            <i class="bi bi-arrow-left"></i> Kembali
                        </a>
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#assignMapelModal">
                            <i class="bi bi-plus-circle"></i> Tambah Mapel
                        </button>
                    </div>
                </div>

                <?php if ($success == '1'): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        Mata pelajaran berhasil ditugaskan!
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php elseif ($success == '2'): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        Penugasan mapel berhasil dihapus!
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php if ($error): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?= $error ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php if (!$tahunAktif): ?>
                <div class="alert alert-warning">
                    <i class="bi bi-exclamation-triangle"></i> 
                    Tidak ada tahun ajaran yang aktif. Silakan aktifkan tahun ajaran terlebih dahulu.
                </div>
                <?php endif; ?>

                <!-- Class Info -->
				<!-- Class Info -->
				<div class="row mb-4">
					<div class="col-12">
						<div class="card">
							<div class="card-body">
								<div class="row align-items-center">
									<div class="col-md-6">
										<h5 class="card-title"><?= htmlspecialchars($kelas['nama_kelas']) ?></h5>
										<p class="card-text mb-0">
											<strong>Tingkat:</strong> Kelas <?= $kelas['tingkat'] ?> |
											<strong>Jurusan:</strong> <?= $kelas['jurusan'] ? htmlspecialchars($kelas['jurusan']) : 'Umum' ?> |
											<strong>Siswa:</strong> <?= $kelas['total_siswa'] ?> siswa |
											<strong>Kapasitas:</strong> <?= $kelas['total_siswa'] ?>/<?= $kelas['kapasitas'] ?>
										</p>
									</div>
									<div class="col-md-6 text-end">
										<?php if ($tahunAktif): ?>
										<span class="badge bg-success fs-6">
											<?= $tahunAktif['tahun_ajaran'] ?> - <?= ucfirst($tahunAktif['semester']) ?>
										</span>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

                <!-- Mapel Cards -->
                <div class="row">
                    <?php if (!empty($mapelKelas)): ?>
                        <?php foreach ($mapelKelas as $mk): ?>
                        <div class="col-xl-4 col-lg-6 mb-4">
                            <div class="card h-100">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h6 class="card-title mb-0">
                                        <i class="bi bi-journal-text text-primary"></i>
                                        <?= htmlspecialchars($mk['kode_mapel']) ?>
                                    </h6>
                                    <form method="POST" class="d-inline">
                                        <input type="hidden" name="assignment_id" value="<?= $mk['id'] ?>">
                                        <button type="submit" name="remove_mapel" 
                                                class="btn btn-sm btn-outline-danger"
                                                onclick="return confirm('Hapus penugasan <?= htmlspecialchars($mk['nama_mapel']) ?>?')">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </div>
                                <div class="card-body">
                                    <h5 class="card-title"><?= htmlspecialchars($mk['nama_mapel']) ?></h5>
                                    
                                    <div class="mb-3">
                                        <small class="text-muted">Pengajar:</small>
                                        <div class="fw-bold">
                                            <i class="bi bi-person"></i>
                                            <?= htmlspecialchars($mk['nama_guru']) ?>
                                        </div>
                                        <small class="text-muted">NIP: <?= htmlspecialchars($mk['nip']) ?></small>
                                    </div>
                                    
                                    <div class="mb-2">
                                        <small class="text-muted">Kelas:</small>
                                        <span class="badge bg-info"><?= htmlspecialchars($mk['nama_kelas']) ?></span>
                                    </div>
                                    
                                    <div class="mb-2">
                                        <small class="text-muted">Tahun Ajaran:</small>
                                        <span class="badge bg-secondary">
                                            <?= htmlspecialchars($mk['tahun_ajaran']) ?> - <?= ucfirst($mk['tahun_semester']) ?>
                                        </span>
                                    </div>
                                </div>
                                <div class="card-footer bg-transparent">
                                    <div class="btn-group w-100">
                                        <a href="nilai_kelas.php?kelas_id=<?= $kelasId ?>&mapel_id=<?= $mk['mapel_id'] ?>" 
                                           class="btn btn-sm btn-outline-primary">
                                            <i class="bi bi-clipboard-data"></i> Nilai
                                        </a>
                                        <a href="tujuan_pembelajaran.php?mapel_id=<?= $mk['mapel_id'] ?>" 
                                           class="btn btn-sm btn-outline-info">
                                            <i class="bi bi-list-task"></i> TP
                                        </a>
                                        <button class="btn btn-sm btn-outline-warning">
                                            <i class="bi bi-pencil"></i> Edit
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body text-center py-5">
                                    <i class="bi bi-journal-x fs-1 text-muted d-block mb-3"></i>
                                    <h5 class="text-muted">Belum ada mata pelajaran</h5>
                                    <p class="text-muted">Tambahkan mata pelajaran untuk kelas ini</p>
                                    <?php if ($tahunAktif): ?>
                                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#assignMapelModal">
                                        <i class="bi bi-plus-circle"></i> Tambah Mapel Pertama
                                    </button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Summary -->
                <div class="row mt-4">
                    <div class="col-md-4">
                        <div class="card bg-primary text-white">
                            <div class="card-body text-center py-3">
                                <h4 class="mb-0"><?= count($mapelKelas) ?></h4>
                                <small>Total Mapel</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card bg-success text-white">
                            <div class="card-body text-center py-3">
                                <h4 class="mb-0">
                                    <?= count(array_unique(array_column($mapelKelas, 'guru_id'))) ?>
                                </h4>
                                <small>Guru Pengajar</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card bg-info text-white">
                            <div class="card-body text-center py-3">
                                <h4 class="mb-0"><?= count($allMapel) ?></h4>
                                <small>Mapel Tersedia</small>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <!-- Assign Mapel Modal -->
    <div class="modal fade" id="assignMapelModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST">
                    <div class="modal-header">
                        <h5 class="modal-title">Tugaskan Mata Pelajaran</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <?php if ($tahunAktif): ?>
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle"></i>
                            Tahun Ajaran: <strong><?= $tahunAktif['tahun_ajaran'] ?></strong><br>
                            Kelas: <strong><?= htmlspecialchars($kelas['nama_kelas']) ?></strong>
                        </div>
                        
                        <div class="mb-3">
                            <label for="mapel_id" class="form-label">Mata Pelajaran</label>
                            <select class="form-select" id="mapel_id" name="mapel_id" required>
                                <option value="">Pilih Mata Pelajaran</option>
                                <?php foreach ($allMapel as $m): ?>
                                <option value="<?= $m['id'] ?>">
                                    <?= htmlspecialchars($m['kode_mapel']) ?> - <?= htmlspecialchars($m['nama_mapel']) ?>
                                </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="guru_id" class="form-label">Guru Pengajar</label>
                            <select class="form-select" id="guru_id" name="guru_id" required>
                                <option value="">Pilih Guru</option>
                                <?php foreach ($guru as $g): ?>
                                <option value="<?= $g['id'] ?>">
                                    <?= htmlspecialchars($g['nama']) ?> (<?= htmlspecialchars($g['nip']) ?>)
                                </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div class="alert alert-warning small">
                            <i class="bi bi-lightbulb"></i> 
                            Pastikan guru yang dipilih kompeten dalam mata pelajaran tersebut.
                        </div>
                        <?php else: ?>
                        <div class="alert alert-warning">
                            <i class="bi bi-exclamation-triangle"></i>
                            Tidak dapat menambah penugasan karena tidak ada tahun ajaran aktif.
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <?php if ($tahunAktif): ?>
                        <button type="submit" name="assign_mapel" class="btn btn-primary">Simpan Penugasan</button>
                        <?php endif; ?>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>