<?php
require_once __DIR__ . '/../../app/config/config.php';
Session::checkAuth();
Session::checkRole(['admin']);

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_kelas'])) {
    $adminModel = new AdminModel();
    
    $data = [
        'nama_kelas' => Helper::sanitize($_POST['nama_kelas']),
        'tingkat' => intval($_POST['tingkat']),
        'jurusan' => Helper::sanitize($_POST['jurusan'] ?? ''),
        'kapasitas' => intval($_POST['kapasitas'])
    ];
    
    if ($adminModel->addKelas($data)) {
        Helper::redirect('kelas.php?success=1');
    } else {
        Helper::redirect('kelas.php?error=' . urlencode('Gagal menambah kelas!'));
    }
} else {
    Helper::redirect('kelas.php');
}
?>