<?php
require_once __DIR__ . '/../../app/config/config.php';
Session::checkAuth();
Session::checkRole(['admin']);

$adminModel = new AdminModel();
$kelas = $adminModel->getAllKelas();
$tahunAktif = $adminModel->getActiveTahunAjaran();
$guru = $adminModel->getAllGuru();

$success = $_GET['success'] ?? '';
$error = '';
$editMode = false;
$editData = [];

// Error reporting untuk debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/../../app/config/config.php';
Session::checkAuth();
Session::checkRole(['admin']);

try {
    $adminModel = new AdminModel();
    $kelas = $adminModel->getAllKelas();
    $tahunAktif = $adminModel->getActiveTahunAjaran();
    $guru = $adminModel->getAllGuru();
    $allKelasForMove = $adminModel->getAllKelasWithoutFilter(); // Untuk form pindah siswa
} catch (Exception $e) {
    error_log("Error loading data: " . $e->getMessage());
    $kelas = [];
    $tahunAktif = false;
    $guru = [];
    $allKelasForMove = [];
}

$success = $_GET['success'] ?? '';
$error = $_GET['error'] ?? '';
$editMode = false;
$editData = [];

// Handle form submission - Add Kelas
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_kelas'])) {
    try {
        $data = [
            'nama_kelas' => trim(Helper::sanitize($_POST['nama_kelas'])),
            'tingkat' => intval($_POST['tingkat']),
            'jurusan' => trim(Helper::sanitize($_POST['jurusan'] ?? '')),
            'kapasitas' => intval($_POST['kapasitas'])
        ];
        
        // Validasi input
        if (empty($data['nama_kelas']) || empty($data['tingkat'])) {
            $error = "Nama kelas dan tingkat harus diisi!";
        } elseif ($data['kapasitas'] < 20 || $data['kapasitas'] > 40) {
            $error = "Kapasitas harus antara 20-40 siswa!";
        } else {
            // Cek apakah kelas sudah ada
            $existingKelas = $adminModel->getKelasByNama($data['nama_kelas']);
            if ($existingKelas) {
                $error = "Kelas dengan nama '{$data['nama_kelas']}' sudah ada!";
            } else {
                $result = $adminModel->addKelas($data);
                if ($result) {
                    Helper::redirect('kelas.php?success=1');
                } else {
                    $error = "Gagal menambah kelas! Silakan coba lagi.";
                }
            }
        }
    } catch (Exception $e) {
        error_log("Add kelas error: " . $e->getMessage());
        $error = "Terjadi kesalahan sistem. Silakan coba lagi.";
    }
}

// Handle form submission - Edit Kelas
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['edit_kelas'])) {
    $kelasId = intval($_POST['kelas_id']);
    $data = [
        'nama_kelas' => trim(Helper::sanitize($_POST['nama_kelas'])),
        'tingkat' => intval($_POST['tingkat']),
        'jurusan' => trim(Helper::sanitize($_POST['jurusan'] ?? '')),
        'kapasitas' => intval($_POST['kapasitas'])
    ];
    
    // Validasi untuk edit
    if (empty($data['nama_kelas']) || empty($data['tingkat'])) {
        $error = "Nama kelas dan tingkat harus diisi!";
    } elseif ($data['kapasitas'] < 20 || $data['kapasitas'] > 40) {
        $error = "Kapasitas harus antara 20-40 siswa!";
    } else {
        // Cek duplikasi nama kelas (kecuali untuk kelas yang sedang diedit)
        $existingKelas = $adminModel->getKelasByNama($data['nama_kelas']);
        if ($existingKelas && $existingKelas['id'] != $kelasId) {
            $error = "Kelas dengan nama '{$data['nama_kelas']}' sudah ada!";
        } else {
            if ($adminModel->updateKelas($kelasId, $data)) {
                Helper::redirect('kelas.php?success=2');
            } else {
                $error = "Gagal mengupdate kelas! Silakan coba lagi.";
            }
        }
    }
}

// Handle delete kelas
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['delete_kelas'])) {
    $kelasId = intval($_POST['kelas_id']);
    if ($adminModel->deleteKelas($kelasId)) {
        Helper::redirect('kelas.php?success=3');
    } else {
        $error = "Gagal menghapus kelas! Kelas mungkin masih memiliki siswa atau data terkait.";
    }
}

// Handle set wali kelas
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['set_wali_kelas'])) {
    if (!$tahunAktif) {
        $error = "Tidak ada tahun ajaran aktif!";
    } else {
        $data = [
            'guru_id' => intval($_POST['guru_id']),
            'kelas_id' => intval($_POST['kelas_id']),
            'tahun_ajaran_id' => $tahunAktif['id'],
            'semester' => $tahunAktif['semester']
        ];
        
        if ($adminModel->assignWaliKelas($data)) {
            Helper::redirect('kelas.php?success=4');
        } else {
            $error = "Gagal menugaskan wali kelas! Guru mungkin sudah menjadi wali kelas di kelas lain.";
        }
    }
}

// Check if edit mode
if (isset($_GET['edit'])) {
    $kelasId = intval($_GET['edit']);
    $editData = $adminModel->getKelasById($kelasId);
    if ($editData) {
        $editMode = true;
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manajemen Kelas - Sistem Penilaian SMP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        .class-card {
            transition: transform 0.2s, box-shadow 0.2s;
        }
        .class-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.15);
        }
        .capacity-bar {
            height: 6px;
            background-color: #e9ecef;
            border-radius: 3px;
            overflow: hidden;
        }
        .capacity-fill {
            height: 100%;
            border-radius: 3px;
            transition: width 0.3s;
        }
        .wali-kelas-badge {
            font-size: 0.7em;
        }
        .form-label.required::after {
            content: " *";
            color: #dc3545;
        }
        .tahun-ajaran-badge {
            font-size: 0.7em;
            margin-left: 5px;
        }
    </style>
</head>
<body>
    <?php include __DIR__ . '/includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include __DIR__ . '/includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Manajemen Kelas SMP</h1>
                    <div>
                        <?php if ($tahunAktif): ?>
                        <span class="badge bg-info me-2">
                            TA: <?= $tahunAktif['tahun_ajaran'] ?> - <?= ucfirst($tahunAktif['semester']) ?>
                        </span>
                        <?php endif; ?>
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="<?= $editMode ? '#editKelasModal' : '#addKelasModal' ?>">
                            <i class="bi bi-plus-circle"></i> <?= $editMode ? 'Edit Kelas' : 'Tambah Kelas' ?>
                        </button>
                        <?php if ($editMode): ?>
                        <a href="kelas.php" class="btn btn-secondary">
                            <i class="bi bi-x-circle"></i> Batal Edit
                        </a>
                        <?php endif; ?>
                    </div>
                </div>

                <?php if ($success == '1'): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle"></i> Kelas berhasil ditambahkan!
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php elseif ($success == '2'): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle"></i> Kelas berhasil diupdate!
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php elseif ($success == '3'): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle"></i> Kelas berhasil dihapus!
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php elseif ($success == '4'): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle"></i> Wali kelas berhasil ditugaskan!
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php if ($error): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="bi bi-exclamation-triangle"></i> <?= $error ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <!-- Info Tahun Ajaran -->
                <?php if ($tahunAktif): ?>
                <div class="alert alert-info">
                    <i class="bi bi-info-circle"></i>
                    <strong>Informasi:</strong> Menampilkan kelas untuk Tahun Ajaran <strong><?= $tahunAktif['tahun_ajaran'] ?></strong> Semester <strong><?= ucfirst($tahunAktif['semester']) ?></strong>
                </div>
                <?php else: ?>
                <div class="alert alert-warning">
                    <i class="bi bi-exclamation-triangle"></i>
                    <strong>Peringatan:</strong> Tidak ada tahun ajaran aktif. Silakan aktifkan tahun ajaran terlebih dahulu.
                </div>
                <?php endif; ?>

                <!-- Filter by Tingkat -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body py-2">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="text-muted">Filter by Tingkat:</span>
                                    <div class="btn-group btn-group-sm">
                                        <button type="button" class="btn btn-outline-primary active filter-btn" data-tingkat="all">
                                            Semua
                                        </button>
                                        <button type="button" class="btn btn-outline-primary filter-btn" data-tingkat="7">
                                            Kelas 7
                                        </button>
                                        <button type="button" class="btn btn-outline-primary filter-btn" data-tingkat="8">
                                            Kelas 8
                                        </button>
                                        <button type="button" class="btn btn-outline-primary filter-btn" data-tingkat="9">
                                            Kelas 9
                                        </button>
                                    </div>
                                    <span class="text-muted">
                                        Total: <?= count($kelas) ?> kelas
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Kelas Cards -->
                <div class="row" id="kelasContainer">
					<?php if (!empty($kelas)): ?>
						<?php foreach ($kelas as $k): 
							// Hitung persentase kapasitas
							$percentage = $k['kapasitas'] > 0 ? min(100, ($k['total_siswa'] / $k['kapasitas']) * 100) : 0;
							$barColor = $percentage >= 90 ? 'bg-danger' : ($percentage >= 70 ? 'bg-warning' : 'bg-success');
							$waliKelas = $tahunAktif ? $adminModel->getWaliKelasByKelas($k['id'], $tahunAktif['id']) : false;
							
							// Dapatkan tahun ajaran kelas
							$tahunKelas = $adminModel->getTahunAjaranById($k['tahun_ajaran_id']);
						?>
						<div class="col-xl-4 col-lg-6 mb-4 kelas-item" data-tingkat="<?= $k['tingkat'] ?>">
							<div class="card class-card h-100 border-<?= $k['tingkat'] == 7 ? 'primary' : ($k['tingkat'] == 8 ? 'success' : 'warning') ?>">
								<div class="card-header d-flex justify-content-between align-items-center bg-<?= $k['tingkat'] == 7 ? 'primary' : ($k['tingkat'] == 8 ? 'success' : 'warning') ?> text-white">
									<h5 class="card-title mb-0">
										<i class="bi bi-house-door"></i>
										<?= htmlspecialchars($k['nama_kelas']) ?>
									</h5>
									<div>
										<span class="badge bg-light text-dark">Kelas <?= $k['tingkat'] ?></span>
									</div>
								</div>
								<div class="card-body">
									<!-- Tahun Ajaran Info -->
									<div class="mb-2">
										<small class="text-muted">
											<i class="bi bi-calendar"></i>
											Tahun Ajaran: 
											<?php if ($tahunKelas): ?>
												<span class="badge bg-secondary tahun-ajaran-badge">
													<?= $tahunKelas['tahun_ajaran'] ?> - <?= ucfirst($tahunKelas['semester']) ?>
												</span>
											<?php else: ?>
												<span class="badge bg-warning tahun-ajaran-badge">Tidak diketahui</span>
											<?php endif; ?>
										</small>
									</div>

									<!-- Wali Kelas Info -->
									<?php if ($waliKelas): ?>
									<div class="alert alert-info py-2 mb-3">
										<div class="d-flex align-items-center">
											<i class="bi bi-person-check me-2"></i>
											<div>
												<strong class="small">Wali Kelas:</strong><br>
												<span class="small"><?= htmlspecialchars($waliKelas['nama_guru']) ?></span>
											</div>
										</div>
									</div>
									<?php else: ?>
									<div class="alert alert-warning py-2 mb-3">
										<div class="d-flex align-items-center justify-content-between">
											<div>
												<i class="bi bi-person-x me-1"></i>
												<span class="small">Belum ada wali kelas</span>
											</div>
											<button class="btn btn-sm btn-outline-primary set-wali-btn"
													data-kelas-id="<?= $k['id'] ?>"
													data-kelas-nama="<?= htmlspecialchars($k['nama_kelas']) ?>"
													data-bs-toggle="modal" 
													data-bs-target="#setWaliModal">
												<i class="bi bi-person-plus"></i>
											</button>
										</div>
									</div>
									<?php endif; ?>
									
									<div class="mb-3">
										<small class="text-muted">Jurusan:</small>
										<div class="fw-bold"><?= $k['jurusan'] ? htmlspecialchars($k['jurusan']) : '<span class="text-muted">Umum</span>' ?></div>
									</div>
									
									<!-- Kapasitas dengan data real dari database -->
									<div class="mb-3">
										<small class="text-muted">Kapasitas:</small>
										<div class="d-flex align-items-center">
											<div class="flex-grow-1 me-2">
												<div class="capacity-bar">
													<div class="capacity-fill <?= $barColor ?>" 
														 style="width: <?= $percentage ?>%"></div>
												</div>
											</div>
											<small class="text-muted">
												<?= $k['total_siswa'] ?>/<?= $k['kapasitas'] ?>
												(<?= round($percentage) ?>%)
											</small>
										</div>
									</div>
									
									<!-- Statistik Siswa -->
									<div class="row text-center">
										<div class="col-6">
											<div class="border-end">
												<div class="h4 mb-0 text-primary"><?= $k['total_siswa'] ?></div>
												<small class="text-muted">Siswa</small>
											</div>
										</div>
										<div class="col-6">
											<div class="h4 mb-0 text-success"><?= $k['kapasitas'] - $k['total_siswa'] ?></div>
											<small class="text-muted">Kosong</small>
										</div>
									</div>
								</div>
								<div class="card-footer bg-transparent">
									<div class="btn-group w-100">
										<a href="?edit=<?= $k['id'] ?>" class="btn btn-sm btn-outline-primary">
											<i class="bi bi-pencil"></i> Edit
										</a>
										<a href="kelas_siswa.php?id=<?= $k['id'] ?>" 
										   class="btn btn-sm btn-outline-info">
											<i class="bi bi-people"></i> Siswa
										</a>
										<a href="kelas_mapel.php?id=<?= $k['id'] ?>" 
										   class="btn btn-sm btn-outline-warning">
											<i class="bi bi-journal-text"></i> Mapel
										</a>
										<button class="btn btn-sm btn-outline-danger delete-kelas-btn"
												data-kelas-id="<?= $k['id'] ?>"
												data-kelas-nama="<?= htmlspecialchars($k['nama_kelas']) ?>">
											<i class="bi bi-trash"></i>
										</button>
									</div>
								</div>
							</div>
						</div>
						<?php endforeach; ?>
                    <?php else: ?>
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body text-center py-5">
                                    <i class="bi bi-house-door fs-1 text-muted d-block mb-3"></i>
                                    <h5 class="text-muted">Belum ada data kelas</h5>
                                    <p class="text-muted">Tambahkan kelas pertama Anda untuk memulai</p>
                                    <?php if ($tahunAktif): ?>
                                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addKelasModal">
                                        <i class="bi bi-plus-circle"></i> Tambah Kelas Pertama
                                    </button>
                                    <?php else: ?>
                                    <div class="alert alert-warning">
                                        Tidak dapat menambah kelas karena tidak ada tahun ajaran aktif.
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
				
                <!-- Summary -->
                <div class="row mt-4">
                    <?php
                    $kelas7 = array_filter($kelas, fn($k) => $k['tingkat'] == 7);
                    $kelas8 = array_filter($kelas, fn($k) => $k['tingkat'] == 8);
                    $kelas9 = array_filter($kelas, fn($k) => $k['tingkat'] == 9);
                    ?>
                    <div class="col-md-3">
                        <div class="card bg-primary text-white">
                            <div class="card-body text-center">
                                <h4 class="mb-0"><?= count($kelas) ?></h4>
                                <small>Total Kelas</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-info text-white">
                            <div class="card-body text-center">
                                <h4 class="mb-0"><?= count($kelas7) ?></h4>
                                <small>Kelas 7</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-success text-white">
                            <div class="card-body text-center">
                                <h4 class="mb-0"><?= count($kelas8) ?></h4>
                                <small>Kelas 8</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-warning text-white">
                            <div class="card-body text-center">
                                <h4 class="mb-0"><?= count($kelas9) ?></h4>
                                <small>Kelas 9</small>
                            </div>
                        </div>
                    </div>
                </div>
				
				<!-- Student Summary -->

                <!-- Student Summary -->
				<!-- Student Summary -->
				<div class="row mt-3">
					<div class="col-12">
						<div class="card">
							<div class="card-header">
								<h6 class="mb-0">Statistik Siswa per Tingkat</h6>
							</div>
							<div class="card-body">
								<div class="row text-center">
									<div class="col-md-4">
										<h3 class="text-primary"><?= array_sum(array_column($kelas7, 'total_siswa')) ?></h3>
										<small class="text-muted">Siswa Kelas 7</small>
									</div>
									<div class="col-md-4">
										<h3 class="text-success"><?= array_sum(array_column($kelas8, 'total_siswa')) ?></h3>
										<small class="text-muted">Siswa Kelas 8</small>
									</div>
									<div class="col-md-4">
										<h3 class="text-warning"><?= array_sum(array_column($kelas9, 'total_siswa')) ?></h3>
										<small class="text-muted">Siswa Kelas 9</small>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>			
            </main>
        </div>
    </div>

    <!-- Add Kelas Modal -->
    <div class="modal fade" id="addKelasModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST">
                    <div class="modal-header">
                        <h5 class="modal-title">Tambah Kelas Baru</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <?php if ($tahunAktif): ?>
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle"></i>
                            Tahun Ajaran: <strong><?= $tahunAktif['tahun_ajaran'] ?> - <?= ucfirst($tahunAktif['semester']) ?></strong>
                        </div>
                        
                        <div class="mb-3">
                            <label for="nama_kelas" class="form-label required">Nama Kelas</label>
                            <input type="text" class="form-control" id="nama_kelas" name="nama_kelas" required
                                   placeholder="Contoh: VII A, VIII B, IX C" maxlength="20">
                            <div class="form-text">Nama kelas harus unik untuk tahun ajaran ini</div>
                        </div>
                        <div class="mb-3">
                            <label for="tingkat" class="form-label required">Tingkat</label>
                            <select class="form-select" id="tingkat" name="tingkat" required>
                                <option value="">Pilih Tingkat</option>
                                <option value="7">Kelas 7</option>
                                <option value="8">Kelas 8</option>
                                <option value="9">Kelas 9</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="jurusan" class="form-label">Jurusan/Peminatan</label>
                            <select class="form-select" id="jurusan" name="jurusan">
                                <option value="">Umum (Reguler)</option>
                                <option value="A">Peminatan A</option>
                                <option value="B">Peminatan B</option>
                                <option value="C">Peminatan C</option>
                                <option value="IPS">IPS</option>
                                <option value="IPA">IPA</option>
                            </select>
                            <div class="form-text">Pilih jurusan/peminatan jika ada</div>
                        </div>
                        <div class="mb-3">
                            <label for="kapasitas" class="form-label required">Kapasitas Siswa</label>
                            <input type="number" class="form-control" id="kapasitas" name="kapasitas" 
                                   value="32" min="20" max="40" required>
                            <div class="form-text">Jumlah maksimal siswa dalam kelas (20-40)</div>
                        </div>
                        <?php else: ?>
                        <div class="alert alert-warning">
                            <i class="bi bi-exclamation-triangle"></i>
                            Tidak dapat menambah kelas karena tidak ada tahun ajaran aktif.
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <?php if ($tahunAktif): ?>
                        <button type="submit" name="add_kelas" class="btn btn-primary">Simpan Kelas</button>
                        <?php endif; ?>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Kelas Modal -->
    <?php if ($editMode && $editData): ?>
    <div class="modal fade" id="editKelasModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST">
                    <input type="hidden" name="kelas_id" value="<?= $editData['id'] ?>">
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Kelas - <?= htmlspecialchars($editData['nama_kelas']) ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <?php if ($tahunAktif): ?>
                        <div class="mb-3">
                            <label for="edit_nama_kelas" class="form-label required">Nama Kelas</label>
                            <input type="text" class="form-control" id="edit_nama_kelas" name="nama_kelas" required
                                   value="<?= htmlspecialchars($editData['nama_kelas']) ?>"
                                   placeholder="Contoh: VII A, VIII B, IX C" maxlength="20">
                            <div class="form-text">Nama kelas harus unik untuk tahun ajaran ini</div>
                        </div>
                        <div class="mb-3">
                            <label for="edit_tingkat" class="form-label required">Tingkat</label>
                            <select class="form-select" id="edit_tingkat" name="tingkat" required>
                                <option value="">Pilih Tingkat</option>
                                <option value="7" <?= $editData['tingkat'] == 7 ? 'selected' : '' ?>>Kelas 7</option>
                                <option value="8" <?= $editData['tingkat'] == 8 ? 'selected' : '' ?>>Kelas 8</option>
                                <option value="9" <?= $editData['tingkat'] == 9 ? 'selected' : '' ?>>Kelas 9</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="edit_jurusan" class="form-label">Jurusan/Peminatan</label>
                            <select class="form-select" id="edit_jurusan" name="jurusan">
                                <option value="">Umum (Reguler)</option>
                                <option value="A" <?= $editData['jurusan'] == 'A' ? 'selected' : '' ?>>Peminatan A</option>
                                <option value="B" <?= $editData['jurusan'] == 'B' ? 'selected' : '' ?>>Peminatan B</option>
                                <option value="C" <?= $editData['jurusan'] == 'C' ? 'selected' : '' ?>>Peminatan C</option>
                                <option value="IPS" <?= $editData['jurusan'] == 'IPS' ? 'selected' : '' ?>>IPS</option>
                                <option value="IPA" <?= $editData['jurusan'] == 'IPA' ? 'selected' : '' ?>>IPA</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="edit_kapasitas" class="form-label required">Kapasitas Siswa</label>
                            <input type="number" class="form-control" id="edit_kapasitas" name="kapasitas" 
                                   value="<?= $editData['kapasitas'] ?>" min="20" max="40" required>
                            <div class="form-text">
                                Saat ini: <?= $editData['total_siswa'] ?> siswa. 
                                Kapasitas tidak bisa kurang dari jumlah siswa saat ini.
                            </div>
                        </div>
                        <?php else: ?>
                        <div class="alert alert-warning">
                            <i class="bi bi-exclamation-triangle"></i>
                            Tidak dapat mengedit kelas karena tidak ada tahun ajaran aktif.
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <?php if ($tahunAktif): ?>
                        <button type="submit" name="edit_kelas" class="btn btn-primary">Update Kelas</button>
                        <?php endif; ?>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Set Wali Kelas Modal -->
    <div class="modal fade" id="setWaliModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST">
                    <input type="hidden" name="kelas_id" id="set_wali_kelas_id">
                    <div class="modal-header">
                        <h5 class="modal-title">Set Wali Kelas</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <?php if ($tahunAktif): ?>
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle"></i>
                            Tahun Ajaran: <strong><?= $tahunAktif['tahun_ajaran'] ?></strong><br>
                            Kelas: <strong id="set_wali_kelas_nama">-</strong>
                        </div>
                        
                        <div class="mb-3">
                            <label for="set_wali_guru_id" class="form-label required">Pilih Guru sebagai Wali Kelas</label>
                            <select class="form-select" id="set_wali_guru_id" name="guru_id" required>
                                <option value="">Pilih Guru</option>
                                <?php foreach ($guru as $g): ?>
                                <option value="<?= $g['id'] ?>">
                                    <?= htmlspecialchars($g['nama']) ?> (<?= htmlspecialchars($g['nip']) ?>)
                                </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div class="alert alert-warning small">
                            <i class="bi bi-lightbulb"></i> 
                            <strong>Perhatian:</strong> Satu kelas hanya bisa memiliki satu wali kelas per semester.
                        </div>
                        <?php else: ?>
                        <div class="alert alert-warning">
                            <i class="bi bi-exclamation-triangle"></i>
                            Tidak dapat menambah wali kelas karena tidak ada tahun ajaran aktif.
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <?php if ($tahunAktif): ?>
                        <button type="submit" name="set_wali_kelas" class="btn btn-primary">Set Wali Kelas</button>
                        <?php endif; ?>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteKelasModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST">
                    <input type="hidden" name="kelas_id" id="delete_kelas_id">
                    <div class="modal-header">
                        <h5 class="modal-title text-danger">Hapus Kelas</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-danger">
                            <i class="bi bi-exclamation-triangle"></i>
                            <strong>PERHATIAN:</strong> Tindakan ini tidak dapat dibatalkan!
                        </div>
                        <p>Anda akan menghapus kelas: <strong id="delete_kelas_nama">-</strong></p>
                        <p class="text-muted small">
                            Data yang akan dihapus:
                            <ul class="small text-muted">
                                <li>Data kelas</li>
                                <li>Penugasan wali kelas</li>
                                <li>Penugasan guru mapel</li>
                            </ul>
                            <strong class="text-danger">Siswa dalam kelas tidak akan dihapus, tetapi akan kehilangan data kelas.</strong>
                        </p>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="confirmDelete">
                            <label class="form-check-label" for="confirmDelete">
                                Saya mengerti dan ingin menghapus kelas ini
                            </label>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" name="delete_kelas" class="btn btn-danger" id="deleteConfirmBtn" disabled>
                            <i class="bi bi-trash"></i> Hapus Kelas
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Filter functionality
        document.querySelectorAll('.filter-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                document.querySelectorAll('.filter-btn').forEach(b => {
                    b.classList.remove('active');
                });
                this.classList.add('active');
                
                const tingkat = this.getAttribute('data-tingkat');
                const kelasItems = document.querySelectorAll('.kelas-item');
                
                kelasItems.forEach(item => {
                    if (tingkat === 'all' || item.getAttribute('data-tingkat') === tingkat) {
                        item.style.display = 'block';
                    } else {
                        item.style.display = 'none';
                    }
                });
            });
        });

        // Set Wali Kelas functionality
        document.querySelectorAll('.set-wali-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                const kelasId = this.getAttribute('data-kelas-id');
                const kelasNama = this.getAttribute('data-kelas-nama');
                
                document.getElementById('set_wali_kelas_id').value = kelasId;
                document.getElementById('set_wali_kelas_nama').textContent = kelasNama;
                
                // Reset select
                document.getElementById('set_wali_guru_id').value = '';
            });
        });

        // Delete Kelas functionality
        document.querySelectorAll('.delete-kelas-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                const kelasId = this.getAttribute('data-kelas-id');
                const kelasNama = this.getAttribute('data-kelas-nama');
                
                document.getElementById('delete_kelas_id').value = kelasId;
                document.getElementById('delete_kelas_nama').textContent = kelasNama;
                
                const deleteModal = new bootstrap.Modal(document.getElementById('deleteKelasModal'));
                deleteModal.show();
            });
        });

        // Delete confirmation checkbox
        document.getElementById('confirmDelete').addEventListener('change', function() {
            document.getElementById('deleteConfirmBtn').disabled = !this.checked;
        });

        // Auto open edit modal if in edit mode
        <?php if ($editMode && $editData): ?>
        document.addEventListener('DOMContentLoaded', function() {
            const editModal = new bootstrap.Modal(document.getElementById('editKelasModal'));
            editModal.show();
        });
        <?php endif; ?>

        // Reset delete confirmation when modal is closed
        document.getElementById('deleteKelasModal').addEventListener('hidden.bs.modal', function () {
            document.getElementById('confirmDelete').checked = false;
            document.getElementById('deleteConfirmBtn').disabled = true;
        });

        // Form validation for kapasitas
        document.addEventListener('DOMContentLoaded', function() {
            const kapasitasInput = document.getElementById('kapasitas');
            if (kapasitasInput) {
                kapasitasInput.addEventListener('change', function() {
                    if (this.value < 20) this.value = 20;
                    if (this.value > 40) this.value = 40;
                });
            }

            const editKapasitasInput = document.getElementById('edit_kapasitas');
            if (editKapasitasInput) {
                editKapasitasInput.addEventListener('change', function() {
                    if (this.value < 20) this.value = 20;
                    if (this.value > 40) this.value = 40;
                });
            }
        });
    </script>
</body>
</html>