<?php
// dashboard_simple.php - Versi sederhana dulu
error_reporting(E_ALL);
ini_set('display_errors', 1);

try {
    require_once __DIR__ . '/../../app/config/config.php';
    Session::checkAuth();
    Session::checkRole(['admin']);
    
    $userData = Session::getUserData();
    
} catch (Exception $e) {
    die("ERROR: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="#">Sistem Penilaian - Admin</a>
            <div class="navbar-nav ms-auto">
                <span class="navbar-text me-3">
                    Halo, <?= $userData['nama'] ?>
                </span>
                <a class="nav-link text-white" href="../logout.php">Logout</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header bg-success text-white">
                        <h4 class="mb-0">Dashboard Admin - Simple Version</h4>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-success">
                            <h5>Login Berhasil! 🎉</h5>
                            <p>User Data:</p>
                            <pre><?php print_r($userData); ?></pre>
                        </div>
                        
                        <div class="mt-4">
                            <h5>Quick Actions:</h5>
                            <div class="d-grid gap-2 d-md-flex">
                                <a href="siswa.php" class="btn btn-primary">Siswa</a>
                                <a href="guru.php" class="btn btn-success">Guru</a>
                                <a href="kelas.php" class="btn btn-info">Kelas</a>
                                <a href="debug_admin.php" class="btn btn-warning">Debug</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>