<?php
require_once __DIR__ . '/../../app/config/config.php';
Session::checkAuth();
Session::checkRole(['admin']);

$adminModel = new AdminModel();
$userData = Session::getUserData();

// Get statistics and data
$stats = $adminModel->getSystemStats();
$tahunAktif = $adminModel->getActiveTahunAjaran();
$recentActivity = $adminModel->getRecentActivity(5);
$waliKelas = $tahunAktif ? $adminModel->getWaliKelasByTahun($tahunAktif['id']) : [];
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin - Sistem Penilaian</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        .stat-card {
            border-left: 4px solid #007bff;
            transition: transform 0.2s;
        }
        .stat-card:hover {
            transform: translateY(-2px);
        }
        .stat-card.success { border-left-color: #28a745; }
        .stat-card.info { border-left-color: #17a2b8; }
        .stat-card.warning { border-left-color: #ffc107; }
        .stat-card.teal { border-left-color: #20c997; }
        .stat-card.purple { border-left-color: #6f42c1; }
        .stat-card.pink { border-left-color: #e83e8c; }
        
        .quick-action-card {
            transition: all 0.3s ease;
            border: 1px solid #e3e6f0;
        }
        .quick-action-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.15);
            border-color: #007bff;
        }
    </style>
</head>
<body>
    <?php include __DIR__ . '/includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include __DIR__ . '/includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Dashboard Admin</h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <?php if ($tahunAktif): ?>
                        <div class="btn-group me-2">
                            <span class="btn btn-sm btn-outline-success">
                                <i class="bi bi-calendar-check"></i> 
                                <?= $tahunAktif['tahun_ajaran'] ?> - <?= ucfirst($tahunAktif['semester']) ?>
                            </span>
                        </div>
                        <?php endif; ?>
                        <span class="text-muted">
                            <i class="bi bi-clock"></i> <?= date('d F Y, H:i') ?>
                        </span>
                    </div>
                </div>

                <!-- Tahun Ajaran Info -->
                <?php if ($tahunAktif): ?>
                <div class="alert alert-info d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="alert-heading mb-1">
                            <i class="bi bi-star-fill"></i> Tahun Ajaran Aktif
                        </h6>
                        <strong class="me-2"><?= $tahunAktif['tahun_ajaran'] ?></strong>
                        <span class="badge bg-primary">Semester <?= ucfirst($tahunAktif['semester']) ?></span>
                        <small class="text-muted ms-2">
                            (<?= date('d M Y', strtotime($tahunAktif['tanggal_mulai'])) ?> - <?= date('d M Y', strtotime($tahunAktif['tanggal_selesai'])) ?>)
                        </small>
                    </div>
                    <a href="tahun_ajaran.php" class="btn btn-sm btn-outline-info">
                        Kelola Tahun Ajaran
                    </a>
                </div>
                <?php else: ?>
                <div class="alert alert-warning">
                    <i class="bi bi-exclamation-triangle"></i> 
                    <strong>Perhatian:</strong> Tidak ada tahun ajaran yang aktif. 
                    <a href="tahun_ajaran.php" class="alert-link">Aktifkan tahun ajaran</a> untuk melanjutkan operasi sistem.
                </div>
                <?php endif; ?>

                <!-- Statistics Cards -->
                <div class="row mb-4">
                    <div class="col-xl-2 col-md-4 mb-3">
                        <div class="card stat-card h-100">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                            Total Siswa</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?= $stats['total_siswa'] ?? 0 ?>
                                        </div>
                                        <small class="text-muted">Siswa aktif</small>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-people fs-4 text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <div class="card stat-card success h-100">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                            Total Guru</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?= $stats['total_guru'] ?? 0 ?>
                                        </div>
                                        <small class="text-muted"><?= $stats['guru_aktif'] ?? 0 ?> aktif</small>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-person-badge fs-4 text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <div class="card stat-card info h-100">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                            Total Kelas</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?= $stats['total_kelas'] ?? 0 ?>
                                        </div>
                                        <small class="text-muted">Kelas tersedia</small>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-house-door fs-4 text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <div class="card stat-card warning h-100">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                            Mata Pelajaran</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?= $stats['total_mapel'] ?? 0 ?>
                                        </div>
                                        <small class="text-muted">Mapel terdaftar</small>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-journal-text fs-4 text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <div class="card stat-card teal h-100">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-uppercase mb-1" style="color: #20c997;">
                                            Wali Kelas</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?= count($waliKelas) ?>
                                        </div>
                                        <small class="text-muted">dari <?= $stats['total_kelas'] ?? 0 ?> kelas</small>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-person-gear fs-4 text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <div class="card stat-card purple h-100">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-uppercase mb-1" style="color: #6f42c1;">
                                            Tahun Ajaran</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?= $tahunAktif ? $tahunAktif['tahun_ajaran'] : '-' ?>
                                        </div>
                                        <small class="text-muted"><?= $tahunAktif ? ucfirst($tahunAktif['semester']) : 'Tidak ada' ?></small>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-calendar fs-4 text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Quick Actions & Recent Activity -->
                <div class="row">
                    <div class="col-lg-8">
                        <!-- Quick Actions -->
                        <div class="card shadow mb-4">
                            <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                                <h6 class="m-0 font-weight-bold text-primary">Quick Actions</h6>
                                <small class="text-muted">Akses cepat ke fitur utama</small>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-3 mb-3">
                                        <a href="siswa.php" class="card quick-action-card text-decoration-none h-100">
                                            <div class="card-body text-center p-3">
                                                <i class="bi bi-people fs-1 text-primary mb-2"></i>
                                                <div class="fw-bold">Manajemen Siswa</div>
                                                <small class="text-muted">Kelola data siswa</small>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <a href="guru.php" class="card quick-action-card text-decoration-none h-100">
                                            <div class="card-body text-center p-3">
                                                <i class="bi bi-person-badge fs-1 text-success mb-2"></i>
                                                <div class="fw-bold">Manajemen Guru</div>
                                                <small class="text-muted">Kelola data guru</small>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <a href="kelas.php" class="card quick-action-card text-decoration-none h-100">
                                            <div class="card-body text-center p-3">
                                                <i class="bi bi-house-door fs-1 text-info mb-2"></i>
                                                <div class="fw-bold">Manajemen Kelas</div>
                                                <small class="text-muted">Kelola ruang kelas</small>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <a href="wali_kelas.php" class="card quick-action-card text-decoration-none h-100">
                                            <div class="card-body text-center p-3">
                                                <i class="bi bi-person-gear fs-1 text-teal mb-2"></i>
                                                <div class="fw-bold">Wali Kelas</div>
                                                <small class="text-muted">Penugasan wali kelas</small>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                                <div class="row mt-2">
                                    <div class="col-md-3 mb-3">
                                        <a href="assignment.php" class="card quick-action-card text-decoration-none h-100">
                                            <div class="card-body text-center p-3">
                                                <i class="bi bi-diagram-3 fs-1 text-warning mb-2"></i>
                                                <div class="fw-bold">Penugasan Guru</div>
                                                <small class="text-muted">Mapel & kelas</small>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <a href="mapel.php" class="card quick-action-card text-decoration-none h-100">
                                            <div class="card-body text-center p-3">
                                                <i class="bi bi-journal-text fs-1 text-secondary mb-2"></i>
                                                <div class="fw-bold">Mata Pelajaran</div>
                                                <small class="text-muted">Data mapel</small>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <a href="tahun_ajaran.php" class="card quick-action-card text-decoration-none h-100">
                                            <div class="card-body text-center p-3">
                                                <i class="bi bi-calendar fs-1 text-dark mb-2"></i>
                                                <div class="fw-bold">Tahun Ajaran</div>
                                                <small class="text-muted">Pengaturan TA</small>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <a href="laporan.php" class="card quick-action-card text-decoration-none h-100">
                                            <div class="card-body text-center p-3">
                                                <i class="bi bi-graph-up fs-1 text-danger mb-2"></i>
                                                <div class="fw-bold">Laporan</div>
                                                <small class="text-muted">Report & analytics</small>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- System Overview -->
                        <div class="card shadow">
                            <div class="card-header bg-white py-3">
                                <h6 class="m-0 font-weight-bold text-primary">System Overview</h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6 class="text-muted mb-3">Status Sistem</h6>
                                        <div class="list-group list-group-flush">
                                            <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                                                <span>Database Connection</span>
                                                <span class="badge bg-success">Connected</span>
                                            </div>
                                            <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                                                <span>Tahun Ajaran Aktif</span>
                                                <span class="badge bg-<?= $tahunAktif ? 'success' : 'danger' ?>">
                                                    <?= $tahunAktif ? 'Aktif' : 'Tidak Aktif' ?>
                                                </span>
                                            </div>
                                            <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                                                <span>User Session</span>
                                                <span class="badge bg-success">Active</span>
                                            </div>
                                            <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                                                <span>System Version</span>
                                                <span class="badge bg-info">v2.0</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <h6 class="text-muted mb-3">Coverage Wali Kelas</h6>
                                        <div class="progress mb-3" style="height: 20px;">
                                            <div class="progress-bar bg-success" role="progressbar" 
                                                 style="width: <?= $stats['total_kelas'] > 0 ? (count($waliKelas) / $stats['total_kelas']) * 100 : 0 ?>%"
                                                 aria-valuenow="<?= count($waliKelas) ?>" 
                                                 aria-valuemin="0" 
                                                 aria-valuemax="<?= $stats['total_kelas'] ?>">
                                                <?= $stats['total_kelas'] > 0 ? round((count($waliKelas) / $stats['total_kelas']) * 100) : 0 ?>%
                                            </div>
                                        </div>
                                        <p class="small text-muted">
                                            <strong><?= count($waliKelas) ?></strong> dari <strong><?= $stats['total_kelas'] ?></strong> kelas sudah memiliki wali kelas
                                        </p>
                                        
                                        <h6 class="text-muted mb-3 mt-4">Guru Bertugas</h6>
                                        <p class="small text-muted">
                                            <strong><?= $stats['guru_aktif'] ?? 0 ?></strong> dari <strong><?= $stats['total_guru'] ?? 0 ?></strong> guru memiliki penugasan mengajar
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <!-- Recent Activity -->
                        <div class="card shadow mb-4">
                            <div class="card-header bg-white py-3">
                                <h6 class="m-0 font-weight-bold text-primary">Aktivitas Terbaru</h6>
                            </div>
                            <div class="card-body">
                                <?php if (!empty($recentActivity)): ?>
                                    <div class="list-group list-group-flush">
                                        <?php foreach ($recentActivity as $activity): ?>
                                        <div class="list-group-item px-0 py-2">
                                            <div class="d-flex w-100 justify-content-between">
                                                <h6 class="mb-1"><?= htmlspecialchars($activity['nama']) ?></h6>
                                                <small class="text-muted">
                                                    <?= Helper::formatDate($activity['created_at'], 'H:i') ?>
                                                </small>
                                            </div>
                                            <p class="mb-1 small"><?= $activity['action'] ?></p>
                                            <small class="text-muted">
                                                <?= Helper::formatDate($activity['created_at'], 'd M') ?>
                                            </small>
                                        </div>
                                        <?php endforeach; ?>
                                    </div>
                                    <div class="text-center mt-3">
                                        <a href="log_aktivitas.php" class="btn btn-sm btn-outline-primary">
                                            Lihat Semua Aktivitas
                                        </a>
                                    </div>
                                <?php else: ?>
                                    <p class="text-muted text-center py-3">
                                        <i class="bi bi-info-circle"></i><br>
                                        Belum ada aktivitas
                                    </p>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Wali Kelas Terbaru -->
                        <div class="card shadow mb-4">
                            <div class="card-header bg-white py-3">
                                <h6 class="m-0 font-weight-bold text-primary">Wali Kelas Terbaru</h6>
                            </div>
                            <div class="card-body">
                                <?php if (!empty($waliKelas)): ?>
                                    <div class="list-group list-group-flush">
                                        <?php 
                                        $recentWaliKelas = array_slice($waliKelas, 0, 3);
                                        foreach ($recentWaliKelas as $wk): 
                                        ?>
                                        <div class="list-group-item px-0 py-2">
                                            <div class="d-flex align-items-center">
                                                <div class="flex-shrink-0">
                                                    <i class="bi bi-person-circle text-teal"></i>
                                                </div>
                                                <div class="flex-grow-1 ms-2">
                                                    <div class="fw-bold small"><?= htmlspecialchars($wk['nama_guru']) ?></div>
                                                    <small class="text-muted"><?= htmlspecialchars($wk['nama_kelas']) ?></small>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endforeach; ?>
                                    </div>
                                    <div class="text-center mt-3">
                                        <a href="wali_kelas.php" class="btn btn-sm btn-outline-teal">
                                            Kelola Wali Kelas
                                        </a>
                                    </div>
                                <?php else: ?>
                                    <p class="text-muted text-center py-3">
                                        <i class="bi bi-person-gear"></i><br>
                                        Belum ada wali kelas
                                    </p>
                                    <div class="text-center">
                                        <a href="wali_kelas.php" class="btn btn-sm btn-teal">
                                            Tambah Wali Kelas
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- System Info -->
                        <div class="card shadow">
                            <div class="card-header bg-white py-3">
                                <h6 class="m-0 font-weight-bold text-primary">System Info</h6>
                            </div>
                            <div class="card-body">
                                <div class="text-center mb-3">
                                    <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center" 
                                         style="width: 80px; height: 80px;">
                                        <i class="bi bi-speedometer2 fs-2"></i>
                                    </div>
                                </div>
                                <p class="text-center">
                                    Selamat datang di <strong>Sistem Penilaian v2.0</strong><br>
                                    <small class="text-muted">Multi-Tahun Ajaran & Wali Kelas</small>
                                </p>
                                <div class="small text-muted text-center">
                                    <i class="bi bi-clock"></i> Login: <?= date('H:i') ?><br>
                                    <i class="bi bi-person"></i> User: <?= htmlspecialchars($userData['nama']) ?><br>
                                    <i class="bi bi-shield-check"></i> Role: <?= htmlspecialchars($userData['level']) ?>
                                </div>
                                <div class="text-center mt-3">
                                    <div class="btn-group">
                                        <a href="profile.php" class="btn btn-sm btn-outline-primary">
                                            <i class="bi bi-person"></i> Profile
                                        </a>
                                        <a href="settings.php" class="btn btn-sm btn-outline-secondary">
                                            <i class="bi bi-gear"></i> Settings
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        .text-teal { color: #20c997; }
        .btn-teal { 
            background-color: #20c997; 
            border-color: #20c997;
            color: white;
        }
        .btn-teal:hover {
            background-color: #199d7a;
            border-color: #199d7a;
        }
        .btn-outline-teal {
            color: #20c997;
            border-color: #20c997;
        }
        .btn-outline-teal:hover {
            background-color: #20c997;
            border-color: #20c997;
            color: white;
        }
    </style>
</body>
</html>