<?php
require_once __DIR__ . '/../../app/config/config.php';
Session::checkAuth();
Session::checkRole(['admin']);

$adminModel = new AdminModel();
$tahunAktif = $adminModel->getActiveTahunAjaran();
$guruMapel = $tahunAktif ? $adminModel->getGuruMapelByTahun($tahunAktif['id']) : [];
$guru = $adminModel->getAllGuru();
$mapel = $adminModel->getAllMapel();
$kelas = $adminModel->getAllKelas();

$success = $_GET['success'] ?? '';
$error = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['assign_guru'])) {
    if (!$tahunAktif) {
        $error = "Tidak ada tahun ajaran aktif!";
    } else {
        $data = [
            'guru_id' => intval($_POST['guru_id']),
            'mapel_id' => intval($_POST['mapel_id']),
            'kelas_id' => intval($_POST['kelas_id']),
            'tahun_ajaran_id' => $tahunAktif['id']
        ];
        
        if ($adminModel->assignGuruMapel($data)) {
            Helper::redirect('assignment.php?success=1');
        } else {
            $error = "Gagal menugaskan guru! Penugasan mungkin sudah ada.";
        }
    }
}

// Handle remove assignment
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['remove_assignment'])) {
    $assignmentId = intval($_POST['assignment_id']);
    if ($adminModel->removeGuruMapel($assignmentId)) {
        Helper::redirect('assignment.php?success=2');
    } else {
        $error = "Gagal menghapus penugasan!";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Penugasan Guru - Sistem Penilaian</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body>
    <?php include __DIR__ . '/includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include __DIR__ . '/includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Penugasan Guru</h1>
                    <div>
                        <?php if ($tahunAktif): ?>
                        <span class="badge bg-success me-2">
                            <?= $tahunAktif['tahun_ajaran'] ?> - <?= ucfirst($tahunAktif['semester']) ?>
                        </span>
                        <?php endif; ?>
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#assignModal">
                            <i class="bi bi-plus-circle"></i> Tambah Penugasan
                        </button>
                    </div>
                </div>

                <?php if ($success == '1'): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        Penugasan guru berhasil ditambahkan!
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php elseif ($success == '2'): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        Penugasan berhasil dihapus!
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php if ($error): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?= $error ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php if (!$tahunAktif): ?>
                <div class="alert alert-warning">
                    <i class="bi bi-exclamation-triangle"></i> 
                    Tidak ada tahun ajaran yang aktif. Silakan aktifkan tahun ajaran terlebih dahulu.
                </div>
                <?php endif; ?>

                <!-- Summary Cards -->
                <div class="row mb-4">
                    <div class="col-xl-3 col-md-6 mb-3">
                        <div class="card bg-primary text-white">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <div class="text-value"><?= count($guruMapel) ?></div>
                                        <div>Total Penugasan</div>
                                    </div>
                                    <div class="align-self-center">
                                        <i class="bi bi-diagram-3 fs-3 opacity-50"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-md-6 mb-3">
                        <div class="card bg-success text-white">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <div class="text-value">
                                            <?= count(array_unique(array_column($guruMapel, 'guru_id'))) ?>
                                        </div>
                                        <div>Guru Bertugas</div>
                                    </div>
                                    <div class="align-self-center">
                                        <i class="bi bi-person-check fs-3 opacity-50"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-md-6 mb-3">
                        <div class="card bg-info text-white">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <div class="text-value">
                                            <?= count(array_unique(array_column($guruMapel, 'mapel_id'))) ?>
                                        </div>
                                        <div>Mapel Diajar</div>
                                    </div>
                                    <div class="align-self-center">
                                        <i class="bi bi-journal-text fs-3 opacity-50"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-md-6 mb-3">
                        <div class="card bg-warning text-white">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <div class="text-value">
                                            <?= count(array_unique(array_column($guruMapel, 'kelas_id'))) ?>
                                        </div>
                                        <div>Kelas Tercover</div>
                                    </div>
                                    <div class="align-self-center">
                                        <i class="bi bi-house-door fs-3 opacity-50"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card shadow">
                    <div class="card-header bg-white d-flex justify-content-between align-items-center">
                        <h6 class="mb-0">Daftar Penugasan Guru</h6>
                        <small class="text-muted">
                            Tahun Ajaran: <?= $tahunAktif ? $tahunAktif['tahun_ajaran'] : '-' ?>
                        </small>
                    </div>
                    <div class="card-body">
                        <?php if (!empty($guruMapel)): ?>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Guru</th>
                                            <th>Mata Pelajaran</th>
                                            <th>Kelas</th>
                                            <th>Tingkat</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($guruMapel as $gm): ?>
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="flex-shrink-0">
                                                        <i class="bi bi-person-circle text-muted"></i>
                                                    </div>
                                                    <div class="flex-grow-1 ms-2">
                                                        <div class="fw-bold"><?= htmlspecialchars($gm['nama_guru']) ?></div>
                                                        <small class="text-muted">NIP: <?= htmlspecialchars($gm['nip']) ?></small>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="fw-bold"><?= htmlspecialchars($gm['nama_mapel']) ?></div>
                                                <small class="text-muted"><?= htmlspecialchars($gm['kode_mapel']) ?></small>
                                            </td>
                                            <td>
                                                <span class="badge bg-info"><?= htmlspecialchars($gm['nama_kelas']) ?></span>
                                            </td>
                                            <td>
                                                <span class="badge bg-secondary">Kelas <?= $gm['tingkat'] ?></span>
                                            <?php if ($gm['jurusan']): ?>
                                                <br><small class="text-muted"><?= $gm['jurusan'] ?></small>
                                            <?php endif; ?>
                                            </td>
                                            <td>
                                                <form method="POST" style="display: inline;">
                                                    <input type="hidden" name="assignment_id" value="<?= $gm['id'] ?>">
                                                    <button type="submit" name="remove_assignment" 
                                                            class="btn btn-sm btn-outline-danger"
                                                            onclick="return confirm('Hapus penugasan ini?')">
                                                        <i class="bi bi-trash"></i> Hapus
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <div class="text-center py-5">
                                <i class="bi bi-diagram-3 fs-1 text-muted d-block mb-3"></i>
                                <h5 class="text-muted">Belum ada penugasan guru</h5>
                                <p class="text-muted">Tambahkan penugasan pertama untuk memulai</p>
                                <?php if ($tahunAktif): ?>
                                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#assignModal">
                                    <i class="bi bi-plus-circle"></i> Tambah Penugasan Pertama
                                </button>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <!-- Assign Modal -->
    <div class="modal fade" id="assignModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST">
                    <div class="modal-header">
                        <h5 class="modal-title">Tugaskan Guru ke Mapel & Kelas</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <?php if ($tahunAktif): ?>
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle"></i>
                            Tahun Ajaran: <strong><?= $tahunAktif['tahun_ajaran'] ?></strong><br>
                            Semester: <strong><?= ucfirst($tahunAktif['semester']) ?></strong>
                        </div>
                        
                        <div class="mb-3">
                            <label for="guru_id" class="form-label">Pilih Guru</label>
                            <select class="form-select" id="guru_id" name="guru_id" required>
                                <option value="">Pilih Guru</option>
                                <?php foreach ($guru as $g): ?>
                                <option value="<?= $g['id'] ?>">
                                    <?= htmlspecialchars($g['nama']) ?> (<?= htmlspecialchars($g['nip']) ?>)
                                </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="mapel_id" class="form-label">Mata Pelajaran</label>
                            <select class="form-select" id="mapel_id" name="mapel_id" required>
                                <option value="">Pilih Mata Pelajaran</option>
                                <?php foreach ($mapel as $m): ?>
                                <option value="<?= $m['id'] ?>">
                                    <?= htmlspecialchars($m['kode_mapel']) ?> - <?= htmlspecialchars($m['nama_mapel']) ?>
                                </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="kelas_id" class="form-label">Kelas</label>
                            <select class="form-select" id="kelas_id" name="kelas_id" required>
                                <option value="">Pilih Kelas</option>
                                <?php foreach ($kelas as $k): ?>
                                <option value="<?= $k['id'] ?>">
                                    <?= htmlspecialchars($k['nama_kelas']) ?> (Kelas <?= $k['tingkat'] ?>)
                                    <?php if ($k['jurusan']): ?> - <?= $k['jurusan'] ?><?php endif; ?>
                                </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <?php else: ?>
                        <div class="alert alert-warning">
                            <i class="bi bi-exclamation-triangle"></i>
                            Tidak dapat menambah penugasan karena tidak ada tahun ajaran aktif.
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <?php if ($tahunAktif): ?>
                        <button type="submit" name="assign_guru" class="btn btn-primary">Simpan Penugasan</button>
                        <?php endif; ?>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>