<?php
require_once 'BaseModel.php';

class UserModel extends BaseModel {
    protected $table = 'users';
    
    public function login($username, $password) {
        $sql = "SELECT u.*, 
                       s.id as siswa_id, s.nis, s.kelas_id, s.status as siswa_status,
                       g.id as guru_id, g.nip
                FROM users u
                LEFT JOIN siswa s ON u.id = s.user_id AND s.status = 'aktif'
                LEFT JOIN guru g ON u.id = g.user_id
                WHERE u.username = ?";
        
        $stmt = $this->executeQuery($sql, [$username]);
        
        if ($stmt) {
            $user = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($user && password_verify($password, $user['password'])) {
                return $user;
            }
        }
        
        return false;
    }
}
?>