<?php
class SiswaModel extends BaseModel {
    
    public function getNilaiSiswa($siswaId) {
        $tahunAktif = $this->getActiveTahunAjaran();
        
        $sql = "SELECT * FROM view_nilai_siswa 
                WHERE siswa_id = ? AND tahun_ajaran_id = ?
                ORDER BY kode_mapel, kode_tp";
        
        return $this->executeQuery($sql, [$siswaId, $tahunAktif['id']])->fetchAll(PDO::FETCH_ASSOC);
    }
    
    public function getTranskrip($siswaId) {
        $sql = "SELECT * FROM view_transkrip_siswa 
                WHERE siswa_id = ?
                ORDER BY tahun_ajaran DESC, semester DESC, kode_mapel";
        
        return $this->executeQuery($sql, [$siswaId])->fetchAll(PDO::FETCH_ASSOC);
    }
    
    public function getProfile($siswaId) {
        $sql = "SELECT s.*, u.nama, u.username, k.nama_kelas, k.tingkat, k.jurusan
                FROM siswa s
                JOIN users u ON s.user_id = u.id
                JOIN kelas k ON s.kelas_id = k.id
                WHERE s.id = ?";
        
        return $this->executeQuery($sql, [$siswaId])->fetch(PDO::FETCH_ASSOC);
    }
}
?>