<?php
class LogModel extends BaseModel {
    protected $table = 'log_aktivitas';
    
    public function getRecentLogs($limit = 10) {
        $sql = "SELECT la.*, u.username, u.nama 
                FROM log_aktivitas la
                JOIN users u ON la.user_id = u.id
                ORDER BY la.created_at DESC 
                LIMIT ?";
        
        $stmt = $this->executeQuery($sql, [$limit]);
        return $stmt ? $stmt->fetchAll(PDO::FETCH_ASSOC) : [];
    }
    
    public function getLogsByUser($userId, $limit = 20) {
        $sql = "SELECT * FROM log_aktivitas 
                WHERE user_id = ? 
                ORDER BY created_at DESC 
                LIMIT ?";
        
        $stmt = $this->executeQuery($sql, [$userId, $limit]);
        return $stmt ? $stmt->fetchAll(PDO::FETCH_ASSOC) : [];
    }
}
?>