<?php
class BaseModel {
    protected $db;
    protected $table;
    
    public function __construct($table = null) {
        // Include database dengan path yang benar
        require_once __DIR__ . '/../config/database.php';
        
        $database = new Database();
        $this->db = $database->getConnection();
        $this->table = $table;
    }
    
    protected function executeQuery($sql, $params = []) {
        try {
            $stmt = $this->db->prepare($sql);
            $stmt->execute($params);
            return $stmt;
        } catch (PDOException $e) {
            error_log("Query Error: " . $e->getMessage());
            return false;
        }
    }
}
?>