<?php
// app/controllers/AuthController.php
class AuthController {
    private $userModel;
    
    public function __construct() {
        $this->userModel = new UserModel();
    }
    
    public function login() {
        if ($_POST) {
            $username = $_POST['username'] ?? '';
            $password = $_POST['password'] ?? '';
            
            $user = $this->userModel->login($username, $password);
            
            if ($user) {
                Session::start();
                Session::set('user_id', $user['id']);
                Session::set('username', $user['username']);
                Session::set('nama', $user['nama']);
                Session::set('level', $user['level']);
                Session::set('siswa_id', $user['siswa_id']);
                Session::set('guru_id', $user['guru_id']);
                
                // Redirect based on role
                switch ($user['level']) {
                    case 'admin':
                        header('Location: admin/dashboard.php');
                        break;
                    case 'guru':
                        header('Location: guru/dashboard.php');
                        break;
                    case 'siswa':
                        header('Location: siswa/dashboard.php');
                        break;
                }
                exit;
            } else {
                $error = "Username atau password salah!";
            }
        }
        
        // Load login view
        include 'app/views/auth/login.php';
    }
    
    public function logout() {
        Session::destroy();
        header('Location: login.php');
        exit;
    }
}
?>