<?php// app/controllers/AdminController.php
class AdminController {
    private $adminModel;
    
    public function __construct() {
        $this->adminModel = new AdminModel();
    }
    
    public function dashboard() {
        Session::checkAuth();
        Session::checkRole(['admin']);
        
        $stats = $this->adminModel->getSystemStats();
        include 'app/views/admin/dashboard.php';
    }
    
    public function manageSiswa() {
        Session::checkAuth();
        Session::checkRole(['admin']);
        
        $siswa = $this->adminModel->getAllSiswa();
        $kelas = $this->adminModel->getAllKelas();
        
        if ($_POST) {
            $result = $this->adminModel->addSiswa($_POST);
            if ($result) {
                $success = "Siswa berhasil ditambahkan!";
                header('Location: ?action=siswa&success=1');
                exit;
            } else {
                $error = "Gagal menambah siswa!";
            }
        }
        
        include 'app/views/admin/siswa.php';
    }
}
?>