<?php
session_start();

// FLEKSIBEL UNTUK SEMUA HOSTING
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || $_SERVER['SERVER_PORT'] == 443 ? "https" : "http";
$host = $_SERVER['HTTP_HOST'];

// Method 1: Otomatis detect public folder
$scriptDir = dirname($_SERVER['SCRIPT_NAME']);
if (strpos($scriptDir, '/public') !== false) {
    $basePath = substr($scriptDir, 0, strpos($scriptDir, '/public'));
} else {
    $basePath = dirname($scriptDir);
}

define('BASE_URL', $protocol . '://' . $host . $basePath . '/public/');

// Error handling adaptif
if (in_array($_SERVER['HTTP_HOST'], ['localhost', '127.0.0.1']) || strpos($_SERVER['HTTP_HOST'], '.local') !== false) {
    // Development
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    // Production
    error_reporting(0);
    ini_set('display_errors', 0);
}

// Include required files dengan path absolut
require_once __DIR__ . '/database.php';
require_once __DIR__ . '/Session.php';
require_once __DIR__ . '/Helper.php';

// Include models - SESUAIKAN DENGAN STRUKTUR ANDA
$modelsPath = __DIR__ . '/../models/';
if (file_exists($modelsPath . 'BaseModel.php')) {
    require_once $modelsPath . 'BaseModel.php';
    require_once $modelsPath . 'AdminModel.php';
    require_once $modelsPath . 'UserModel.php';
    require_once $modelsPath . 'GuruModel.php'; // TAMBAHKAN INI
    require_once $modelsPath . 'SiswaModel.php';
    require_once $modelsPath . 'LogModel.php';
} else {
    // Fallback jika struktur berbeda
    error_log("Models not found in: " . $modelsPath);
}
?>