<?php
class Session {
    public static function start() {
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
    }
    
    public static function set($key, $value) {
        $_SESSION[$key] = $value;
    }
    
    public static function get($key) {
        return $_SESSION[$key] ?? null;
    }
    
    public static function destroy() {
        session_destroy();
        $_SESSION = array();
    }
    
    public static function checkAuth($redirect = true) {
        self::start();
        if (!self::get('user_id')) {
            if ($redirect) {
                header('Location: ' . BASE_URL . 'auth/login.php');
                exit;
            }
            return false;
        }
        return true;
    }
    
    public static function checkRole($allowedRoles, $redirect = true) {
        if (!self::checkAuth($redirect)) return false;
        
        $userRole = self::get('level');
        if (!in_array($userRole, $allowedRoles)) {
            if ($redirect) {
                header('Location: ' . BASE_URL . 'unauthorized.php');
                exit;
            }
            return false;
        }
        return true;
    }
    
    public static function getUserData() {
        return [
            'user_id' => self::get('user_id'),
            'username' => self::get('username'),
            'nama' => self::get('nama'),
            'level' => self::get('level'),
            'siswa_id' => self::get('siswa_id'),
            'guru_id' => self::get('guru_id')
        ];
    }
}
?>