<?php
class Helper {
    public static function redirect($url) {
        header("Location: " . $url);
        exit;
    }
    
    public static function sanitize($data) {
        return htmlspecialchars(strip_tags(trim($data)));
    }
    
    public static function formatDate($date, $format = 'd-m-Y') {
        return date($format, strtotime($date));
    }
    
    public static function showMessage($type, $message) {
        $class = $type == 'success' ? 'alert-success' : 'alert-danger';
        return "<div class='alert $class alert-dismissible fade show' role='alert'>
                $message
                <button type='button' class='btn-close' data-bs-dismiss='alert'></button>
            </div>";
    }
    
    // Tambahkan method logActivity
    public static function logActivity($userId, $action, $tableName, $recordId, $oldData = null, $newData = null) {
        require_once __DIR__ . '/../config/database.php';
        $database = new Database();
        $db = $database->getConnection();
        
        $sql = "INSERT INTO log_aktivitas (user_id, action, table_name, record_id, old_data, new_data) 
                VALUES (?, ?, ?, ?, ?, ?)";
        
        try {
            $stmt = $db->prepare($sql);
            $stmt->execute([$userId, $action, $tableName, $recordId, $oldData, $newData]);
            return true;
        } catch (PDOException $e) {
            error_log("Log Error: " . $e->getMessage());
            return false;
        }
    }
}
?>