<?php
require_once '../config/config.php';

header('Content-Type: application/json');

// Check if request is AJAX
if (empty($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) != 'xmlhttprequest') {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Forbidden']);
    exit;
}

Session::checkAuth(false);
Session::checkRole(['admin'], false);

if (!Session::get('user_id')) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

$action = $_POST['action'] ?? '';
$adminModel = new AdminModel();

switch ($action) {
    case 'get_siswa':
        $siswaId = intval($_POST['siswa_id'] ?? 0);
        if ($siswaId > 0) {
            $siswa = $adminModel->getSiswaById($siswaId);
            if ($siswa) {
                echo json_encode(['success' => true, 'data' => $siswa]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Siswa tidak ditemukan']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'ID siswa tidak valid']);
        }
        break;
        
    case 'delete_siswa':
        $siswaId = intval($_POST['siswa_id'] ?? 0);
        if ($siswaId > 0) {
            // Soft delete - update status to nonaktif
            $result = $adminModel->executeQuery(
                "UPDATE siswa SET status = 'nonaktif', updated_at = NOW() WHERE id = ?",
                [$siswaId]
            );
            
            if ($result) {
                Helper::logActivity(
                    Session::get('user_id'),
                    'HAPUS_SISWA',
                    'siswa',
                    $siswaId
                );
                echo json_encode(['success' => true, 'message' => 'Siswa berhasil dihapus']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Gagal menghapus siswa']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'ID siswa tidak valid']);
        }
        break;
        
    default:
        echo json_encode(['success' => false, 'message' => 'Action tidak valid']);
        break;
}
?>